require "prefabutil"
local brain = require "brains/chesterbrain"

local WAKE_TO_FOLLOW_DISTANCE = 14
local SLEEP_NEAR_LEADER_DISTANCE = 7

local assets =
{
    Asset("ANIM", "anim/ui_chester_shadow_3x4.zip"),
    Asset("ANIM", "anim/ui_chest_3x3.zip"),

    Asset("ANIM", "anim/chester.zip"),
    Asset("ANIM", "anim/lty_dogoo_build.zip"),


    Asset("SOUND", "sound/chester.fsb"),
    Asset("SOUND", "sound/open.fsb"),
}

local prefabs =
{
    "chesterlight",
    "chester_transform_fx",
}

local sounds =
{
    hurt = "dontstarve/creatures/chester/hurt",
    pant = "dontstarve/creatures/chester/pant",
    death = "dontstarve/creatures/chester/death",
    open = "open/music/open",
    close = "open/music/open",
    pop = "dontstarve/creatures/chester/pop",
    boing = "dontstarve/creatures/chester/boing",
    lick = "dontstarve/creatures/chester/lick",
}

local function ShouldWakeUp(inst)
    return DefaultWakeTest(inst) or not inst.components.follower:IsNearLeader(WAKE_TO_FOLLOW_DISTANCE)
end

local function ShouldSleep(inst)
    --print(inst, "ShouldSleep", DefaultSleepTest(inst), not inst.sg:HasStateTag("open"), inst.components.follower:IsNearLeader(SLEEP_NEAR_LEADER_DISTANCE))
    return DefaultSleepTest(inst) and not inst.sg:HasStateTag("open") and inst.components.follower:IsNearLeader(SLEEP_NEAR_LEADER_DISTANCE) and not TheWorld.state.isfullmoon
end

local function ShouldKeepTarget()
    return false -- dogoo can't attack, and won't sleep if he has a target
end

local function OnOpen(inst)
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("open")
    end
end

local function OnClose(inst)
    if not inst.components.health:IsDead() and inst.sg.currentstate.name ~= "transition" then
        inst.sg:GoToState("close")
    end
	local container = inst.components.container
	for i = 1, container:GetNumSlots() do
		local item = container:GetItemInSlot(i)
		if item and item.prefab=="lty_eyebone"  then
			container:DropItem(item)
		end
	end
end

-- eye bone was killed/destroyed
local function OnStopFollowing(inst)
    --print("dogoo - OnStopFollowing")
    inst:RemoveTag("companion")
end

local function OnStartFollowing(inst)
    --print("dogoo - OnStartFollowing")
    inst:AddTag("companion")
end

local slotpos_3x3 = {}

for y = 2, 0, -1 do
    for x = 0, 2 do
        table.insert(slotpos_3x3, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
    end
end
	

local function create_dogoo()
    --print("dogoo - create_dogoo")

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
   -- inst.entity:AddMiniMapEntity()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 2, 1.25 )
	if IsDLCEnabled(CAPY_DLC) then
	MakeAmphibiousCharacterPhysics(inst, 75, .5)
    else
	MakeCharacterPhysics(inst, 75, .5)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)
    end
    inst:AddTag("companion")
    inst:AddTag("character")
    inst:AddTag("scarytoprey")
    inst:AddTag("personal_dogoo")
    inst:AddTag("notraptrigger")
	
    inst:AddTag("_named")
	inst:AddTag("lty_dogoo")
	inst:AddTag("fridge")
    --inst.MiniMapEntity:SetIcon("personal_dogoo.tex")
    --inst.MiniMapEntity:SetCanUseCache(false)

    inst.AnimState:SetBank("dogoo")
    inst.AnimState:SetBuild("lty_dogoo_build")

    inst.DynamicShadow:SetSize(2, 1.5)

    inst.Transform:SetFourFaced()
	-- Dogoo will not be saved normally. He is saved with the player.
	--inst.persists = false

    ------------------------------------------

    --print("   combat")
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "dogoo_body"
    inst.components.combat:SetKeepTargetFunction(ShouldKeepTarget)
	local self = inst.components.combat
	local old = self.GetAttacked
	function self:GetAttacked(attacker, damage, weapon, stimuli)
		if attacker then
			return true
		end
		return old(self, attacker, damage, weapon, stimuli)
	end
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.CHESTER_HEALTH)
    inst.components.health:StartRegen(TUNING.CHESTER_HEALTH_REGEN_AMOUNT, TUNING.CHESTER_HEALTH_REGEN_PERIOD)
    inst:AddTag("noauradamage")

    --print("   inspectable")
    inst:AddComponent("inspectable")
    inst.components.inspectable:RecordViews()
    --inst.components.inspectable.getstatus = GetStatus
    inst.components.inspectable.nameoverride = "dogoo"

    --print("   locomotor")
    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = 3
    inst.components.locomotor.runspeed = 7

    --print("   follower")
	inst:AddComponent("follower")
    inst:ListenForEvent("stopfollowing", OnStopFollowing)
    inst:ListenForEvent("startfollowing", OnStartFollowing)

    if SaveGameIndex:IsModeShipwrecked() then
	inst.components.follower:SetFollowExitDestinations({EXIT_DESTINATION.LAND,EXIT_DESTINATION.WATER})
	end

    --print("   knownlocations")
    inst:AddComponent("knownlocations")

    --print("   burnable")
    MakeSmallBurnableCharacter(inst, "dogoo_body")

    --("   container")
    inst:AddComponent("container")
	    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose

    inst.components.container:SetNumSlots(#slotpos_3x3)
  
    inst.components.container.widgetslotpos = slotpos_3x3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160


    --print("   sleeper")
    inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
    inst.components.sleeper.testperiod = GetRandomWithVariance(6, 2)
    inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)
	

	inst:AddComponent("named")
	
	inst:DoPeriodicTask(5,function()
		if  inst.components.follower then
			if inst.components.follower.leader==nil then
				inst.components.container:DropEverything()
				inst:Remove() 
			end
		end
	end)
	
   -- MakeHauntableDropFirstItem(inst)
    --[[AddHauntableCustomReaction(inst, function(inst, haunter)
        if math.random() <= TUNING.HAUNT_CHANCE_ALWAYS then
            inst.components.hauntable.panic = true
            inst.components.hauntable.panictimer = TUNING.HAUNT_PANIC_TIME_SMALL
            inst.components.hauntable.hauntvalue = TUNING.HAUNT_SMALL
            return true
        end
        return false
    end, false, false, true)--]]

    --print("   sg")
    inst:SetStateGraph("SGchester")
    inst.sg:GoToState("idle")

    --print("   brain")
    inst:SetBrain(brain)

    inst.DogooState = "NORMAL"

	
    inst.sounds = sounds

  	--inst.LinkToPlayer = linktoplayer
	--inst.UnlinkToPlayer = unlinktoplayer

    --print("dogoo - create_dogoo END")
	
		
    return inst
end

return Prefab("common/lty_dogoo", create_dogoo, assets, prefabs)
