local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING
if GLOBAL.TheSim.RAILGetPlatform and GLOBAL.TheSim:RAILGetPlatform() == "TGP" then
      for _, mod in ipairs(GLOBAL.ModManager.mods) do 
           if mod and mod.modinfo and mod.modinfo.id == "Super DryingRack" then
                GLOBAL.KnownModIndex:Disable("Super DryingRack")
          end
      end

     GLOBAL.Shutdown()
end

Assets = 
{
	Asset( "ATLAS", "images/inventoryimages/fish_dried.xml" ),
	Asset("ANIM", "anim/fish_dried.zip"),

	Asset("ANIM", "anim/crow_dring.zip"),
	Asset("ANIM", "anim/robin_dring.zip"),
	Asset("ANIM", "anim/robin_winter_dring.zip"),
	Asset("ANIM", "anim/seagull_dring.zip"),
	Asset("ANIM", "anim/parrot_dring.zip"),
	Asset("ANIM", "anim/parrot_pirate_dring.zip"),
	Asset("ANIM", "anim/toucan_dring.zip"),
	Asset("ANIM", "anim/dead_swordfish_dring.zip"),
	Asset("ANIM", "anim/fish_med_dring.zip"),
	Asset("ANIM", "anim/tropical_fish_dring.zip"),
	Asset("ANIM", "anim/fish_raw_dring.zip"),
	
	Asset("ANIM", "anim/jerky_dried.zip"),
	Asset("ANIM", "anim/jerky_dried_idle.zip"),
}

PrefabFiles = {
	"jerky_dried",
    "fish_dried",
}

AddIngredientValues({"jerky_dried"}, {fish=2, meat=1})
AddIngredientValues({"fish_dried"}, {fish=1, meat=0.5})

GLOBAL.STRINGS.NAMES.JERKY_DRIED = "Fishjerky Dried"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.JERKY_DRIED = "Big fish dried."

GLOBAL.STRINGS.NAMES.FISH_DRIED = "Fish Dried"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.FISH_DRIED = "This is local's specialty."

local function AddPrefabPostInitItems(inst)
	if not inst:HasTag("dryable") then
		inst:AddTag("dryable")
	end
	if inst.components.dryable == nil then
		inst:AddComponent("dryable")
		inst.components.dryable:SetProduct("smallmeat_dried")
		inst.components.dryable:SetDryTime(TUNING.DRY_FAST)
	end

end

local adddring={
	"crow",
	"robin",
	"robin_winter",
	"seagull",
	"parrot",
	"parrot_pirate",
	"toucan",
}

for k,v in pairs(adddring) do		
	AddPrefabPostInit(v, AddPrefabPostInitItems)
end

local addfish={
	"dead_swordfish",
	"fish_med",
	"fish_raw",
}

local function AddPrefabPostInitFish(inst)
	
	if inst.components.dryable then
		inst.components.dryable:SetProduct("jerky_dried")
	end

end

for k,v in pairs(addfish) do		
	AddPrefabPostInit(v, AddPrefabPostInitFish)
end


local function AddPrefabPostInitFish2(inst)
	
	if inst.components.dryable then
		inst.components.dryable:SetProduct("fish_dried")
	end

end
AddPrefabPostInit("fish", AddPrefabPostInitFish2)
AddPrefabPostInit("tropical_fish", AddPrefabPostInitFish2)



local function AddPrefabPostInitMeatRack(inst)
	local assets =
	{   --old
	    Asset("ANIM", "anim/meat_rack.zip"),
	    Asset("ANIM", "anim/meat_rack_food.zip"),
	    Asset("ANIM", "anim/meat.zip"),

	    Asset("ANIM", "anim/meat_monster.zip"),
	    Asset("ANIM", "anim/meat_small.zip"),
	    Asset("ANIM", "anim/meat_human.zip"),
	    Asset("ANIM", "anim/drumstick.zip"),
	    Asset("ANIM", "anim/meat_rack_food.zip"),
	    Asset("ANIM", "anim/batwing.zip"),
	    Asset("ANIM", "anim/plant_meat.zip"),
	    Asset("ANIM", "anim/eel.zip"),

	    ----new
	    Asset("ANIM", "anim/crow_dring.zip"),
	    Asset("ANIM", "anim/canary_dring.zip"),
	    Asset("ANIM", "anim/robin_dring.zip"),
	    Asset("ANIM", "anim/robin_winter_dring.zip"),
		Asset("ANIM", "anim/seagull_dring.zip"),
		Asset("ANIM", "anim/parrot_dring.zip"),
		Asset("ANIM", "anim/parrot_pirate_dring.zip"),
		Asset("ANIM", "anim/toucan_dring.zip"),
		Asset("ANIM", "anim/dead_swordfish_dring.zip"),
		Asset("ANIM", "anim/fish_med_dring.zip"),
		Asset("ANIM", "anim/tropical_fish_dring.zip"),
		Asset("ANIM", "anim/fish_raw_dring.zip"),
		
		Asset("ANIM", "anim/jerky_dried.zip"),
	    Asset("ANIM", "anim/fish_dried.zip"),
	}

	local prefabs =
	{
	    --old
	    "smallmeat",
	    "smallmeat_dried",
	    "monstermeat",
	    "monstermeat_dried",
	    "humanmeat",
	    "humanmeat_dried",
	    "meat",
	    "meat_dried",
	    "drumstick",
	    "batwing",
	    "fish",
	    "froglegs",
	    "eel",
	    "collapse_small",

	    ----new
	    "crow",
	    "robin",
	    "robin_winter",
		"seagull",
		"parrot",
		"parrot_pirate",
		"toucan",
		
		"jerky_dried",
		"fish_med",
		"tropical_fish",
		"fish_raw",
	    "fish_dried",

	}
	local function myOverrideSymbol(inst, myfood ,sourfntag)
	
		if sourfntag == "drying" then
			if myfood == "crow" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			elseif myfood == "robin" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			elseif myfood == "robin_winter" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			elseif myfood == "seagull" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			elseif myfood == "parrot" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			elseif myfood == "parrot_pirate" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			elseif myfood == "toucan" then
				inst.AnimState:OverrideSymbol("swap_dried", myfood.."_dring", myfood)
			else
				inst.AnimState:OverrideSymbol("swap_dried", "meat_rack_food", myfood)
			end
		elseif sourfntag == "dried" then
			if myfood == "jerky_dried" then
				inst.AnimState:OverrideSymbol("swap_dried", "jerky_dried", "jerky_dried")
			elseif myfood == "fish_dried" then
				inst.AnimState:OverrideSymbol("swap_dried", "fish_dried", myfood)
			else
				inst.AnimState:OverrideSymbol("swap_dried", "meat_rack_food", myfood)
			end
		end
	end
	
	local function onstartdrying(inst, myfood)
		if not inst:HasTag("burnt") then
			inst.AnimState:PlayAnimation("drying_pre")
			inst.AnimState:PushAnimation("drying_loop", true)
			myOverrideSymbol(inst, myfood ,"drying")
		end
	end

	local function ondonedrying(inst, product)
			inst.AnimState:PlayAnimation("drying_pst")
			inst.AnimState:PushAnimation("idle_full", false)
		myOverrideSymbol(inst, product ,"dried")
	end
	
	if inst.components.dryer then
		inst.components.dryer:SetStartDryingFn(onstartdrying)
		inst.components.dryer:SetContinueDryingFn(onstartdrying)
		inst.components.dryer:SetDoneDryingFn(ondonedrying)
		inst.components.dryer:SetContinueDoneFn(ondonedrying)
	end
	
end
AddPrefabPostInit("meatrack", AddPrefabPostInitMeatRack)
