local assets =
{	
	Asset("ANIM", "anim/karassword.zip"),
	Asset("ANIM", "anim/swap_karassword.zip"),
	Asset( "IMAGE", "images/inventoryimages/karassword.tex" ),
	Asset ("ATLAS", "images/inventoryimages/karassword.xml"),
}

local function onfinished(inst)
	inst:Remove()
end

local prefabs =
{
    "crow"
}

local function monsterkill(inst, owner)
    local st_pt =  owner:GetPosition()
		if st_pt then
			local st1 = SpawnPrefab("crow")
			local st2 = SpawnPrefab("collapse_small")
			st1.Transform:SetPosition(st_pt.x, st_pt.y, st_pt.z)
			st2.Transform:SetPosition(st_pt.x, st_pt.y, st_pt.z)
	end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_karassword", "swap_ruins_bat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	inst:ListenForEvent("entity_death", function() monsterkill(inst, owner) end , GetWorld())
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst:RemoveEventCallback("entity_death", function() monsterkill(inst, owner) end , GetWorld())
end

--Sacrifice Life
local function onattack(inst, owner, target)
	owner.components.sanity:DoDelta(-1)
	
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()	
    MakeInventoryPhysics(inst)
    
    anim:SetBank("ruins_bat")
    anim:SetBuild("karassword")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(68)
	inst.components.weapon.onattack = onattack


    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
    inst.components.finiteuses:SetOnFinished( onfinished)
    -------
    inst:AddComponent("blinkstaff")
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/karassword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip)

    
    return inst
end

return Prefab( "common/inventory/karassword", fn, assets)