local Assets =
{
	Asset("ANIM", "anim/monster_kabobs.zip"),
    Asset("ATLAS", "images/inventoryimages/monster_kabobs.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("monster_kabobs")
	inst.AnimState:SetBuild("monster_kabobs")
	inst.AnimState:PlayAnimation("idle", false)

	inst:AddComponent("edible")
	inst.components.edible.ismeat = true
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.healthvalue = (-3)
	inst.components.edible.hungervalue = (35)
	inst.components.edible.sanityvalue = (-6)

	inst:AddComponent("inspectable")
	inst:AddComponent("bait")
	
	inst:AddTag("monstermeat")
	inst:AddTag("catfood")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/monster_kabobs.xml"

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"

	return inst
end


return Prefab( "common/inventory/monster_kabobs", fn, Assets )