local Assets =
{
	Asset("ANIM", "anim/honey_monster_ham.zip"),
    Asset("ATLAS", "images/inventoryimages/honey_monster_ham.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("honey_monster_ham")
	inst.AnimState:SetBuild("honey_monster_ham")
	inst.AnimState:PlayAnimation("idle", false)

	inst:AddComponent("edible")
	inst.components.edible.ismeat = true
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.healthvalue = (25)
	inst.components.edible.hungervalue = (85)
	inst.components.edible.sanityvalue = (-30)

	inst:AddComponent("inspectable")
	inst:AddComponent("bait")
	
	inst:AddTag("monstermeat")
	inst:AddTag("catfood")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/honey_monster_ham.xml"

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"

	return inst
end


return Prefab( "common/inventory/honey_monster_ham", fn, Assets )