local Assets =
{
	Asset("ANIM", "anim/devil_pierogi.zip"),
    Asset("ATLAS", "images/inventoryimages/devil_pierogi.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function devil_pierogifn(inst, eater)
		local pt = Vector3(eater.Transform:GetWorldPosition())
		eater:StartThread(function()
			for k = 1, 9 do
				local theta = math.random() * 2 * PI
				local radius = math.random(9, 24)
				local result_offset = FindValidPositionByFan(theta, radius, 12, function(offset)
					local x,y,z = (pt + offset):Get()
					local ents = TheSim:FindEntities(x,y,z , 1)
					return not next(ents) 
				end)
				if result_offset then
					local crawlinghorror = SpawnPrefab("crawlinghorror")
					crawlinghorror.Transform:SetPosition((pt + result_offset):Get())
					GetPlayer().components.playercontroller:ShakeCamera(eater, "FULL", 0.2, 0.02, .25, 40)
					local fx = SpawnPrefab("splash_ocean")
					local pos = pt + result_offset
					fx.Transform:SetPosition(pos.x, pos.y, pos.z)
					crawlinghorror.sg:GoToState("attack_pre")
				end
				Sleep(.33)
			end
		end)
		return true
end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("devil_pierogi")
	inst.AnimState:SetBuild("devil_pierogi")
	inst.AnimState:PlayAnimation("idle", false)

	inst:AddComponent("inspectable")
	
	inst:AddComponent("edible")
	inst.components.edible.ismeat = true
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.healthvalue = (25)
	inst.components.edible.hungervalue = (12)
	inst.components.edible.sanityvalue = (-15)
    inst.components.edible:SetOnEatenFn(devil_pierogifn)
	
	inst:AddComponent("bait")
	
	inst:AddTag("monstermeat")
	inst:AddTag("catfood")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/devil_pierogi.xml"

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"

	return inst
end


return Prefab( "common/inventory/devil_pierogi", fn, Assets )