local Assets =
{
	Asset("ANIM", "anim/blackhoney_nuggets.zip"),
    Asset("ATLAS", "images/inventoryimages/blackhoney_nuggets.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("blackhoney_nuggets")
	inst.AnimState:SetBuild("blackhoney_nuggets")
	inst.AnimState:PlayAnimation("idle", false)

	inst:AddComponent("edible")
	inst.components.edible.ismeat = true
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.healthvalue = (20)
	inst.components.edible.hungervalue = (37.5)
	inst.components.edible.sanityvalue = (-15)

	inst:AddComponent("inspectable")
	inst:AddComponent("bait")
	
	inst:AddTag("monstermeat")
	inst:AddTag("catfood")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/blackhoney_nuggets.xml"

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"

	return inst
end


return Prefab( "common/inventory/blackhoney_nuggets", fn, Assets )