local require = GLOBAL.require

modimport("scripts/cookpotfix.lua")

Assets = {
	Asset( "IMAGE", "images/inventoryimages/monster_meatballs.tex" ),
	Asset( "ATLAS", "images/inventoryimages/monster_meatballs.xml" ),

	Asset( "IMAGE", "images/inventoryimages/monster_meaty_stew.tex" ),
	Asset( "ATLAS", "images/inventoryimages/monster_meaty_stew.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/devil_pierogi.tex" ),
	Asset( "ATLAS", "images/inventoryimages/devil_pierogi.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/monster_kabobs.tex" ),
	Asset( "ATLAS", "images/inventoryimages/monster_kabobs.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/monster_chili.tex" ),
	Asset( "ATLAS", "images/inventoryimages/monster_chili.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/blackhoney_nuggets.tex" ),
	Asset( "ATLAS", "images/inventoryimages/blackhoney_nuggets.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/honey_monster_ham.tex" ),
	Asset( "ATLAS", "images/inventoryimages/honey_monster_ham.xml" ),
}

PrefabFiles = {
	"monster_meatballs",
	"monster_meaty_stew",
	"devil_pierogi",
	"monster_kabobs",
	"monster_chili",
	"blackhoney_nuggets",
	"honey_monster_ham",
}

local monster_meatballs_recipe = {	
		name = "monster_meatballs",
		test = function(cooker, names, tags) return tags.monster == 1 and not tags.inedible end,
		priority = 1,
		weight = 1,
		foodtype = "MEAT",
		health = -10,
		hunger = 58,
		perishtime = TUNING.PERISH_MED,
		sanity = -20,
		cooktime = .75,
		tags = {"monstermeat"},
	}
AddCookerRecipe("cookpot", monster_meatballs_recipe)
GLOBAL.STRINGS.NAMES.MONSTER_MEATBALLS = "Monster_Meatballs"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.MONSTER_MEATBALLS = "This thing violates scientific principles."
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.MONSTER_MEATBALLS = "Just to survive, to eat."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MONSTER_MEATBALLS = "Really don't want to eat"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.MONSTER_MEATBALLS = "Maybe it's the Devil's product."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MONSTER_MEATBALLS = "A look is full of toxic meatballs, I'd better not try"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.MONSTER_MEATBALLS = "Still dangerous."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.MONSTER_MEATBALLS = "This meatball is poisonous."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MONSTER_MEATBALLS = "What the hell is this thing made of?"
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.MONSTER_MEATBALLS = "Believe me, this is absolutely poisonous."
GLOBAL.STRINGS.CHARACTERS.WALANI.DESCRIBE.MONSTER_MEATBALLS = "The smell of evil."
GLOBAL.STRINGS.CHARACTERS.WARLY.DESCRIBE.MONSTER_MEATBALLS = "No matter what you add, it's not edible."
GLOBAL.STRINGS.CHARACTERS.WOODLEGS.DESCRIBE.MONSTER_MEATBALLS = "I'm going to go chew the bones."


local monster_meaty_stew_recipe = {	
		name = "monster_meaty_stew",
		test = function(cooker, names, tags) return tags.monster >= 3 and not tags.inedible end,
		priority = 11,
		weight = 1,
		foodtype = "MEAT",
		health = -15,
		hunger = 170,
		perishtime = TUNING.PERISH_MED,
		sanity = -45,
		temperature = TUNING.HOT_FOOD_BONUS_TEMP,
		temperatureduration = TUNING.FOOD_TEMP_LONG,
		cooktime = .75,
		tags = {"monstermeat"},
	}
AddCookerRecipe("cookpot", monster_meaty_stew_recipe)
GLOBAL.STRINGS.NAMES.MONSTER_MEATY_STEW = "Monster_Meaty_Stew"
GLOBAL.STRINGS.CHARACTERS.WARLY.DESCRIBE.MONSTER_MEATBALLS = "It's a waste of ingredients."


local devil_pierogi_recipe = {	
		name = "devil_pierogi",
		test = function(cooker, names, tags) return tags.monster == 1 and tags.veggie and tags.egg and not tags.inedible and not names.berries end,
		priority = 10,
		weight = 1,
		foodtype = "MEAT",
		health = 25,
		hunger = 12,
		perishtime = TUNING.PERISH_PRESERVED,
		sanity = -15,
		cooktime = 1,
		tags = {"monstermeat"},
	}
AddCookerRecipe("cookpot", devil_pierogi_recipe)
GLOBAL.STRINGS.NAMES.DEVIL_PIEROGI = "Devil_Pierogi"


local monster_kabobs_recipe = {	
		name = "monster_kabobs",
		test = function(cooker, names, tags) return names.twigs == 1 and tags.monster == 1 end,
		priority = 9,
		weight = 1,
		foodtype = "MEAT",
		health = -3,
		hunger = 35,
		perishtime = TUNING.PERISH_SLOW,
		sanity = -6,
		cooktime = 2,
		tags = {"monstermeat"},
	}
AddCookerRecipe("cookpot", monster_kabobs_recipe)
GLOBAL.STRINGS.NAMES.MONSTER_KABOBS = "Monster_Kabobs"


local monster_chili_recipe = {	
		name = "monster_chili",
		test = function(cooker, names, tags) return tags.monster and tags.veggie == 2 and tags.meat == 2 end,
		priority = 12,
		weight = 1,
		foodtype = "MEAT",
		health = -10,
		hunger = 37.5,
		perishtime = TUNING.PERISH_MED,
		sanity = -35,
		temperature = TUNING.HOT_FOOD_BONUS_TEMP,
		temperatureduration = TUNING.FOOD_TEMP_LONG,
		cooktime = .5,
		tags = {"monstermeat"},
	}
AddCookerRecipe("cookpot", monster_chili_recipe)
GLOBAL.STRINGS.NAMES.MONSTER_CHILI = "Monster_Chili"


local blackhoney_nuggets_recipe = {	
		name = "blackhoney_nuggets",
		test = function(cooker, names, tags) return names.honey and tags.monster == 1 and tags.meat <= 2 and not tags.inedible end,
		priority = 11,
		weight = 1,
		foodtype = "MEAT",
		health = 20,
		hunger = 37.5,
		perishtime = TUNING.PERISH_SLOW,
		sanity = -15,
		cooktime = 2,
		tags = {"monstermeat"},{"honeyed"}
	}
AddCookerRecipe("cookpot", blackhoney_nuggets_recipe)
GLOBAL.STRINGS.NAMES.BLACKHONEY_NUGGETS = "Blackhoney_Nuggets"


local honey_monster_ham_recipe = {	
		name = "honey_monster_ham",
		test = function(cooker, names, tags) return names.honey == 1 and tags.monster == 2 and not tags.inedible end,
		priority = 11,
		weight = 1,
		foodtype = "MEAT",
		health = 25,
		hunger = 85,
		perishtime = TUNING.PERISH_SLOW,
		sanity = -30,
		temperature = TUNING.HOT_FOOD_BONUS_TEMP,
		temperatureduration = TUNING.FOOD_TEMP_AVERAGE,
		cooktime = 2,
		tags = {"monstermeat"},{"honeyed"}
	}
AddCookerRecipe("cookpot", honey_monster_ham_recipe)
GLOBAL.STRINGS.NAMES.HONEY_MONSTER_HAM = "Honey_Monster_Ham"