require "prefabutil" local cooking = require("cooking")  local prefabs = { "rowboat_wake", "boat_hit_fx", "boat_hit_fx_raft_log", "boat_hit_fx_raft_bamboo", "boat_hit_fx_rowboat", "boat_hit_fx_cargoboat", "boat_hit_fx_armoured", "flotsam_armoured", "flotsam_bamboo", "flotsam_cargo", "flotsam_lograft", "flotsam_rowboat", "flotsam_surfboard", "woodlegs_boatcannon", "woodlegssail", "woodlegs_cannonshot", "myironwind", }  local soundprefix = "researchlab" local name = "researchlab"  local myboatassets = { Asset("ANIM", "anim/rowboat_basic.zip"), Asset("ANIM", "anim/my_boat_build.zip"), Asset("ANIM", "anim/boat_hud_raft.zip"), Asset("ANIM", "anim/boat_inspect_raft.zip"), Asset("ANIM", "anim/flotsam_rowboat_build.zip"), Asset("ANIM", "anim/my_boat_placer.zip"), }  local function boat_perish(inst)  if inst.components.drivable.driver then  local driver = inst.components.drivable.driver  driver.components.driver:OnDismount(true)  driver.components.health:Kill("drowning")  inst.SoundEmitter:PlaySound(inst.sinksound) if inst.components.container then inst.components.container:DropEverything() end inst:Remove() end end    local function onhit(inst, worker) inst.AnimState:PlayAnimation("hit") inst.AnimState:PushAnimation("run_loop", true) end  local function onhammered(inst, worker) inst.components.lootdropper:DropLoot()     if inst.components.container then         inst.components.container:DropEverything()     end SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition()) inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood") inst:Remove() end  local function onmounted(inst) inst:RemoveComponent("workable") end  local function ondismounted(inst) inst:AddComponent("workable") inst.components.workable:SetWorkAction(ACTIONS.HAMMER)     inst.components.workable:SetWorkLeft(4)     inst.components.workable:SetOnFinishCallback(onhammered) inst.components.workable:SetOnWorkCallback(onhit) end  local function onopen(inst) if inst.components.drivable.driver == nil then inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/HUD_boat_inventory_open") end end  local function onclose(inst) if inst.components.drivable.driver == nil then inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/HUD_boat_inventory_close") end end  local function dostew(inst) inst.task = nil if inst.product ~= nil then  inst.components.container:Open(inst.components.drivable.driver) local myproduct = SpawnPrefab(inst.product)  myproduct.Transform:SetPosition(inst.Transform:GetWorldPosition()) myproduct.components.inventoryitem:OnDropped(true) inst.product = nil end end  local function StartCooking(inst) if inst.product then return end  local spoilage_total = 0 local spoilage_n = 0 local ings = {} for k,v in pairs (inst.components.container.slots) do table.insert(ings, v.prefab) if v.components.perishable then spoilage_n = spoilage_n + 1 spoilage_total = spoilage_total + v.components.perishable:GetPercent() end end inst.product_spoilage = 1 if spoilage_total > 0 then inst.product_spoilage = spoilage_total / spoilage_n inst.product_spoilage = 1 - (1 - inst.product_spoilage)*.5 end   local foundthespecial = false local cooktime = 1 local cooker = "cookpot" inst.product, cooktime = cooking.CalculateRecipe(cooker, ings) inst.productcooker = cooker local grow_time = TUNING.BASE_COOK_TIME * cooktime inst.targettime = GetTime() + grow_time inst.task = inst:DoTaskInTime(grow_time, dostew) inst.components.container:Close() inst.components.container:DestroyContents() end  local widgetbuttoninfo = { text = "Cook", position = Vector3( -200,0 , 0), fn = function(inst) print("Cooking!") StartCooking(inst) end,  validfn = function(inst) return true end, }  local function itemtest(inst, item, slot) if cooking.IsCookingIngredient(item.prefab) then return true end end  local function onload(inst, data) if data and data.product and data.time then inst.product = data.product local time = data.time inst.targettime = GetTime() + time inst.task = inst:DoTaskInTime(time, dostew) end end  local function onsave(inst, data) local time = GetTime()     if inst.product then local data = {} data.product = inst.product if inst.targettime and inst.targettime > time then data.time = inst.targettime - time end return data end end  local function setupcontainer(inst, slots, bank, build, inspectslots, inspectbank, inspectbuild, inspectboatbadgepos, inspectboatequiproot) inst:AddComponent("container") inst.components.container:SetNumSlots(#slots) inst.components.container.itemtestfn = itemtest inst.components.container.type = "boat" inst.components.container.side_align_tip = -500 inst.components.container.canbeopened = false inst.components.container.widgetbuttoninfo = widgetbuttoninfo inst.components.container.acceptsstacks = false inst.components.container.onopenfn = onopen inst.components.container.onclosefn = onclose  inst.components.container.widgetslotpos = slots inst.components.container.widgetanimbank = bank inst.components.container.widgetanimbuild = build inst.components.container.widgetboatbadgepos = Vector3(0, 40, 0) inst.components.container.widgetequipslotroot = Vector3(-80, 40, 0)   local boatwidgetinfo = {} boatwidgetinfo.widgetslotpos = inspectslots boatwidgetinfo.widgetanimbank = inspectbank boatwidgetinfo.widgetanimbuild = inspectbuild boatwidgetinfo.widgetboatbadgepos = inspectboatbadgepos boatwidgetinfo.widgetpos = Vector3(200, 0, 0) boatwidgetinfo.widgetequipslotroot = inspectboatequiproot inst.components.container.boatwidgetinfo = boatwidgetinfo end     local function commonfn(Sim) local inst = CreateEntity() local trans = inst.entity:AddTransform() trans:SetFourFaced() inst.no_wet_prefix = true  inst:AddTag("boat")  local anim = inst.entity:AddAnimState()  inst.entity:AddSoundEmitter()  inst.entity:AddPhysics() inst.Physics:SetCylinder(0.25,2)  inst:AddComponent("inspectable") inst:AddComponent("drivable")  inst.waveboost = TUNING.WAVEBOOST  inst.sailmusic = "sailing"  inst:AddComponent("rowboatwakespawner")  inst:AddComponent("boathealth") inst.components.boathealth:SetDepletedFn(boat_perish)      inst:AddComponent("workable")     inst.components.workable:SetWorkAction(ACTIONS.HAMMER)     inst.components.workable:SetWorkLeft(4)     inst.components.workable:SetOnFinishCallback(onhammered) inst.components.workable:SetOnWorkCallback(onhit)  inst:AddComponent("lootdropper")      inst:AddComponent("repairable")     inst.components.repairable.repairmaterial = "boat"      inst.components.repairable.onrepaired = function(inst, doer, repair_item) if inst.SoundEmitter then inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/boatrepairkit") end end      inst:ListenForEvent("mounted", onmounted)     inst:ListenForEvent("dismounted", ondismounted)      inst.onhammered = onhammered    inst:AddComponent("flotsamspawner")  return inst end  local function myboatfn(sim) local inst = commonfn(sim) local slotpos = {} for i = 4, 1,-1 do table.insert(slotpos, Vector3(-13-(80*i), 55 ,0)) end  local inspectslotpos = {} for y = 0, 1 do for x = 0, 1 do table.insert(inspectslotpos, Vector3(-40 + (x*80), 70 + (y*-75),0)) end end  setupcontainer(inst, slotpos, "boat_hud_encrusted", "boat_hud_encrusted", inspectslotpos, "boat_inspect_encrusted", "boat_inspect_encrusted", {x=0, y=155}, {x=40, y=70})  inst.AnimState:SetBuild("my_boat_build") inst.AnimState:SetBank("rowboat") inst.AnimState:PlayAnimation("run_loop", true)  inst.components.container.hasboatequipslots = true inst.components.container.enableboatequipslots = false  local minimap = inst.entity:AddMiniMapEntity() minimap:SetPriority( 5 ) minimap:SetIcon("rowboat.png")  inst.perishtime = TUNING.ARMOUREDBOAT_PERISHTIME inst.components.boathealth.maxhealth = TUNING.WOODLEGSBOAT_HEALTH inst.components.boathealth:SetHealth(TUNING.WOODLEGSBOAT_HEALTH, inst.perishtime) inst.components.boathealth.leakinghealth = TUNING.WOODLEGSBOAT_LEAKING_HEALTH  inst.landsound = "dontstarve_DLC002/common/boatjump_land_shell" inst.sinksound = "dontstarve_DLC002/common/boat_sinking_rowboat"  inst.components.boathealth.damagesound = "dontstarve_DLC002/common/boat_damage_armoured"  inst.components.drivable.sanitydrain = TUNING.ROWBOAT_SANITY_DRAIN inst.components.drivable.runspeed = TUNING.ROWBOAT_SPEED inst.components.drivable.runanimation = "row_loop" inst.components.drivable.prerunanimation = "row_pre" inst.components.drivable.postrunanimation = "row_pst" inst.components.drivable.overridebuild = "my_boat_build" inst.components.drivable.flotsambuild = "flotsam_armoured_build" inst.components.drivable.hitfx = "boat_hit_fx_armoured" inst.components.drivable.maprevealbonus = TUNING.MAPREVEAL_WOODLEGSBOAT_BONUS inst.components.drivable.creaksound = "dontstarve_DLC002/common/boat_creaks_armoured" inst.components.drivable:SetHitImmunity(TUNING.WOODLEGSBOAT_HIT_IMMUNITY)  inst.components.flotsamspawner.flotsamprefab = "flotsam_rowboat"  inst:ListenForEvent( "onbuilt", function() local sail = SpawnPrefab("myironwind") local cannon = SpawnPrefab("woodlegs_boatcannon") inst.components.container:Equip(sail) inst.components.container:Equip(cannon) end)  inst.OnSave = onsave inst.OnLoad = onload  return inst end   STRINGS.NAMES.MYBOAT = "海上餐厅" STRINGS.CHARACTERS.GENERIC.DESCRIBE.MYBOAT = "移动的烹饪锅~" STRINGS.RECIPE_DESC.MYBOAT = "在你的船上做饭吧！"   return Prefab( "common/objects/myboat", myboatfn, myboatassets, prefabs), MakePlacer( "common/myboat_placer", "my_boat_placer", "my_boat_placer", "idle", false, false, false)