﻿local timeSinceLastUpdate = 0
local UpdateInterval = 0.3 -- try to update frames every 300ms

local TableTargetBuffs = {}
local TableFocusBuffs = {}
local AuxTable = {}
local ok, errorMsg

function DispelFrames_OnUpdate(self, elapsed)
  timeSinceLastUpdate = timeSinceLastUpdate + elapsed; 	

  while (timeSinceLastUpdate > UpdateInterval) do
	if (DispelBorder.db.profile.showTargetFrame) then
		ok, errorMsg = pcall(DispelFrames_UpdateAuras,DispelFrames_TargetFrame, "target", TableTargetBuffs)
		if not ok then
			--print("error -> wiping tables")
			DispelFrames_WipeFrameTable(TableTargetBuffs)
			break
		end
	end
	if (DispelBorder.db.profile.showFocusFrame) then
		ok, errorMsg = pcall(DispelFrames_UpdateAuras,DispelFrames_FocusFrame, "focus", TableFocusBuffs)
		if not ok then
			--print("error -> wiping tables")
			DispelFrames_WipeFrameTable(TableFocusBuffs)
			break
		end
	end
    timeSinceLastUpdate = timeSinceLastUpdate - UpdateInterval;
  end
end

function DispelFrames_UpdateAuras(self, unit, buffsTable)
	self.maxBuffs = 32
	local frame, frameName;
	local frameIcon, frameCount, frameCooldown;
	local name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable;
	local frameStealable;
	local numBuffs = 0;
	local selfName = self:GetName();
	local canAssist = UnitCanAssist("player", unit);
	local isEnemy = UnitCanAttack("player", unit);
	AuxTable = {}
	local indexLastBuffShown = 1 -- can't use 'i' to anchor buffs due to not showing every buff
	for i = 1, MAX_TARGET_BUFFS do
		name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable = UnitBuff(unit, i);
		frameName = selfName.."Buff"..indexLastBuffShown;
		frame = buffsTable[name];
		if ( not frame ) then
			if ( not icon ) then
				break;
			else
				if (isStealable) then
					frame = CreateFrame("Button", frameName, self);
					frame.unit = "target";
					frame:SetWidth(32); frame:SetHeight(32)
					
					-- Anchor:
					if indexLastBuffShown == 1 then 
						frame:SetPoint("TOPLEFT", self, "TOPLEFT", 0, 0)
					else
						frame:SetPoint("TOPLEFT", (selfName.."Buff"..indexLastBuffShown-1) , "TOPRIGHT", 4, 0) -- aqui
					end
					
					-- Icon:
					frame:SetNormalTexture(icon)
					
					-- Stealable Border:
					frame.StealBorderTexture = frame:CreateTexture(name.."StealBorder", "BACKGROUND")
					frame.StealBorderTexture:SetWidth(frame:GetWidth()+2)
					frame.StealBorderTexture:SetHeight(frame:GetHeight()+2)
					frame.StealBorderTexture:SetPoint("Center")
					frame.StealBorderTexture:SetTexture(0, 0, 1)
					
					-- Cooldown:
					frame.CooldownFrame = CreateFrame("CoolDown", frameName.."CoolDown", frame)
					frame.CooldownFrame:SetAllPoints(frame)
					frame.CooldownFrame:SetWidth(32)
					frame.CooldownFrame:SetHeight(32)
					
					-- Stacks:
					if (count > 0 ) then
						frame.Stacks = frame:CreateFontString(nil, "OVERLAY")
						frame.Stacks:SetFont("Fonts\\FRIZQT__.TTF",14, "OUTLINE")
						frame.Stacks:SetShadowOffset(1, -1)
						frame.Stacks:SetShadowColor(0,0,0,1)
						frame.Stacks:SetPoint("RIGHT", 0, -6)
						frame.Stacks:SetWidth(26)
						frame.Stacks:SetHeight(16)
						frame.Stacks:SetJustifyH("RIGHT")
						frame.Stacks:SetText(count)
					end

					--print("Frame -"..frameName.."- created in ["..name.."]")
					buffsTable[name] = frame
				end
			end
		end
		if ( icon and isStealable and ( not self.maxBuffs or indexLastBuffShown <= self.maxBuffs ) ) then
			frame:SetID(indexLastBuffShown);
			AuxTable[name] = frame
			frame:Show()
			if ( duration > 0 ) then
				frame.CooldownFrame:SetDrawEdge(true)
				frame.CooldownFrame:SetReverse(true)
				frame.CooldownFrame:SetCooldown(expirationTime - duration, duration)
				frame.CooldownFrame:Show();
			else
				frame.CooldownFrame:Hide();
			end

			numBuffs = numBuffs + 1;
			
			if (isStealable) then
				indexLastBuffShown = indexLastBuffShown + 1
			end
		end
	end
	
	-- Get rid of unused frames:
	for k, v in pairs(buffsTable) do
		if not AuxTable[k] then
			buffsTable[k]:Hide()
			buffsTable[k]:SetParent(nil)
			buffsTable[k] = nil
			
		end
	end
	buffsTable = {}
	buffsTable = AuxTable

	DispelFrames_UpdateAuraPositions(self, buffsTable)
end

function DispelFrames_UpdateAuraPositions(parentFrame, buffsTable)
	local AuraPosition = 1
	local lastAura = nil
	for k, v in pairs(buffsTable) do
		if (AuraPosition == 1) then
			v:SetPoint("TOPLEFT", parentFrame, "TOPLEFT", 0, 0)
		else
			v:SetPoint("TOPLEFT", lastAura, "TOPRIGHT", 4, 0)
		end
		lastAura = v
		AuraPosition = AuraPosition + 1
	end
end

function DispelFrames_WipeFrameTable(buffsTable)
	for k, v in pairs(buffsTable) do
		buffsTable[k]:Hide()
		buffsTable[k]:SetParent(nil)
		buffsTable[k] = nil
	end
end

function DispelFrames_OnEvent(self,event,...)
	if event == "PLAYER_TARGET_CHANGED" then
		DispelFrames_WipeFrameTable(TableTargetBuffs)
	elseif event == "FOCUS_CHANGED" then
		DispelFrames_WipeFrameTable(TableFocusBuffs)
	end
end

function DispelFrames_ToggleTargetFrame(info, value)
	DispelBorder.db.profile.showTargetFrame = value
	if ( DispelBorder.db.profile.showTargetFrame ) then
		DispelFrames_TargetFrame:Show()
	else
		DispelFrames_TargetFrame:Hide()
		DispelFrames_WipeFrameTable(TableTargetBuffs)
	end
end

function DispelFrames_ToggleFocusFrame(info, value)
	DispelBorder.db.profile.showFocusFrame = value
	if ( DispelBorder.db.profile.showFocusFrame ) then
		DispelFrames_FocusFrame:Show()
	else
		DispelFrames_FocusFrame:Hide()
		DispelFrames_WipeFrameTable(TableFocusBuffs)
	end
end

function DispelFrames_LockFrames(info, value)
	DispelBorder.db.profile.lockFrames = value
	if (DispelBorder.db.profile.lockFrames) then
		-- lock frames:
		
		-- target:
		DispelFrames_TargetFrame:EnableMouse(false)
        DispelFrames_TargetFrame:RegisterForDrag(nil)
		if (DispelFrames_TargetFrame.Background) then
			DispelFrames_TargetFrame.Background:SetTexture(nil)
			DispelFrames_TargetFrame.Background = nil
		end
		if (DispelFrames_TargetFrame.FrameName_TargetString) then
			DispelFrames_TargetFrame.FrameName_TargetString:SetText(nil)
		end
		
		-- focus:
		DispelFrames_FocusFrame:EnableMouse(false)
        DispelFrames_FocusFrame:RegisterForDrag(nil)
		if (DispelFrames_FocusFrame.Background) then
			DispelFrames_FocusFrame.Background:SetTexture(nil)
			DispelFrames_FocusFrame.Background = nil
		end
		if (DispelFrames_FocusFrame.FrameName_FocusString) then
			DispelFrames_FocusFrame.FrameName_FocusString:SetText(nil)
		end
	else
		-- unlock frames:
		
		-- target:
		DispelFrames_TargetFrame:EnableMouse(true)
        DispelFrames_TargetFrame:RegisterForDrag("LeftButton")
		if (not DispelFrames_TargetFrame.Background) then
			DispelFrames_TargetFrame.Background = DispelFrames_TargetFrame:CreateTexture("DispelBorder_TargetBackground", "BACKGROUND")
		end
		DispelFrames_TargetFrame.Background:SetTexture(0.8, 0.8, 0.8)
		DispelFrames_TargetFrame.Background:SetAllPoints(DispelFrames_TargetFrame)
		if (not DispelFrames_TargetFrame.FrameName_TargetString) then
			DispelFrames_TargetFrame.FrameName_TargetString = DispelFrames_TargetFrame:CreateFontString("FontFrameName_Target","OVERLAY", "GameFontNormal")
		end
		DispelFrames_TargetFrame.FrameName_TargetString:SetPoint("TOP", 0 , -18)
		DispelFrames_TargetFrame.FrameName_TargetString:SetText("目标Buff")
		
		-- focus:
		DispelFrames_FocusFrame:EnableMouse(true)
        DispelFrames_FocusFrame:RegisterForDrag("LeftButton")
		if (not DispelFrames_FocusFrame.Background) then
			DispelFrames_FocusFrame.Background = DispelFrames_FocusFrame:CreateTexture("DispelBorder_FocusBackground", "BACKGROUND")
		end
		DispelFrames_FocusFrame.Background:SetTexture(0.8, 0.8, 0.8)
		DispelFrames_FocusFrame.Background:SetAllPoints(DispelFrames_FocusFrame)
		if (not DispelFrames_FocusFrame.FrameName_FocusString) then
			DispelFrames_FocusFrame.FrameName_FocusString = DispelFrames_FocusFrame:CreateFontString("FontFrameName_Focus","OVERLAY", "GameFontNormal")
		end
		DispelFrames_FocusFrame.FrameName_FocusString:SetPoint("TOP", 0 , -18)
		DispelFrames_FocusFrame.FrameName_FocusString:SetText("焦点Buff")
	end
end


