﻿-- Based on dispelborder v1.6.0, enhaced by Trotam:
-- Removed all code related to Unit Aura.
-- Created two new frames to see clearly just the dispellable buffs from target and focus.



-- this is where I can easily add localization for Enrage tooltip reading
-- thanks norya for German translation
-- Enrage is a tricky spell to track and may cause false positives in some mobs
local ENRAGE_STRING
if (GetLocale() == "enUS") then
	ENRAGE_STRING = "Enrage"
elseif (GetLocale() == "deDE") then 
	ENRAGE_STRING = "Wut"
elseif (GetLocale() == "esES") then 
	ENRAGE_STRING = "Rabiar"
else
	ENRAGE_STRING = "Enrage"
end

-- our main frame
DispelBorder = LibStub("AceAddon-3.0"):NewAddon("DispelBorder", "AceEvent-3.0", "AceConsole-3.0")

-- our tooltip frame so we can look for enrage buffs
local DBT = CreateFrame("GameTooltip","DispelBorderTooltip", nil, "GameTooltipTemplate")

-- AceConfig options tree
local options = {
	order = 1,
	name = "DispelBorder",
	handler = DispelBorder,
	type = "group",
	args = {
		General = {
			order = 1,
			type = "group",
			name = "综合设置",
			desc = "General Settings",
			args = {
				desc = {
					type = "description",
					order = 1,
					name = "Version 1.1",
				},
				desc2 = {
					type = "description",
					order = 2,
					name = "在界面上的一个可移动的框体中显示你的当前目标、焦点身上可驱散的效果，由网易魔兽插件站汉化发布.",
				},
				desc3 = {
					type = "description",
					order = 3,
					name = "本插件还在头像下面的Buff中为可驱散的Buff加上边框，使得更醒目。",
				},
				hdr1 = {
					type = "header",
					name = "目标Buff",
					order = 4,
				},
				enabletarget = {
					type = "toggle",
					order = 5,
					width = "double",
					name = "启用",
					desc = "Enables/disables border around dispellable buffs",
					get = function() return DispelBorder.db.profile.enabletarget end,
					set = function() DispelBorder.db.profile.enabletarget = not DispelBorder.db.profile.enabletarget end,
				},
				enlargetarget = {
					type = "toggle",
					order = 6,
					width = "double",
					name = "放大可驱散的敌对Buff",
					desc = "Shows the dispellable buff as enlarged, as if you had casted it. Will work similarly with any unitframe addon that distinguishes buffs you casted.",
					get = function() return DispelBorder.db.profile.enlargetarget end,
					set = function() DispelBorder.db.profile.enlargetarget = not DispelBorder.db.profile.enlargetarget end,
				},
				enlargesstarget = {
					type = "toggle",
					order = 7,
					width = "double",
					name = "放大可偷取的Buff",
					desc = "Enlarges buffs that are actually spellstealable for a mage (mage only)",
					get = function() return DispelBorder.db.profile.enlargesstarget end,
					set = function() DispelBorder.db.profile.enlargesstarget = not DispelBorder.db.profile.enlargesstarget end,
				},
				hdr2 = {
					type = "header",
					name = "焦点Buff",
					order = 8,
				},
				enablefocus = {
					type = "toggle",
					order = 9,
					width = "double",
					name = "启用",
					desc = "Enables/disables border around dispellable buffs",
					get = function() return DispelBorder.db.profile.enablefocus end,
					set = function() DispelBorder.db.profile.enablefocus = not DispelBorder.db.profile.enablefocus end,
				},
				enlargefocus = {
					type = "toggle",
					order = 10,
					width = "double",
					name = "放大可驱散的敌对Buff",
					desc = "Shows the dispellable buff as enlarged, as if you had casted it. Will work similarly with any unitframe addon that distinguishes buffs you casted.",
					get = function() return DispelBorder.db.profile.enlargefocus end,
					set = function() DispelBorder.db.profile.enlargefocus = not DispelBorder.db.profile.enlargefocus end,
				},
				enlargessfocus = {
					type = "toggle",
					order = 11,
					width = "double",
					name = "放大可偷取的Buff",
					desc = "Enlarges buffs that are actually spellstealable for a mage (mage only)",
					get = function() return DispelBorder.db.profile.enlargessfocus end,
					set = function() DispelBorder.db.profile.enlargessfocus = not DispelBorder.db.profile.enlargessfocus end,
				},
				hdr3 = {
					type = "header",
					name = "驱散框体",
					order = 12,
				},
				toggleMoveFrames = {
					type = "toggle",
					order = 13,
					width = "double",
					name = "锁定框体",
					desc = "Check to lock frame's position. Uncheck to enable movement",
					get = function() return DispelBorder.db.profile.lockFrames end,
					set = DispelFrames_LockFrames,
				},
				toggleEnableTargetFrame = {
					type = "toggle",
					order = 14,
					width = "double",
					name = "启用目标Buff框体",
					desc = "Check to enable target buff frame for dispellable buffs",
					get = function() return DispelBorder.db.profile.showTargetFrame end,
					set = DispelFrames_ToggleTargetFrame,
				},
				toggleEnableFocusFrame = {
					type = "toggle",
					order = 14,
					width = "double",
					name = "启用焦点Buff框体",
					desc = "Check to enable focus buff frame for dispellable buffs",
					get = function() return DispelBorder.db.profile.showFocusFrame end,
					set = DispelFrames_ToggleFocusFrame,
				},
			}, -- args
		}, -- General
	}, -- args
} -- options

local defaults = {
	profile = {
		enabletarget = true,
		enlargetarget = false,
		enlargesstarget = false,
		enablefocus = true,
		enlargefocus = false,
		enlargessfocus = false,
		hookunitaura = false,
		lockFrames = true,
		showTargetFrame = true,
		showFocusFrame = true
	}
}

function DispelBorder:ChatCommand(input)
    if not input or input:trim() == "" then
        InterfaceOptionsFrame_OpenToCategory(self.optionsFrame)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(DispelBorder, "wh", "DispelBorder", input)
    end
end

-- we are loaded!
function DispelBorder:OnInitialize()
	DispelBorder.db = LibStub("AceDB-3.0"):New("DispelBorderDB", defaults, true)

	-- installs option panel
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("DispelBorder", options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("DispelBorder", nil, nil, "General")
	self:RegisterChatCommand("df", "ChatCommand")
	self:RegisterChatCommand("dispelframes", "ChatCommand")
	-- if we are a warlock, we only want to highlight if the fel hunter is out, so register this event to help track
	if (eclass == "WARLOCK") then
		self:RegisterEvent("PET_BAR_UPDATE", "PET_BAR_UPDATE")
	end

end

-- helper function to prep the tooltip for use
local function ResetTooltip()
	DBT:Hide()
	DBT:SetOwner(WorldFrame, "ANCHOR_NONE")
	DBT:ClearLines()
end

-- class name storage
local _, eclass = UnitClass("player")

-- store original versions of API calls
local old_UnitBuff = UnitBuff

-- current method hooks UnitAura and UnitBuff, this does the work for both function hooks
-- * returns a modified isStealable flag directly to the UI
-- * also optionally modifies the "unitCaster" return value to make stealable/dispellable buffs appear larger
-- * potentially modifies debuffType (set to "Enrage" if the buff is actually an enrage buff, instead of blank string)
function DispelBorder:DispelBorder_CheckBuff(name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff, ...)
	-- this is the only one we need specifically, but all may be needed by Enrage-checking code below
	local uid = select(1,...)
	
	-- if unitbuff/unitaura is being called on a unit that isn't target or focus, ignore it and return default data
	if (uid ~= "target" and uid ~= "focus") then
		return name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff
	end

	-- if buff is actually stealable (we are a mage) and we should enlarge it
	if (isStealable and ((uid == "target" and DispelBorder.db.profile.enlargesstarget) or (uid == "focus" and DispelBorder.db.profile.enlargessfocus))) then
		unitCaster = "player"

	-- if we have borders enabled for this unit type, this class can dispel enemy buffs in general, and the unit is an enemy
	elseif (((uid == "target" and DispelBorder.db.profile.enabletarget) or (uid == "focus" and DispelBorder.db.profile.enablefocus)) and DispelBorder_CanDispelEnemy() and (UnitIsEnemy("player", uid) or UnitCanAttack("player", uid))) then
		-- check for valid dispellable buff
		
		-- check for Enrage buffs (but only if there is no "known" debuffType and the player can even dispel them)
		-- if it is, change the "debuffType" so 1: our type-checking code is simpler and 2: other addons could potentially get this info (?)
		if (debuffType == "" and DispelBorder_CanDispelEnemyType("Enrage")) then
			ResetTooltip()
			DBT:SetUnitBuff(...) -- pass exact UnitBuff/UnitAura parameters to SetUnitBuff to make things easier
			if (DispelBorderTooltipTextRight1:GetText() == ENRAGE_STRING) then
				debuffType = "Enrage"
			end
		end

		-- if we can dispel it
		if (DispelBorder_CanDispelEnemyType(debuffType)) then
			-- give it a border
			isStealable = 1
			--self:Print("Dispellable (" .. name .. ") => " .. format("%.2f",GetTime()) .. GetSpellLink(spellID))
		end
	end

	-- return all parameters (debuffType, unitCaster, and isStealable are potentially modified)
	return name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff
end


-- API hook
-- modified in 1.3.9 to work with (unit, spellname, spellrank, filter) in addition to (unit, index, filter)
function DispelBorder_UnitBuff(...)
	-- get default stuff
	local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff  = old_UnitBuff(...)

	-- if unitbuff is being called on a unit that isn't target or focus, ignore it and return default data
	local uid = select(1,...)
	if (uid ~= "target" and uid ~= "focus") then
		return name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff
	end

	-- check actual buff info and return potentially modified info based on if we can dispel or not
	return DispelBorder:DispelBorder_CheckBuff(name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff, ...)
end

-- hook API functions
UnitBuff = DispelBorder_UnitBuff
-- UnitAura hooking has been moved to DispelBorder:OnInitialize()

-- just some helper functions to check dispel type logic

-- monitor warlock pet changes to see if he has a felhunter out or not
local HasDispelPet = false
function DispelBorder:PET_BAR_UPDATE()
	HasDispelPet = false
	if (eclass == "WARLOCK") then
		local num = HasPetSpells()
		if (num) then
			local skillType = GetSpellBookItemInfo("Devour Magic")
			if (skillType) then
				HasDispelPet = true
			end
		end
	end
end

-- can this class dispel enemy buffs at all?
function DispelBorder_CanDispelEnemy()
	-- technically mages can also dispel enemy buffs, but only spellstealable ones and they get the border by default so ignore them
	-- if we include them, they would incorrectly get borders around all magic buffs, even ones they cannot actually spellsteal
	
	-- only true for warriors if prot, and for warlocks if fel hunter is out
	if (eclass == "HUNTER" or eclass == "PRIEST" or eclass == "SHAMAN" or eclass == "ROGUE" or eclass == "DRUID" or (eclass == "WARLOCK" and HasDispelPet) or (eclass == "WARRIOR" and GetPrimaryTalentTree() == 3)) then
		return true
	end
	
	return false
end

-- can this class dispel specific enemy buffs (of type t)?
function DispelBorder_CanDispelEnemyType(t)
	if (t == "Magic") then
		-- once again ignoring mages
		
		-- only show for warriors if prot, and for warlock if fel hunter is out
		if (eclass == "HUNTER" or eclass == "PRIEST" or eclass == "SHAMAN" or (eclass == "WARLOCK" and HasDispelPet) or (eclass == "WARRIOR" and GetPrimaryTalentTree() == 3)) then
			return true
		end
	elseif (t == "Enrage") then
		if (eclass == "HUNTER" or eclass == "ROGUE" or eclass == "DRUID") then
			return true
		end
	end
	
	return false
end
