var g = eval(glossary);
window.onload = function fncOnLoad(){
	try {

		// ----------------------------------------------------------------------------------------
		// タイトルの指定
		// ----------------------------------------------------------------------------------------
		document.title = fncGetResourceByResourceId("glossary");

		// リソース定義のマッピング
		fncLoadResource();

		// 検索結果表示領域のサイズ調整
		fncOnResize();

		// インデックスの作成
		fncGenerateInitials();

		// 先頭の項目が選択された状態で初期表示
		fncLoadGlossary(0);
		fncLoadWord(0, 0);

	}catch(e){
	}
}

function fncGenerateInitials(){
	try {

		// 用語情報分ループ
		var nGLength = g.length;
		var arrInitial = new Array();
		for (var i = 0; i < nGLength; i++) {
			var initial = g[i].initial;
			var nInitialLength = initial.length;
			var nButtonWidth = "";
			if (nInitialLength == 1) {
				nButtonWidth = "20px";
			} else {
				nButtonWidth = "Auto";
			}
			arrInitial.push("<button class=\"normal\" onclick=\"fncLoadGlossary('" + i + "');\" style=\"width:" + nButtonWidth + ";\" id=\"id_" + i + "\" accesskey=\"" + initial + "\">");
			arrInitial.push(initial);
			arrInitial.push("</button>");
		}
		document.getElementById("id_initials").innerHTML = arrInitial.join("");
	} catch (e) {
	}
}

function fncLoadGlossary(nInitial){
	try {
		var arrWord = new Array();
		var nWLength = g[nInitial].words.length;
		for (var i = 0; i < nWLength; i++) {
			var word = g[nInitial].words[i].word;
			var desc = g[nInitial].words[i].desc;
			arrWord.push("<a href=\"#\" onclick=\"fncLoadWord(" + nInitial + ", " + i + ");\">");
			arrWord.push("<div class=\"normal\" id=\"id_" + nInitial + "_" + i + "\">");

			arrWord.push(word);
			arrWord.push("</div>");
			arrWord.push("</a>");

		}
		document.getElementById("id_words").innerHTML = arrWord.join("");
		document.getElementById("id_desc").innerHTML = "";

		// 選択されたイニシャルをハイライト表示
		var objButtons = document.getElementById("id_initials").getElementsByTagName("button");
		var nButtonLength = objButtons.length;
		for (var i = 0; i < nButtonLength; i++) {
			objButtons[i].className = "normal";
		}
		document.getElementById("id_" + nInitial).className = "click";

	} catch (e) {
	}
}

function fncLoadWord(nInitial, nWord){
	try {

		var word = g[nInitial].words[nWord];
		var title = word.word;
		var desc = word.desc;

		var arrDesc = new Array();
		arrDesc.push("<div class=\"title\" ondblclick=\"fncSearchByGlossary('" + title + "');\">");
		arrDesc.push(title);
		arrDesc.push("</div>");
		arrDesc.push("<div class=\"desc\">");
		arrDesc.push(desc);
		arrDesc.push("</div>");
		document.getElementById("id_desc").innerHTML = arrDesc.join("");

		// 選択された用語をハイライト表示
		var objDivs = document.getElementById("id_words").getElementsByTagName("div");
		var nDivLength = objDivs.length;
		for (var i = 0; i < nDivLength; i++) {
			objDivs[i].className = "normal";
		}
		document.getElementById("id_" + nInitial + "_" + nWord).className = "click";

	} catch (e) {
	}
}

// イベント処理
document.onkeypress = fncKeyPress;
window.onresize = fncOnResize;

// 検索結果欄の高さを動的に計算
function fncOnResize(){
	try{
		var obj = window;
		if(window.opera){
			var w = obj.innerWidth;
			var h = obj.innerHeight;
		}else if(document.all){
			var w = obj.document.body.clientWidth;
			var h = obj.document.body.clientHeight;
		}else if(document.getElementById){
			var w = obj.innerWidth;
			var h = obj.innerHeight;
		}
		document.getElementById("id_words").style.height = h - 134 + "px";
		document.getElementById("id_desc").style.height = h - 134 + "px";
		document.getElementById("id_desc").style.width = w - 300 + "px";
		document.getElementById("id_footer").style.top = h - 29 + "px";
	}catch(e){
	}
}