if false then --Don't run this - it doesn't work yet...
if BuffinTotems then

local oldMakeOptions = Buffin.MakeOptions
function Buffin:MakeOptions()
	oldMakeOptions(Buffin)
	
	self.options.args.totems = {
		type = 'group',
		name = 'Totems',
		set = 'SetOpt',
		get = 'GetOpt',
		handler = BuffinTotems,
		childGroups = 'tree',
		args = {
			info = {
				type = 'description',
				name = "Buffin can attempt to automatically select an optimum set of totems for you based on the buffs you and your group currently possess.",
				order = 1,
			},
			basic = {
				type = 'group',
				name = 'Basic Options',
				inline = true,
				args = {
					call = {
						type = 'select',
						name = "Call",
						desc = "Set this to the totem call you would like Buffin to automatically adjust for your group makeup",
						order = 1,
						values = function() 
							local ret = {[0]='None'}
						for call,_ in pairs(BuffinTotems.totemCalls) do
							ret[call] = GetSpellInfo(call)
								end
								return ret
								end,
								order = 10,
					}
				}
			},
			priorities = {
				type = 'description',
				name = "Buffin chooses it's totem set based on the priorities listed here as well as the group composition. For example, if Stoneskin Totem is the top priority for the earth slot but you currently have devotion aura, buffin will test the second priority for this slot. Priorities are split by your group's type (e.g. mostly physical damage) and your current talent specialisation.\n",
			},
		}
	}

	local groupTypes = {[1]='Solo', [2]='Caster', [3]='Physical', [4]='Equal', [5]='PvP'}
	local specs = {
		[1]={
			name = 'Elemental',
			type = 'group',
			order = 1,
			args = {},
		}, 
		[2]={
			name = 'Enhancement',
			type = 'group',
			order = 2,
			args = {},
		},
		[3]={
			name = 'Restoration',
			type = 'group',
			order = 3,
			args = {},
		}
	}
	local slots = {
		[1] = {
			name = "Fire",
			type = 'group',
			order = 0,
			args = {},
		},
		[2] = {
			name = "Earth",
			type = 'group',
			order = 1,
			args = {},
		},
		[3] = {
			name = "Water",
			type = 'group',
			order = 2,
			args = {},
		},
		[4] = {
			name = "Air",
			type = 'group',
			order = 3,
			args = {},
		}
	}

	for g,group in ipairs(groupTypes) do
		self.options.args.totems.args[string.lower(group)] = {
			type = 'group',
			name = group,
			order = g,
			childGroups = 'tab',
			set = 'SetPriority',
			get = 'GetPriority',
			args = {},
		}
		for s,spec in ipairs(specs) do
			self.options.args.totems.args[string.lower(group)].args[string.lower(spec.name)] = spec
			for sl,slot in ipairs(slots) do
				self.options.args.totems.args[string.lower(group)].args[string.lower(spec.name)].args[string.lower(slot.name)] = slot
			end
		end
	end

	LibStub('AceConfigRegistry-3.0'):NotifyChange('Buffin')
end

function BuffinTotems:SetOpt(i, v)
	self.db.char[i[#i]] = v
	self:SetGroup()
end

function BuffinTotems:GetOpt(i)
	return self.db.char[i[#i]]
end

end
end
