if select(2,UnitClass('player')) == 'SHAMAN' then
BuffinTotems = Buffin:NewModule('BuffinTotems');
local mapData = LibStub("LibMapData-1.0")

Buffin.buffsByClassByType['SHAMAN'].Group = {
	Call = {
		[66842] = {dynamic=function() return not IsResting() end, satisfied=function() return BuffinTotems:IsCallSatisfied(66842) end}, --Elements
		[66843] = { satisfied=function() return BuffinTotems:IsCallSatisfied(66843) end}, --Ancestors
		[66844] = { satisfied=function() return BuffinTotems:IsCallSatisfied(66844) end}, --Spirits
	},
}

function BuffinTotems:OnInitialize()
	self.totemCalls = {
		[66842] = 133,
		[66843] = 137,
		[66844] = 141,
	}

	self.totemCoordinates = {}
	self.totemZone = nil
	self.totemFloor = nil
	self.lastCall = nil
end

function BuffinTotems:OnEnable()
	if not self.db then
		local defaults = {
			char = {
				call = 0,
			}
		}
		Buffin.db:RegisterNamespace('totems', defaults)
		self.db = Buffin.db:GetNamespace('totems')
	end
end

function BuffinTotems:IsCallSatisfied(call)
	local down = {}

	for i=1,MAX_TOTEMS do
		local name = select(2,GetTotemInfo(i))
		if name and name ~= '' then down[name] = true end
	end

	for i=0,MAX_TOTEMS-1 do
		local slot = self.totemCalls[call]+i
		local id = select(2,GetActionInfo(slot))
		if id then
			local name = GetSpellInfo(id)
			if not down[name] then return false end
		end
	end

	--I think it's fine not to always force refreshes in new map areas
	if self.totemZone ~= GetMapInfo() or self.totemFloor ~= GetCurrentMapDungeonLevel() then return false end
	
	--check distance
	local x,y = GetPlayerMapPosition('player')
	if mapData:Distance(self.totemZone, self.totemFloor, x,y, unpack(self.totemCoordinates)) > 30 then return false else return true end
end

function BuffinTotems:TotemsDropped(call)
	self.totemCoordinates = {GetPlayerMapPosition('player')}
	self.totemZone = GetMapInfo()
	self.totemFloor = GetCurrentMapDungeonLevel()
	self.lastCall = call
end

local flametongue = 8227
local stoneskin, sote = 8071,8075
local manaSpring, healingSpring, resistance, tranquil = 5675, 5394, 8184, 87718
local windfury, wrath = 8512, 3738

local totemPriorities = {
	[0] = { --fire
		solo = {
			[1] = {flametongue, 0},
			[2] = {},
			[3] = {flametongue, 0},
		},
		caster = {
			[1] = {},
			[2] = {},
			[3] = {flametongue, 0},
		},
		physical = {
			[1] = {},
			[2] = {},
			[3] = {flametongue, 0},
		},
		equal = {
			[1] = {},
			[2] = {},
			[3] = {flametongue, 0},
		},
		pvp = {
			[1] = {},
			[2] = {},
			[3] = {flametongue,},
		}
	},
	[1] = { --earth
		solo = {
			[1] = {stoneskin, sote},
			[2] = {},
			[3] = {stoneskin, sote},
		},
		caster = {
			[1] = {},
			[2] = {},
			[3] = {stoneskin, sote},
		},
		physical = {
			[1] = {},
			[2] = {},
			[3] = {sote, stoneskin},
		},
		equal = {
			[1] = {},
			[2] = {},
			[3] = {stoneskin, sote},
		},
		pvp = {
			[1] = {},
			[2] = {},
			[3] = {stoneskin,},
		}
	},
	[2] = { 
		solo = {
			[1] = {tranquil, manaSpring, resistance, healingSpring},
			[2] = {},
			[3] = {tranquil, manaSpring, resistance, healingSpring},
		},
		caster = {
			[1] = {},
			[2] = {},
			[3] = {manaSpring, resistance, healingSpring, tranquil},
		},
		physical = {
			[1] = {},
			[2] = {},
			[3] = {resistance, healingSpring, manaSpring, tranquil},
		},
		equal = {
			[1] = {},
			[2] = {},
			[3] = {resistance, manaSpring, healingSpring, tranquil},
		},
		pvp = {
			[1] = {},
			[2] = {},
			[3] = {resistance,},
		}
	},
	[3] = { --air
		solo = {
			[1] = {wrath},
			[2] = {},
			[3] = {wrath},
		},
		caster = {
			[1] = {},
			[2] = {},
			[3] = {wrath,windfury},
		},
		physical = {
			[1] = {},
			[2] = {},
			[3] = {windfury,wrath},
		},
		equal = {
			[1] = {},
			[2] = {},
			[3] = {wrath,windfury},
		},
		pvp = {
			[1] = {},
			[2] = {},
			[3] = {wrath,},
		}

	},
}

local totemClashes = {
	[flametongue] = {buffs = {1459,61316}},

	[stoneskin] = {buffs = {465}},
	[sote] = {buffs = {57330, 6673}, petFamilies = {'Cat', 'Spirit Beast'}}, --TODO: localisation

	[manaSpring] = {buffs = {19740}, petFamilies = {'Felhunter'}}, --Tracking fel intelligence buff would be easier?
	[resistance] = {buffs = {19891}},
	[tranquil] = {buffs = {19746}},

	[windfury] = {buffs = {55610, 53290}},
	[wrath] = {buffs = {24907, 15473}},
}

function BuffinTotems:SetGroup(group)
	if not group then if self.db then group = self.db.char.call else return end end
	local call = self.totemCalls[group]
	if not call then return end


	for i=0,MAX_TOTEMS-1 do
		local priorities = totemPriorities[i][self:GroupType()][Buffin.primarySpecialisation]
		local spells = {GetMultiCastTotemSpells(call+i)}
		for _,spell in ipairs(spells) do spells[spell] = true end
		
		local selected = nil
		for s,spell in ipairs(priorities) do
			if spells[spell] then
				local found = false
				local clashes = totemClashes[spell]

				-- buffs
				if clashes and clashes.buffs then
					for _,buff in ipairs(clashes.buffs) do
						local name = GetSpellInfo(buff)
						if UnitBuff('player', name) then 
							found = true
							break
						end
					end
				end

				if clashes and clashes.petFamilies then
					for _,family in ipairs(clashes.petFamilies) do
						for unit,inRange in pairs(Buffin.group.ranges) do
							local pet = unit ..'pet'
							if inRange and UnitExists(pet) and UnitCreatureFamily(pet) == family then
								found = true
								break
							end
						end
						if found then break end
					end
				end

				if not found then --or s==#priorities (set last?)
					if spell == resistance then --if healing stream glyph force healingstream even though we chose resistance
						local _,_,_, opt1 = GetGlyphSocketInfo(GLYPH_ID_MAJOR_1)
						local _,_,_, opt2 = GetGlyphSocketInfo(GLYPH_ID_MAJOR_2)
						local _,_,_, opt3 = GetGlyphSocketInfo(GLYPH_ID_MAJOR_3)

						if opt1 == 55456 or opt2 == 55456 or opt3 == 55456 then spell = healingSpring end
					end
					local oldid = select(2, GetActionInfo(call+i))
					if oldid and spell ~= oldid then 
						local old = GetSpellInfo(oldid)
						local new = GetSpellLink(spell)
						local call = GetSpellInfo(group)

						Buffin:Print(new .." replaces ".. old .." in ".. call) 
					end

					SetMultiCastSpell(call+i, spell)
					break
				end
			elseif spell == 0 then
				--TODO: Work out if we want no change, a backup or no totem in this slot
				--SetMultiCastSpell(call+i)
			end
		end
	end
end

function BuffinTotems:GroupType()
	local party,raid = GetNumPartyMembers(), GetNumRaidMembers()
	if party == 0 and raid == 0 then return 'solo'
	elseif UnitIsPVP('player') then return 'pvp' 
	else
		local total, casters, physical = 0,0,0

		if raid > 0 then total = raid else total = party end
		for i=1,total do
			local unit = raid>0 and 'raid'..i or 'party'..i

			local role = UnitGroupRolesAssigned(unit)
			if role == 'TANK' then physical = physical + 1
			elseif role == 'HEALER' then casters = casters + 1
			else
				--DAMAGER or no role assigned, check their class
				local class = select(2,UnitClass(unit))
				if class == 'MAGE' or class == 'WARLOCK' or class == 'PRIEST' then casters = casters + 1
				elseif class == 'DEATHKNIGHT' or class == 'HUNTER' or class == 'WARRIOR' or class == 'ROGUE' then physical = physical + 1
				else 
					--TODO: keep track of specs, maybe this whole function should be event based and just set a variable
					if class == 'DRUID' then
				 	elseif class == 'PALADIN' then
					elseif class == 'SHAMAN' then
					end
				end
			end
		end

		--self
		if Buffin.primarySpecialisation == 1 or Buffin.primarySpecialisation == 3 then 
			casters = casters + 1 
		elseif Buffin.primarySpecialisation == 2 then physical = physical + 1 end

		return casters > physical and 'caster' or (physical > casters and 'physical' or 'equal') --TODO: Is 'equal' necessary? Just return based on your own spec?
	end
end

end
