function Buffin:IsCast(spell, unit, checkClashes) 
	if spell == nil then return end
	if spell.mode == 'Weapon' then return self:WeaponIsCast(spell) end
	if unit == nil or unit == true then unit = 'player' end
	if spell.satisfied then return spell.satisfied(spell, unit) end -- If there's an override function checking criteria, use it.
	if not UnitExists(unit) then return true end --FIXME: A bit hacky. For when people leave the group but the SetupGroup bucket hasn't fired yet to remove them from the list.

	local curTime, minExpiry = GetTime(), self:GetExpirationTime(spell.mode, spell.group)
	
	local check = (spell.combatType and spell.combatType == 'hostile') and UnitDebuff or UnitBuff
	local count, _,_, expiresAt, whose
	if type(spell.buffName) ~= 'table' then
		count, _,_, expiresAt, whose = select(4, check(unit, spell.buffName or spell.name, nil, "PLAYER"))
	else
		for i=1,#spell.buffName do
			count, _,_, expiresAt, whose = select(4, check(unit, spell.buffName[i], nil, "PLAYER"))
			if expiresAt ~= nil then break end
		end
	end

	if not expiresAt then 
		if not checkClashes or not self.lookupByClash[spell.id] then return false
		else
			for id,name in pairs(self.lookupByClash[spell.id].spells) do
				count, _,_, expiresAt, whose = select(4, check(unit, name))
				if expiresAt then break end
			end
			if not expiresAt then return false end
		end
		
	end

	if expiresAt < curTime then return true, expiresAt, count, whose
	elseif expiresAt - curTime > minExpiry then return true, expiresAt, count, whose
	else return false, expiresAt, count, whose end

	--[[for i=1,40 do
		local tstExpiresAt,_,_,_,tstID = select(7, UnitBuff(unit, i, 'PLAYER'))
		if not tstID then return false end
		if spell.id == tstID or spell.buff == tstID or (type(spell.buff) == 'table' and spell.buff[tstID]) then 
			if tstExpiresAt < curTime then return true
			elseif tstExpiresAt - curTime > minExpiry then return true, tstExpiresAt
			else return false end
		end
	end
	return false]]
end

function Buffin:GroupIsCast(spell)
	assert(spell, "Usage: GroupIsCast(spell).")
	if not self.group.ranges then return end
	local present, expiresAt, count, whose
	for unit,inRange in pairs(self.group.ranges) do
		if inRange then
			present, expiresAt, count, whose = self:IsCast(spell, unit, true)
			if not UnitIsDeadOrGhost(unit) and not present then return false end --TODO: minlevel?
		end
	end
	return true, expiresAt, whose
end

function Buffin:SingleIsCast(spell)
	if not self.group.ranges then return end
	for unit,_ in pairs(self.group.ranges) do
		local isCast, timeLeft, count = self:IsCast(spell, unit)
		if isCast then return unit, timeLeft, count end
	end
	return nil
end

-- function Buffin:WeaponIsCast is in this block
do
	local tt = CreateFrame("GameTooltip"); -- Tooltip name cannot be nil
	tt:SetOwner(UIParent, "ANCHOR_NONE");
	local texts = {}

	local r = tt:CreateFontString()
	r:SetFontObject(GameFontNormal)
	for i = 1, 30 do
		local l = tt:CreateFontString()
		l:SetFontObject(GameFontNormal)
		tt:AddFontStrings(l, r)
		texts[i] = l
	end

	function Buffin:WeaponIsCast(spell)
		if not spell then return true end
		tt:ClearLines()
		if not tt:IsOwned(UIParent) then
			tt:SetOwner(UIParent, "ANCHOR_NONE")
		end

		if not spell.slot then return true end
		tt:SetInventoryItem("player", spell.slot)

		for i = 1, tt:NumLines() do
			local text = texts[i]:GetText()
			if text then
				local name,timeLeft,qualifier = text:match("^(.+) %((%d+) ([^$)]+)%)$")
				if name and spell.name:find(name) then 
					--TODO: Check if all the spell names contain the weapon enchant name and check if there are any spell names which contain any part of any other weapon buff names - unlikely?
					local minExpiry = self:GetExpirationTime(spell.mode, spell.group)
					if qualifier == 'min' then timeLeft = timeLeft * 60 
					elseif qualifier == 'hour' then timeLeft = timeLeft * 3600 end --TODO: Other localisations
					if tonumber(timeLeft) > minExpiry then return true
					else return false end
				end  
			else
				break
			end
		end
		return false
	end
end


