Buffin.groupBuffPriorities= {
	stats = {
		[1]="DRUID", [2]="PALADIN",
		spells = {
			[20217]=true, --BoK
			[1126]=true, --MotW
		},
		priority = 10,
	},
	apRegen = {
		[1]="PALADIN",
		spells = {
			[19740]=true, --BoM
		},
		priority = 100,
	},
	stamina = {
		[1]="PRIEST", [2]="WARRIOR", --[3]="WARLOCK",
		spells = {
			[21562]=true, --PW:F
			[469]=true, --Commanding
			[6307]=true, --Blood Pact
		},
	},
	strAgi = {
		[1]="DEATHKNIGHT", [2]="WARRIOR", --[3]="SHAMAN",
		spells = {
			[57330]=true, --HoW
			[6673]=true, --Battle Shout
		}
	},
	ai = {
		[1]="MAGE",
		spells = {
			[1459]=true, --ab
			[61316]=true, --db
		}
	}
}

Buffin.lookupByClash = {}
for clash,details in pairs(Buffin.groupBuffPriorities) do
	for id,_ in pairs(details.spells) do
		details.spells[id] = GetSpellInfo(id)
		Buffin.lookupByClash[id] = details
	end
end

local function always() return true end
local function spec1() return Buffin.primarySpecialisation == 1 end
local function spec2() return Buffin.primarySpecialisation == 2 end
local function spec3() return Buffin.primarySpecialisation == 3 end


Buffin.buffsByClassByType = {
	PALADIN = {
		Self = {
			Seal = {
				[20165] = {dynamic = spec1}, --SoI
				[31801] = {dynamic = spec2}, --SoT TODO: Ret (IsRaid, glyph?)
				[20164] = {}, --SoJ TODO: PvP?
				[20154] = {dynamic = spec3}, --SoR TODO: Ret (Solo, glyph?)
			},

			Aura = { --TODO: PallyPower? Priorities.
				[32223] = {dynamic = IsMounted, override=IsMounted, learning=false}, --CruA
				[465] = {dynamic = spec2}, --DA 
				[7294] = {dynamic = spec3}, --RetA
				[19746] = {dynamic = function() return spec1() and UnitIsPVP('player') end}, --ConA
				[19891] = {dynamic = function() return spec1() and not UnitIsPVP('player') end}, --ResA
			},

			Unique = {
				[25780] = {dynamic = spec2}, --RF
				--[[[58149] = {type='item', dynamic = function() return GetItemCount(58149) > 0 end, satisfied=function() 
					for i=1,40 do
						local name = UnitBuff('player', i);
						if not name then break end
						if string.find(name, 'Flask') then return true end; -- :(
					end
					local intName = GetSpellInfo(79640);
					local strName = GetSpellInfo(79638);
					return (Buffin.primarySpecialisation == 1 and UnitBuff('player', intName)) or ((Buffin.primarySpecialisation == 2 or Buffin.primarySpecialisation == 3) and UnitBuff('player', strName));
				end} --FoE]]
			}
		},
		Group = {
			Blessings = { --TODO: Enforcing this order in priorities?
				[20217] = {buff=79063, dynamic=always}, --BoK
				[19740] = {buff=79102, dynamic=always}, --BoM
			},
		},
		Single = {
			Unique = {
				[53563] = {dynamic = spec1, target = "TANK"}, --BoL
			},
		},
		Combat = {
			Unique = { -- Given special treatment so that this doesn't appear in the UI.
				[20271] = {combatType='self', buff={53655, 53656, 53657}, dynamic = spec1}, -- JotP.
				[20473] = {combatType='self', buff={54149, 53672}, dynamic=spec1}, --IoL
				--[879] = {combatType='self', buff=85509, dynamic=spec1}, --Exorcism
				[53563] = {combatType='single', dynamic = spec1, secure=true}, -- BoL
				[84963] = {combatType='self', dynamic = always}, -- Inquisition
				[20066] = {combatType='hostile', dynamic = spec3}, -- Repentance
				[10326] = {combatType='hostile', dynamic = always}, -- TE
				[20925] = {combatType='self', dynamic = spec2}, --Holy Shield
			},
		},
	},
	PRIEST = { 
		Self = {
			Unique = {
				[15473] = {dynamic = spec3}, --SF
				[15286] = {dynamic = spec3}, --VE
			},
			Inner = {
				[588] = {dynamic = always}, -- IF
				[73413] = {}, -- IW
			}
		},
		Group = {
			Unique = {
				[21562] = {buff=79105, dynamic=always}, --PW:S
				[27683] = {buff=79107, dynamic=always}, -- SP
			},
		},
		Single = {
			Unique = {
				[6346] = {}, --FW
			},
		},
		Combat = {
			Unique = {
				[33076] = {combatType = 'single', buff=41635, dynamic = function() return spec1() or spec2() end}, --PoM
				[6346] = {combatType = 'single',}, --FW
				[585] = {combatType='self', buff={81660, 81661}, dynamic=spec1}, --Evangelism
				[87151] = {combatType='self', buff=81700, dynamic=function() return spec1() or spec3() end}, --Archangel
				[15407] = {combatType='self', buff={87117, 87118}, dynamic=spec3}, --Dark Evangelism
				[77487] = {combatType='self', dynamic=spec3,},
			},
		},
	},
	SHAMAN = { 
		Self = {
			Shield = {
				[52127] = {dynamic = spec3}, --WS
				[324] = {dynamic = function() return spec2() or spec1() end}, --LS
			},
		},
		--[[Group = { 

		},]]
		Weapon = {
			Main = {
				[51730] = {dynamic = spec3}, -- EL
				[8024] = {dynamic = spec1}, -- FT
				[8232] = {dynamic = spec2}, -- WF
				[8017] = {}, -- RB
				[8033] = {}, -- FB
			},
			Off = {
				[51730] = {}, -- EL
				[8024] = {dynamic = spec2}, -- FT
				[8232] = {}, -- WF
				[8017] = {}, -- RB
				[8033] = {}, -- FB
			},
		},
		Single = {
			Unique = {
				[974] = {dynamic = spec3, target = 'TANK', notSelf=true},--, satisfied = function(spell, unit) if unit ~= 'player' then return Buffin:IsCast(spell, unit); else return (Buffin:IsCast(Buffin.buffs.Self.Shield[52127]) or Buffin:IsCast(Buffin.buffs.Self.Shield[324]))  end end}, -- ES. TODO: somehow link with LS/WS
			},
		},
		Combat = {
			Unique = {
				[974] = {combatType = 'single', dynamic=spec3, secure=true}, --ES
				[52127] = {combatType = 'single', dynamic=spec3, secure=true}, --WS
				[324] = {combatType = 'single', dynamic=function() return spec1() or spec2() end, secure=true},	--LS
				
				[51514] = {combatType='hostile', dynamic=always}, -- Hex
			},
		},
	},
	DRUID = {
		Self = {
			Unique = {
				[24858] = {dynamic=spec1}, --Chicken
			},
		},
		Group = {
			Unique = {
				[1126] = {buff=79061, dynamic=always}, -- MotW
			},
		},
		-- Thorns is now a short term buff with a cooldown. Not really something you regularly cast out of combat.
		--[[Single = { 
			Unique = {
				[467] = {},
			}
		},]]
		Combat = {
			Unique = {
				[33763] = {combatType='single', dynamic=spec3,}, -- LB
				[52610] = {combatType='self', dynamic=function() return spec2() and UnitGroupRolesAssigned('player') == 'DAMAGER' end, secure=true}, -- Savage Roar
				--[93400] = {combatType='self', dynamic=spec1}, --Shooting Stars --has a spellalert
				[339] = {combatType='hostile', dynamic=always}, --ER
				[2637] = {combatType='hostile', dynamic=always}, --Hibernate

			},
		},
	},
	WARRIOR = {
		--[[Group = {
			Shouts = { --TODO: Now have a cooldown, will probably not make sense to have them here.
				[469] = {buff=469},
				[6673] = {buff=6673}
			},
		},]]
		Single = {
			Unique = {
				[50720] = {dynamic = function() return (GetNumRaidMembers() > 0 or GetNumPartyMembers() > 0) and spec3() end, target = 'HEALER', notSelf=true}, -- Vigi
			},
		},
		Combat = {
			Unique = {
				[7384] = {combatType='self', buff=60503, dynamic = spec1, ctuDuration=4, once=true}, -- Overpower, might be 5sec after dodge.
				[34428] = {combatType='self', buff={82368, 32216}, dynamic = always, ctuDuration=20, once=true}, --VR TODO: Doesn't show out of combat, new property to show out of combat too?
				--[6572] = {combatType='self', dynamic = spec3, ctuDuration=4}, --Revenge? TODO: Decide whether or not to include this - don't tanks just always have this up every 5sec now when they want to use it? CombatText events don't fire to refresh it either.
			},
		},
	},
	WARLOCK = { 
		Self = {
			Armor = {
				[28176] = {dynamic = always}, --FA
				[687] = {}, --DA
			},
			Pets = {
				[688] = {dynamic=spec3, satisfied=HasPetUI}, --Imp
				[30146] = {dynamic=spec2, satisfied=HasPetUI}, --Felguard
				[697] = {satisfied=HasPetUI}, --VW
				[712] = {satisfied=HasPetUI}, --Succubus
				[691] = {satisfied=HasPetUI}, --FH
			},
			Unique = {
				[19028] = {buff=25228, dynamic = HasPetUI}, -- Soul Link
				[693] = {dynamic=always, satisfied = function(spell, unit) return GetItemCount(5232) > 0 end}, -- Soulstone
				[6201] = {dynamic=always, satisfied = function(spell, unit) return GetItemCount(5512) > 0 end}, -- HS
				[5697] = {dynamic=IsSwimming}, -- UB
			},
		},
		Single = {
			Unique = {
				[5232] = {type='item', buff=20707, dynamic=function(spell) return GetItemCount(5232) > 0 end, target='HEALER'}, -- Soulstone Ressurection.
				[80398] = {dynamic = function() return (GetNumRaidMembers() > 0 or GetNumPartyMembers() > 0) end, target='DAMAGER', notSelf=true}
			},
		},
		Combat = {
			Unique = {
				[5782] = {combatType='hostile', dynamic=always}, --Fear
				[710] = {combatType='hostile', dynamic=always}, --Banish
				[48018] = {combatType='self', dynamic=always}, --Teleport
				[6353] = {combatType='self', dynamic=spec3, buff={85113, 85114, 85383, 85385}}, -- I think it's just 85383 but put them all in, just in case.
			},
		},

	},
	HUNTER = { 
		Self = {
			Aspect = { 
				[13165] = {dynamic=function() return not UnitIsPVP('player') end}, --Hawk
				[5118] = {override = function() return IsResting() and not IsMounted() end}, --Cheetah
				[13159] = {}, --Pack
				[20043] = {}, --Wild
				[82661] = {dynamic=function() return UnitIsPVP('player') end}, --Fox
			},
			['Summon Pet'] = { -- TODO Work out the buffs of the different pets and make dynamic choose the right pet for the group.
				[883] = {dynamic = function() return not HasPetUI() and not SecureCmdOptionParse('[@pet,dead]true') ~= 'true' end, satisfied=HasPetUI }, --Call1 TODO: Find out if I can use UnitIsDead
				[83242] = {satisfied=HasPetUI}, --Call2
				[83243] = {satisfied=HasPetUI}, --Call3
				[83244] = {satisfied=HasPetUI}, --Call4
				[83245] = {satisfied=HasPetUI}, --Call5
			},
			['Revive'] = {
				[982] = {dynamic = function() return SecureCmdOptionParse('[@pet,dead]true') == 'true' end}
			},
		},
		Combat = {
			Unique = {
				[1513] = {combatType='hostile', dynamic=always}, --SB
				[1499] = {combatType='hostile', dynamic=always, buff=3355}, -- FT
				--[60192] = {combatType='hostile', dynamic=always}, --FT (Launcher)
				[19306] = {combatType='self', dynamic=spec3, ctuDuration=5, once=true}, --Counterattack --TODO: Check duration
				[19386] = {combatTyle='hostile', dynamic=spec3}, --Wyvern
			},
		},
	},
	ROGUE = { --TODO: Test!
		Weapon = {
			Main = { --TODO: Improve dynanism
				[6947] = {type='item', dynamic=function() return not UnitIsPVP('player') end}, --Instant
				[2892] = {type='item',}, --Deadly
				[10918] = {type='item', dynamic=function() return UnitIsPVP('player') end}, --Wound
				[5237] = {type='item',}, --Mind-numbing
				[3775] = {type='item',}, --Crippling
				[21835] = {type='item',}, --Anesthetic
			},
			Off = {
				[6947] = {type='item',}, --Instant
				[2892] = {type='item', dynamic=function() return not UnitIsPVP('player') end}, --Deadly
				[10918] = {type='item',}, --Wound
				[5237] = {type='item',}, --Mind-numbing
				[3775] = {type='item', dynamic=function() return UnitIsPVP('player') end}, --Crippling
				[21835] = {type='item',}, --Anesthetic
			},
			Ranged = {
				[6947] = {type='item',}, --Instant
				[2892] = {type='item',}, --Deadly
				[10918] = {type='item',}, --Wound
				[5237] = {type='item',}, --Mind-numbing
				[3775] = {type='item',}, --Crippling
				[21835] = {type='item',}, --Anesthetic
			},
		},
		Combat = {
			Unique = {
				[5171] = {combatType='self', dynamic=always},
				[6770] = {combatType='hostile', dynamic=always},
				[2094] = {combatType='hostile', dynamic=always},
			},
		},
	},
	MAGE = { --TODO: Test!
		Self = {
			Armor = { --TODO: Improve dynamism
				[30482] = {dynamic = function() return not UnitIsPVP('player') end}, --Molten
				[7302] = {dynamic = function() return UnitIsPVP('player') end}, --Frost
				[6117] = {}, --Mage
			},
			Unique = {
				[31687] = {dynamic=spec3, satisfied=HasPetUI}, --Water Elemental
				[759] = {dynamic=always, satisfied = function(spell, unit) return GetItemCount(36799) > 0 end}, -- Mana Gem
				[42955] = {dynamic=always, satisfied = function(spell, unit) 
					return 	GetItemCount(65500) > 0 or --cookie
						GetItemCount(65515) > 0 or --brownie
						GetItemCount(65516) > 0 or --cupcake
						GetItemCount(65517) > 0 or --lollipop
						GetItemCount(43518) > 0 or --pie
						GetItemCount(43523) > 0 or --strudel
						GetItemCount(65499) > 0    --cake
				end}
			},
		},
		Single = {
			Unique = {
				[54646] = {dynamic = function() return (GetNumRaidMembers() > 0 or GetNumPartyMembers() > 0) and spec1() end, notSelf=true, target='DAMAGER'} --FM --FIXME: Can't really do anything Dynamic with this yet.
			},
		},
		Group = {
			Intellect = { -- Hopefully this dynamically always choses Arcane Brilliance if it's learnt
				[1459] = {dynamic = function() return not Buffin.lookupByID[61316].available end,},
				[61316] = {dynamic = function() return Buffin.lookupByID[61316].available end},
			},
		},
		Combat = {
			Unique = {
				[118] = {combatType='hostile', buff={61305, 28272, 61721, 61780, 28271, }, dynamic=always}, --Polymorph (cat, pig, rabbit, turkey, turtle)
				[30451] = {combatType='hostile', buff=36032, dynamic=spec1}, --AB --FIXME: SPELL_AURA_APPLIED doesn't fire (only SPELL_DAMAGE does) on the first stack.
				
			},
		},
	},
	DEATHKNIGHT = { --TODO: Test!
		Self = {
			Presence = { --TODO: Improve dynamism
				[48263] = {dynamic=spec1,}, -- Blood
				[48266] = {dynamic=spec2}, -- Frost
				[48265] = {dynamic=spec3}, -- Unholy
			},
			Unique = {
				[3714] = {dynamic=function() return IsSwimming() or IsMounted() end}, -- Path of Frost
				[49222] = {}, --Bone Shield
			},
		},
		Group = {
			Unique = { --TODO: Dynamic, not sure if we need the horn!
				[57330] = {buff=57330}, --Horn
			},
		},
	},
}


local fSta = 58085; local fSpi = 67438; local fInt = 58086; local fStr = 58088; local fAgi = 58087;
local flasks = {
	[fSta] = 79469,	[fSpi] = 94160,	[fInt] = 79470, [fStr] = 79472,	[fAgi] = 79471,
}
local fIntOrSpi = function(which) return which == fSpi or which == fInt end

local flaskAssignments = {
	PALADIN = {fIntOrSpi, fSta, fStr},
	PRIEST = {fIntOrSpi, fIntOrSpi, fInt},
	SHAMAN = {fInt, fAgi, fIntOrSpi},
	DRUID = {fInt, function(which) return which == fSta or which == fAgi end, fIntOrSpi},
	WARRIOR = {fStr, fStr, fSta},
	WARLOCK = {fInt, fInt, fInt},
	HUNTER = {fAgi, fAgi, fAgi},
	ROGUE = {fAgi, fAgi, fAgi},
	MAGE = {fInt, fInt, fInt},
	DEATHKNIGHT = {fStr, fStr, fSta},
}

local feInt = 79640; local feStr = 79638; local feAgi = 79639;
local feAssignments = {
	PALADIN = {feInt, feStr, feStr},
	PRIEST = {feInt, feInt, feInt},
	SHAMAN = {feInt, feAgi, feInt},
	DRUID = {feInt, feAgi, feInt},
	WARRIOR = {feStr, feStr, feStr},
	WARLOCK = {feInt, feInt, feInt},
	HUNTER = {feAgi, feAgi, feAgi},
	ROGUE = {feAgi, feAgi, feAgi},
	MAGE = {feInt, feInt, feInt},
	DEATHKNIGHT = {feStr, feStr, feStr},
}

for class,_ in pairs(Buffin.buffsByClassByType) do
	Buffin.buffsByClassByType[class].Flask = {['Flask']={}}
	for item,spell in pairs(flasks) do
		Buffin.buffsByClassByType[class].Flask.Flask[item] = {type = 'item', buff = spell, dynamic = function() return (GetMinimapZoneText() ~= 'Baradin Hold' and select(2,IsInInstance()) == 'raid') and ((type(flaskAssignments[class][Buffin.primarySpecialisation]) == 'function' and flaskAssignments[class][Buffin.primarySpecialisation](item)) or flaskAssignments[class][Buffin.primarySpecialisation] == item) end }

		Buffin.buffsByClassByType[class].Flask.Flask[58149] = {type = 'item', dynamic = function() return select(2, IsInInstance()) ~= 'raid' and GetItemCount(58149) > 0 end, satisfied = function() 
			if not Buffin.primarySpecialisation then return true end

			local feName = GetSpellInfo(feAssignments[class][Buffin.primarySpecialisation])
			local flaskAssignment = flaskAssignments[class][Buffin.primarySpecialisation]
			local flaskName
			if type(flaskAssignment) ~= 'function' then 
				flaskName = GetSpellInfo(flasks[flaskAssignment])
				if UnitBuff('player', flaskName) then return true end
			else
				for item,spell in pairs(flasks) do
					if flaskAssignment(item) then
						flaskName = GetSpellInfo(spell)
						if UnitBuff('player', flaskName) then return true end
					end
				end
			end

			return UnitBuff('player', feName) 
		end}
	end
end
