Buffin = LibStub("AceAddon-3.0"):NewAddon("Buffin", "AceEvent-3.0", "AceBucket-3.0", "AceConsole-3.0", "AceTimer-3.0")
Buffin:RegisterChatCommand("buffin", function(input) if not input or input:trim() == "" then InterfaceOptionsFrame_OpenToCategory(Buffin.blizOptions) else LibStub("AceConfigCmd-3.0"):HandleCommand('buffin', 'Buffin', input) end end)
Buffin.revision = "160"
Buffin.version = "v0.5-release4-4.3update"

local debug = false
--[===[@debug@
debug = true
--@end-debug@]===]

function Buffin:OnInitialize()
	self.totalTimers = 0;

	self.class = select(2, UnitClass('player'));
	self.btn = BuffinButton
	if not self.buffsByClassByType[self.class] then -- No class data.
		self:Print("There is no data available for your class. If you have some knowledge of addon development feel free to edit data.lua with buffs for your class. Please share anything you can contribute :)");		
		self.btn:Hide()
		return false
	end

	self.btn.normal = BuffinButtonNormalTexture
	self.btn.icon = BuffinButtonIcon
	self.btn.addon = Buffin

	self.btn:HookScript('OnClick', function(self, button)
		if GetBindingKey('CLICK BuffinButton:LeftButton') == 'MOUSEWHEELUP' then
			RunBinding('CAMERAZOOMIN')
		elseif GetBindingKey('CLICK BuffinButton:LeftButton') == 'MOUSEWHEELDOWN' then
			RunBinding('CAMERAZOOMOUT')
		end
	end)
end

function Buffin:OnEnable()
	self:LoadData()
	self:SetupGroup()
	self.group.ranges.player = true

	if self.db.char.options.position then 
		self.btn:ClearAllPoints()
		self.btn:SetPoint(unpack(self.db.char.options.position))
	end
	self:SetupCombatFrames()

	self:RegisterBucketEvent('PARTY_MEMBERS_CHANGED', 2, "SetupGroup")

	self:RegisterEvent("PLAYER_REGEN_DISABLED", 	"ToggleEvents", false)
	self:RegisterEvent("PLAYER_REGEN_ENABLED", 	"ToggleEvents", true)
	self:RegisterEvent("PLAYER_DEAD", 		"ToggleEvents", false)
	self:RegisterEvent("PLAYER_ALIVE", 		"ToggleEvents", true)
	self:RegisterEvent("PLAYER_UNGHOST", 		"ToggleEvents", true)
	self:RegisterBucketEvent("SPELLS_CHANGED", 2.0, "Force")
	--self:RegisterEvent("PLAYER_UPDATE_RESTING", "ToggleEvents", true)

	local on = (not InCombatLockdown() and not UnitIsDeadOrGhost('player')) and true or false
	self:ToggleEvents(on, 'entry')

	--self:ChooseNextSpell();
end

function Buffin:ToggleEvents(on, event)
	if event == "PLAYER_ALIVE" and UnitIsGhost('player') then on = false
	elseif event == "PLAYER_UPDATE_RESTING" then 
		on = not IsResting() 
		self.overrideOnly = not on
	end
	self.on = on

	if on == true then 
		self.bucket = self:RegisterBucketEvent({'UNIT_SPELLCAST_SUCCEEDED', 'UNIT_AURA', 'UNIT_INVENTORY_CHANGED', 'UNIT_PET'}, 0.8, 'ChooseNextSpell')
		self.rangeBucket = self:RegisterBucketMessage('UNIT_IN_RANGE', 1, function() if not InCombatLockdown() then self:ChooseNextGroupSpell(); self:ChooseNextSingleSpell() end end)
		self:UnregisterEvent('COMBAT_LOG_EVENT_UNFILTERED')
		self:RegisterEvent('COMBAT_LOG_EVENT_UNFILTERED', "OOCSpellcast")
		self:RegisterEvent('ROLE_CHANGED_INFORM', function(event, unit, changer, previous, new) self:ScheduleTimer(function() self:ChooseNextSingleSpell() end, 1.0) end)
		self:RegisterEvent('ACTIVE_TALENT_GROUP_CHANGED', function(event, newGroup) 
			--self:ScheduleTimer(function()
				self.primarySpecialisation = GetPrimaryTalentTree(false, false, newGroup) 
				self:ChooseNextSpell()
			--end, 1.0)

		end)
		self.rangeUpdate = self:ScheduleRepeatingTimer("SetupGroupRange", 5)
		self.durationUpdate = self:ScheduleRepeatingTimer("ChooseNextSpell", 30)

		self:UnregisterEvent('COMBAT_TEXT_UPDATE')

		if self.buffs.Combat then
			for id, spell in pairs(self.buffs.Combat.Unique) do
				if self.combatFrames[spell] then self:CombatFrameHide(spell) end
			end
		end
	else 
		self:UnregisterBucket(self.bucket)
		self:UnregisterBucket(self.rangeBucket)
		self:UnregisterEvent('UNIT_SPELLCAST_SUCCEEDED')
		self:UnregisterEvent('ROLE_CHANGED_INFORM')
		self:UnregisterEvent('ACTIVE_TALENT_GROUP_CHANGED') 
		self:CancelTimer(self.rangeUpdate, true)
		self:CancelTimer(self.durationUpdate, true)

		self:UnregisterEvent('COMBAT_LOG_EVENT_UNFILTERED')
		self:RegisterEvent('COMBAT_LOG_EVENT_UNFILTERED', 'CombatEvent')
		self:RegisterEvent('COMBAT_TEXT_UPDATE', 'CombatTextEvent')

		for spell,frame in pairs(self.combatFrames) do
			local isCast, expiresAt, count
			if spell.combatType == 'self' then isCast, expiresAt, count = self:IsCast(spell)
			elseif spell.combatType == 'single' then isCast, expiresAt, count = self:SingleIsCast(spell); end

			--TODO: add a stop here for timers?
			if expiresAt then self:CombatFrameStart(spell, spell.combatType == 'self' and 'player' or isCast)
			elseif spell.secure then self:CombatFrameStop(spell, true) end -- Simulate a Stop for effects.

			if frame:IsProtected() and not InCombatLockdown() then frame:Show() end
		end
	end
	--[[self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED", 	"ChooseNextSpell", on)
	self:RegisterEvent("UNIT_AURA", 		"ChooseNextSpell", on)]]

	if not on and not InCombatLockdown() then self.btn:Hide() 
	else 
		self:ChooseNextSpell() 
		if self.nextSpell and not InCombatLockdown() then self.btn:Show() end
	end
end

function Buffin:ChooseNextSpell(units)
	on = self.on
	if InCombatLockdown() or on==false then return end
	if units and not units['player'] then return end
		--[[if 	event == "UNIT_SPELLCAST_SUCCEEDED" 	and (args[1] ~= 'player' or (self.nextSpell and args[2] ~= self.nextSpell.name)) then return
		elseif 	event == "UNIT_AURA"			and (args[1] ~= 'player') then return end

		if	event == "UNIT_SPELLCAST_SUCCEEDED" and args[1] == 'player' and (self.nextSpell and args[2] == self.nextSpell.name) then self.nextSpell = nil end
	end]]

	if not self.primarySpecialisation then self.primarySpecialisation = GetPrimaryTalentTree() end

	if BuffinTotems then BuffinTotems:SetGroup() end

	-- selfish
	if self:ChooseNextSelfSpell() then return end
	--Weapons
	if self:ChooseNextWeaponSpell() then return end
	--Group buffs
	if self:ChooseNextGroupSpell() then return end
	--Singles
	if self:ChooseNextSingleSpell() then return end
	--Flasks
	if self:ChooseNextFlaskSpell() then return end
	Buffin:SetNextSpell()

end

function Buffin:ChooseNextSelfSpell()
	if not self.buffs.Self then return false end

	local candidateSpell, overridden
	for group, spells in pairs(self.buffs.Self) do
		local tmp = self:GetLearntSpell('Self', group)
		if tmp then candidateSpell = tmp end
		
		if self.db.char.buffs.Self[group] == false then return false	
		elseif not self.db.char.buffs.Self[group] then --or #self.db.char.self[group] == 0 then --Dynamic
			for spellID, options in pairs(spells) do
				if options.available then
					local over = options.override and options.override() or nil 
					if over then 
						overridden = true
						candidateSpell = options 
						break
					end

					local dyn = options.dynamic and options.dynamic() or false
					if candidateSpell == nil and dyn and over ~= false and not self:IsCast(options) then candidateSpell = options end
				end
			end
		else
			for spellID, options in pairs(spells) do
				if spellID > 0 and options.available then
					local over = options.override and options.override() or nil
					if over then 
						overridden = true
						candidateSpell = options
						break
					end
						
					if candidateSpell == nil and self.db.char.buffs.Self[group][options.id] and not self:IsCast(options) then candidateSpell = options end
				end
			end
		end
	end

	if candidateSpell and candidateSpell.satisfied and candidateSpell.satisfied(candidateSpell) then 
		if self.nextSpell and self.nextSpell.satisfied and self.nextSpell.satisfied(self.nextSpell) then self.nextSpell = nil end
		return false
	end

	-- go no further if we still need to cast the previous spell TODO: check if we still want it.
	if self.nextSpell ~= nil and candidateSpell and not overridden then 
		if not self:IsCast(self.nextSpell) then return true end
	end 

	if (overridden and self:IsCast(candidateSpell)) or (not overridden and IsMounted()) then self.nextSpell = nil
	else self.nextSpell = candidateSpell end
	
	if self.nextSpell ~= nil then
		Buffin:SetNextSpell()
		return true
	end
	return false
end

function Buffin:ChooseNextGroupSpell(units)
	if not self.buffs.Group then return end
	if IsMounted() then return end --TODO: change this to work with the override?
	if self.group.inRange == nil or (self.group.inRange < self.db.char.options.attendance and not (UnitIsPVP('player') and self.db.char.options.pvp)) then return end --TODO: Maybe return true so that we don't cancel buffs on our button already.
	if not units then units = {} end

	local candidateSpell

	for group, spells in pairs(self.buffs.Group) do
		local tmp = self:GetLearntSpell('Group', group)
		if tmp then
			candidateSpell = tmp
			break
		end
			
		if self.db.char.buffs.Group[group] == false then return false
		elseif not self.db.char.buffs.Group[group] then --Dynamic
			if group ~= 'Unique' and group ~= 'Intellect' and group ~= 'Call' then --FIXME- Hack for Arcane Brilliance/Dalaran Brilliance :(
				local peopleWithBuff = {}
				for spellID, options in pairs(spells) do
					if options.available == true then
						if not peopleWithBuff[spellID] then peopleWithBuff[spellID] = 0 end
						if options.priority then
							for i=1,#options.priority do
								if options.priority[i] == self.class then break end
								if self.group.classes and self.group.classes[options.priority[i]] then peopleWithBuff[spellID] = peopleWithBuff[spellID]+1 end
							end
						end
					end
				end

				local minSpell, minPriority, castPriority
				for spellID, priority in pairs(peopleWithBuff) do
					local present, expiresAt, whose = self:GroupIsCast(spells[spellID])
					if present and whose == 'player' and spells[spellID].priority.priority then
						castPriority = spells[spellID].priority.priority
					end

					if (minPriority == nil or priority < minPriority) then
						minSpell = spellID
						minPriority = priority
					end
					
					--self:dump('hi', spells[spellID].name, present, whose, minPriority, priority, minSpell)
				end
				if minSpell and not self:GroupIsCast(spells[minSpell]) and (castPriority == nil or spells[minSpell].priority.priority < castPriority) then candidateSpell = spells[minSpell] end

			else
				for spellID, spell in pairs(spells) do
					if spell.available and (spell.dynamic and spell.dynamic()) and not ((spell.satisfied and spell.satisfied()) or self:GroupIsCast(spell)) then 
						candidateSpell = spell
						break
					end
				end
			end

		else
			for id,_ in pairs(self.db.char.buffs.Group[group]) do
				if id > 0 and self.buffs.Group[group][id].available and not self:GroupIsCast(self.buffs.Group[group][id]) then
					candidateSpell = self.buffs.Group[group][id]
					break
				end
			end
		end
	end
	
	--TODO: this check will need to go upwards into the candidate selection?
	--[[local missingInRange = false
	if candidateSpell then 
		units.player = true
		for unit,inRange in pairs(self.group.ranges) do
			if inRange then
				if not self:IsCast(candidateSpell, unit) and not UnitIsDeadOrGhost(unit) then 
					--print(candidateSpell.name ..' missing on '.. unit)
					missingInRange = true
					break
				end
			end
		end
	end]]

	-- go no further if we still need to cast the previous spell TODO: check if we still want it.
	if self.nextSpell ~= nil and candidateSpell then 
		if not self:IsCast(self.nextSpell) then return true end --TODO: Make group check?
	end 			
	
	self.nextSpell = candidateSpell

	if self.nextSpell ~= nil then
		Buffin:SetNextSpell()
		return true
	end
	return false
end

function Buffin:ChooseNextWeaponSpell()
	if not self.buffs.Weapon then return false end
	if IsMounted() then return false end
	local candidateSpell

	for group, spells in pairs(self.buffs.Weapon) do
		local tmp = self:GetLearntSpell('Weapon', group)
		if tmp then
			candidateSpell = tmp
			break
		end
			
		if (group == 'Off' and OffhandHasWeapon()) or (group == 'Main' and GetInventoryItemID('player', 16) or (group == 'Ranged' and GetInventoryItemID('player', 18))) then
			if self.db.char.buffs.Weapon[group] == false then return false
			elseif not self.db.char.buffs.Weapon[group] then --Dynamic
				for spellID, options in pairs(spells) do
					if options.available and (options.type ~= 'item' or GetItemCount(options.name)) then
						local dyn 
						if options.dynamic then dyn = options.dynamic()
						else dyn = false end

						if dyn and not self:WeaponIsCast(spells[spellID]) then 
							candidateSpell = spells[spellID]
							break -- TODO: OK as is, no override for weapons needed?
						end
					end
				end
			else
				for id,_ in pairs(self.db.char.buffs.Weapon[group]) do
					if id > 0 and self.buffs.Weapon[group][id] and not self:WeaponIsCast(self.buffs.Weapon[group][id]) then
						candidateSpell = self.buffs.Weapon[group][id]
						if (candidateSpell.slot == 17 and not OffhandHasWeapon()) or (candidateSpell.slot == 16 and not GetInventoryItemLink('player', 16)) or (candidateSpell.slot == 18 and not GetInventoryItemID('player', 18)) then candidateSpell = nil end
						break
					end
				end
			end
		end
		if candidateSpell then break end --TODO: move if override
	end

	if self.nextSpell ~= nil and candidateSpell then
		if not self:IsCast(self.nextSpell) then return true end
	end

	self.nextSpell = candidateSpell
	if self.nextSpell ~= nil then
		Buffin:SetNextSpell()
		return true
	end
	return false
end

function Buffin:ChooseNextSingleSpell()
	if not self.buffs.Single then return end
	if IsMounted() then return false end
	
	local candidateSpell,candidateUnit
	for group, spells in pairs(self.buffs.Single) do
		--TODO: learn?
		if self.db.char.buffs.Single[group] == false then return false
		elseif not self.db.char.buffs.Single[group] then --Dynamic
			for spellID, options in pairs(spells) do
				if options.available then
					local dyn = options.dynamic and options.dynamic() or false
					if dyn then
						if type(options.target) == 'string' then
							for unit,inRange in pairs(self.group.ranges) do
								if UnitGroupRolesAssigned(unit) == options.target then
									candidateUnit = unit
									break
								end
							end
							if not candidateUnit and not options.notSelf then candidateUnit = 'player' end
						elseif type(options.target) == 'function' then candidateUnit = options.target()
						else candidateUnit = 'player' end
						
						if candidateUnit and ((options.type == 'item' and GetItemCooldown(spellID) == 0) or IsSpellInRange(options.name, candidateUnit) == 1) and not UnitIsDeadOrGhost(candidateUnit) and not self:IsCast(spells[spellID], candidateUnit) then
							candidateSpell = spells[spellID]
							break
						end
					end
				end
			end
		else
			for id,guid in pairs(self.db.char.buffs.Single[group]) do
				if id > 0 then
					local unit = self.group.guidUnitLookup[guid]
					if not unit or not UnitExists(unit) then
						if not self.buffs.Single[group][id].notSelf then
							unit = 'player'
							guid = self.playerGUID
						end 
					end

					if unit and self.buffs.Single[group][id].available and UnitGUID(unit) == guid and not self:IsCast(self.buffs.Single[group][id], unit) and (not self.buffs.Single[group][id].satisfied or self.buffs.Single[group][id].satisfied(candidateSpell, candidateUnit) and not (self.buffs.Single[group][id].notSelf and UnitIsUnit('player', unit))) then
						candidateSpell = self.buffs.Single[group][id]	
						candidateUnit = unit
						--self:Print('Candidate spell: '.. candidateSpell.name ..', unit: '.. unit ..', notSelf: '.. tostring(self.buffs.Single[group][id].notSelf) ..', if: '.. tostring(self.buffs.Single[group][id].notSelf and UnitIsUnit('player', unit)));
					end
				end
			end
		end
	end
	
	if self.nextSpell ~= nil and candidateSpell then
		if not self:IsCast(self.nextSpell, self.btn:GetAttribute('unit') or 'player') then return true end
	end

	self.nextSpell = candidateSpell
	if self.nextSpell ~= nil then
		Buffin:SetNextSpell(candidateUnit)
		return true
	end
	return false
end

function Buffin:ChooseNextFlaskSpell()
	if not self.buffs.Flask then return end
	if IsMounted() then return false end
	local candidateSpell = nil

	local tmp = self:GetLearntSpell('Flask', 'Flask')
	if tmp then
		candidateSpell = tmp
	elseif self.db.char.buffs.Flask.Flask == false then return false
	elseif not self.db.char.buffs.Flask.Flask then --Dynamic
		for spellID, options in pairs(self.buffs.Flask.Flask) do
			if options.available then
				local dyn = options.dynamic and options.dynamic() or false
				if candidateSpell == nil and dyn and not self:IsCast(options) and GetItemCount(spellID) > 0 then candidateSpell = options end
			end
		end
	else 
		for spellID, options in pairs(self.buffs.Flask.Flask) do
			if spellID > 0 and options.available then
				if self.db.char.buffs.Flask.Flask[options.id] and not self:IsCast(options) and GetItemCount(spellID) > 0 then 
					candidateSpell = options
					break
				end
			end
		end
	end

	if self.nextSpell ~= nil and candidateSpell then
		if not self:IsCast(self.nextSpell) then return true end
	end
	self.nextSpell = candidateSpell

	if self.nextSpell ~= nil then
		Buffin:SetNextSpell(candidateSpell)
		return true
	end
	return false
end

function Buffin:SetNextSpell(unit)
	if InCombatLockdown() then return end
	if unit == nil or unit == true then unit = 'player' end
	if self.nextSpell == nil then
		self.btn:SetAttribute('spell', nil)
		self.btn:SetAttribute('item', nil)
		self.btn:SetAttribute('unit', nil)
		self.btn:Hide()
		return
	end

	if not self.nextSpell.type or self.nextSpell.type == 'spell' then
		self.btn:SetAttribute('type', 'spell')
		self.btn:SetAttribute('spell', '!'..self.nextSpell.name)
		self.btn:SetAttribute('unit', unit)
	elseif self.nextSpell.type == 'item' then
		self.btn:SetAttribute('type', 'item')
		self.btn:SetAttribute('item', self.nextSpell.name)
	end
	if self.nextSpell.slot then 
		--CancelItemTempEnchantment(self.nextSpell.slot == 16 and 1 or 2) --protected on beta :(
		self.btn:SetAttribute('target-slot', self.nextSpell.slot)
	else self.btn:SetAttribute('target-slot', nil) end

	self.btn.icon:SetTexture(self.nextSpell.texture)
	self.btn:Show();
end

function Buffin:GetLearntSpell(mode, group)
	if self.db.char.buffs[mode] and self.db.char.buffs[mode][group] and self.db.char.buffs[mode][group][-1] 
		and self.db.char.last[mode] and self.db.char.last[mode][group] then -- Learn
		local spell = self.lookupByID[self.db.char.last[mode][group][self.db.char.options.learningIncludesSpec and GetPrimaryTalentTree() or 0]]
		if spell and spell.available and not self:IsCast(spell) then
			return spell
		end
	end
	return false
end

function Buffin:Force()
	self.nextSpell = nil
	self:MakeOptions()
	self.primarySpecialisation = GetPrimaryTalentTree()
	self:SetupGroup()
	self:SetupGroupRange()
	self:SetupCombatFrames()
	self:ChooseNextSpell()
end

function Buffin:SetupGroup()
	self.group.classes = {}
	local party,raid = GetNumPartyMembers(), GetNumRaidMembers()
	local maxMembers = party
	if raid > maxMembers then maxMembers = raid
	else self.group.classes[select(2, UnitClass('player'))] = 1 end

	self.group.unitGUIDLookup = {}
	for i=1,maxMembers do
		local unit = raid>0 and 'raid'..i or 'party'..i
		local guid = UnitGUID(unit)
		local class = select(2, UnitClass(unit))

		if not class then break end
		
		if self.group.classes[class] == nil then self.group.classes[class] = 1
		else self.group.classes[class] = self.group.classes[class]+1 end

		if self.group.ranges[unit] == nil then self.group.ranges[unit] = UnitInRange(unit) end
		self.group.unitGUIDLookup[unit] = guid
		self.group.guidUnitLookup[guid] = unit
	end

	for unit,_ in pairs(self.group.ranges) do
		if not UnitExists(unit) then self.group.ranges[unit] = nil end
	end

	self:ChooseNextSpell()
end

function Buffin:OOCSpellcast(event, timestamp, logEvent,_, sourceGUID, sourceName, sourceFlags,_, destGUID, destName, destFlags,_, ...)
	if sourceGUID ~= self.playerGUID then return end

	if logEvent == "SPELL_CAST_SUCCESS" then
		local spellID, spellName = ...
		local spell = self.lookupByID[spellID]
		if not spell then return end
		if spell.learning ~= false then
			if not self.db.char.last[spell.mode][spell.group] or type(self.db.char.last[spell.mode][spell.group]) == 'number' then self.db.char.last[spell.mode][spell.group] = {} end -- the 'or' is incase anyone has an old database version
			if GetPrimaryTalentTree() then self.db.char.last[spell.mode][spell.group][GetPrimaryTalentTree()] = spellID end
			self.db.char.last[spell.mode][spell.group][0] = spellID 
		end

		if BuffinTotems and BuffinTotems.totemCalls[spellID] then BuffinTotems:TotemsDropped(spellID) end
	elseif logEvent == "SPELL_AURA_APPLIED" then
		local spellID, spellName, spellSchool = ...
		local spell = self.lookupByID[spellID]
		local combatSpell = self.lookupByCombatID[spellID]
		if combatSpell then combatSpell.guid = destGUID end

		if spell and spell.mode == 'Single' and self.db.char.buffs[spell.mode][spell.group] and self.db.char.buffs[spell.mode][spell.group][spell.id] then 
			self.db.char.buffs[spell.mode][spell.group][spell.id] = destGUID
		end

		if combatSpell and self.combatFrames[combatSpell] then
			if combatSpell.combatType == 'hostile' then self:CombatEventStart(combatSpell, destGUID) end
			if combatSpell.secure then
				combatSpell.guid = destGUID
				self.combatFrames[combatSpell]:SetAttribute('unit', self.group.guidUnitLookup[destGUID])
			end
		end
	end
end

function Buffin:SetupGroupRange() 
	if not self.playerGUID then self.playerGUID = UnitGUID('player') end
	if not self.group.unitGUIDLookup.player then 
		self.group.unitGUIDLookup.player = self.playerGUID
		self.group.guidUnitLookup[self.playerGUID] = 'player'
	end


	local party,raid = GetNumPartyMembers(), GetNumRaidMembers()
	local maxMembers = party
	if raid > maxMembers then 
		maxMembers = raid
		self.group.ranges['player'] = nil -- Because player will also be 'raid1'?
	elseif not self.group.ranges['player'] then self.group.ranges['player'] = true end

	self.group.inRange = 1
	for i=1,maxMembers do
		local unit = raid>0 and 'raid'..i or 'party'..i
		local range, checked = UnitInRange(unit)
		if checked and range and not UnitIsDeadOrGhost(unit) then
			if not self.group.ranges[unit] then self:SendMessage("UNIT_IN_RANGE", unit) end
			self.group.ranges[unit] = true
			self.group.inRange = self.group.inRange+1
		else self.group.ranges[unit] = false end
	end
	self.group.inRange = self.group.inRange / (maxMembers + 1)
end

function Buffin:dump(...)
	if not debug then return end
	local vars = {...}
	local loaded = IsAddOnLoaded('Blizzard_DebugTools')

	for i=1,#vars do
		if not loaded then
			if IsAddOnLoadOnDemand('Blizzard_DebugTools') then LoadAddOn('Blizzard_DebugTools') end
			loaded = true
		end
		DevTools_Dump(vars[i])
	end	
end

