Buffin.spareCombatFrames = {}
Buffin.combatFrames = {}
Buffin.totalCombatFrames = 0

function Buffin:SetupCombatFrames()
	if not self.buffs.Combat then return end
	local combatFrames, spareCombatFrames = Buffin.combatFrames, Buffin.spareCombatFrames

	for group, spells in pairs(self.buffs.Combat) do
		if not self.db.char.buffs.Combat[group] then --Dynamic
			for spellId, spell in pairs(spells) do
				if spell.available then
					local dyn
					if spell.dynamic and spell.dynamic() then dyn = true else dyn = false end
					if dyn and not combatFrames[spell] then
						self:SetupCombatFrame(spell)
					elseif not dyn and combatFrames[spell] then
						--Recycle the frame.
						table.insert(spareCombatFrames, combatFrames[spell])
						combatFrames[spell] = nil
					end
				elseif combatFrames[spell] then
					--Recycle the frame.
					table.insert(spareCombatFrames, combatFrames[spell])
					combatFrames[spell] = nil
				end
			end
		else
			for spellID,spell in pairs(self.buffs.Combat[group]) do
				if spell.available and self.db.char.buffs.Combat[group][spellID] and not combatFrames[spell] then 
					self:SetupCombatFrame(spell)
				elseif not self.db.char.buffs.Combat[group][spellID] and combatFrames[spell] then
					table.insert(spareCombatFrames, combatFrames[spell])
					combatFrames[spell] = nil
				end
			end
		end
	end

	for i=1,#spareCombatFrames do spareCombatFrames[i]:Hide() end
end

function Buffin:SetupCombatFrame(spell)
	local combatFrames, spareCombatFrames, frame = self.combatFrames, self.spareCombatFrames

	local found
	for i=1,#spareCombatFrames do
		if not spell.secure or (spell.secure and spareCombatFrames[i]:IsProtected()) then
			found = i
			break
		end
	end

	if found then
		combatFrames[spell] = spareCombatFrames[found]
		table.remove(spareCombatFrames, found)
	else
		combatFrames[spell] = self:CreateCombatFrame(spell)
	end
	frame = combatFrames[spell]

	if self.db.char.combatOptions['bind'..spell.id] then
		SetBindingClick(self.db.char.combatOptions['bind'..spell.id], frame:GetName())
	end

	frame:SetID(spell.id)
	if self.db.char.combatOptions.framePositions[spell.id] then 
		frame:ClearAllPoints()
		frame:SetPoint(unpack(self.db.char.combatOptions.framePositions[spell.id]))
	else
		frame:ClearAllPoints()
		frame:SetPoint("CENTER", UIParent, "CENTER", 0,0)
	end

	frame.icon:SetTexture(spell.texture)
	frame:SetAlpha(0)
end

function Buffin:CreateCombatFrame(spell)
	self.totalCombatFrames = self.totalCombatFrames + 1

	local frame
	if not spell.secure then frame = CreateFrame('Frame', 'BuffinCombatFrame'..self.totalCombatFrames, UIParent, 'BuffinCombatTemplate')
	else 
		frame = CreateFrame('Button', 'BuffinCombatFrame'..self.totalCombatFrames, UIParent, 'BuffinSecureTemplate')
		frame.normal = _G['BuffinCombatFrame'..self.totalCombatFrames..'NormalTexture']
		frame.normal:SetAlpha(0)
		frame.flash = _G[frame:GetName()..'Flash']

		frame:SetAttribute('type', spell.type)
		frame:SetAttribute(spell.type, spell.name)

		local oocSpell = self.lookupByID[spell.id]
		if oocSpell and self.db.char.buffs[oocSpell.mode] and self.db.char.buffs[oocSpell.mode][oocSpell.group] and type(self.db.char.buffs[oocSpell.mode][oocSpell.group][oocSpell.id]) == 'string' then
			if spell.type == 'spell' then frame:SetAttribute('unit', self.group.guidUnitLookup[self.db.char.buffs[oocSpell.mode][oocSpell.group][oocSpell.id]]) end
		end

		frame:SetScript("OnEnter", function(frame)
			if frame:GetAlpha() == 0 then return end
			GameTooltip:SetOwner(frame, "ANCHOR_RIGHT")
			GameTooltip:SetText(spell.name .. "\nLinked: " .. UnitName(frame:GetAttribute('unit') or 'player') .. 
				"\nLast: " .. UnitName(self.group.guidUnitLookup[spell.guid] or 'player'))
			if frame.timeLeft then 
				local stt = SecondsToTime(frame.timeLeft)
				GameTooltip:AddLine("Remaining: " .. (stt ~= "" and stt or "expired") ..".")
			end
			GameTooltip:Show()
		end)
		frame:SetScript("OnLeave", function(self)
			GameTooltip:Hide()
		end)
	end
	self.combatFrames[spell] = frame

	frame.icon = _G['BuffinCombatFrame'..self.totalCombatFrames..'Icon']
	frame.addon = self
	frame:SetScale(self.db.char.combatOptions.scale)
	
	return frame
end

function Buffin:CombatEvent(event, timestamp, logEvent,_, sourceGUID, sourceName, sourceFlags,_, destGUID, destName, destFlags,_, ...)
	if sourceGUID ~= self.playerGUID then return end

	if logEvent:sub(1, 10) == "SPELL_AURA" then
		local spellID, spellName, spellSchool = ...
		local spell = self.lookupByCombatID[spellID]
		if not spell or not Buffin.combatFrames[spell] then return end

		if spell.combatType ~= 'hostile' and spell.combatType ~= 'single' and destGUID ~= self.playerGUID then return end

		if logEvent == "SPELL_AURA_APPLIED" or logEvent == "SPELL_AURA_APPLIED_DOSE" or logEvent == "SPELL_AURA_REMOVED_DOSE" or logEvent == "SPELL_AURA_REFRESH" then 
			self:CombatEventStart(spell, destGUID)
		elseif logEvent == "SPELL_AURA_REMOVED" or logEvent == "SPELL_AURA_BROKEN" or logEvent == "SPELL_AURA_BROKEN_SPELL" then 
			self:CombatEventStop(spell, destGUID) 
		end
	elseif logEvent == "SPELL_CAST_SUCCESS" then
		local spellID, spellName = ...
		local spell = self.lookupByCombatID[spellID]
		if BuffinTotems and BuffinTotems.totemCalls[spellID] then BuffinTotems:TotemsDropped(spellID) end

		if not spell or not Buffin.combatFrames[spell] then return end

		if spell.once then self:CombatFrameStop(spell) 
		--[[elseif spell.combatType == 'hostile' then self:CombatEventStart(spell, destGUID)]] end

	end
end
function Buffin:CombatTextEvent(event, textEvent, arg1, arg2)
	if textEvent == "SPELL_ACTIVE" then
		local spell = self.lookupByName[arg1]
		if not spell or not Buffin.combatFrames[spell] then return end

		if spell.ctuDuration then self:CombatFrameStart(spell, spell.ctuDuration) end
	end
end

function Buffin:CombatEventStart(spell, destGUID)
	local unit
	if spell.combatType == 'hostile' then
		--Find GUID
		local units, done = {'target', 'mouseover', 'focus', 'targettarget', 'boss1', 'boss2', 'boss3', 'boss4', 'player'} --'player' for Arcane Barrage
		for i=1,#units do
			if UnitGUID(units[i]) == destGUID then
				unit = units[i]
				break
			end
		end
	else
		unit = destGUID == self.playerGUID and 'player' or self.group.guidUnitLookup[destGUID]
	end
	spell.guid = destGUID
	if not unit then return end

	self:CombatFrameStart(spell, unit)
end

function Buffin:CombatFrameStart(spell, unit) --TODO: change to a timer that triggers the showing at <= 10 sec and always get new expiry from UnitBuff?
	local frame = self.combatFrames[spell]
	if not frame then return end

	frame:SetAlpha(self.db.char.combatOptions.alpha)
	if not (InCombatLockdown() and frame:IsProtected()) then frame:Show() end --protected frames are already shown in ToggleEvents
	AnimatedShine_Stop(frame)

	self:CancelTimer(frame.alphaTimer, true)

	frame.active = true

	frame.timeLeft = nil
	self:CombatFrameDisplay(spell, unit)
	self:CancelTimer(frame.ticker, true)
	frame.ticker = self:ScheduleTimer('CombatFrameDisplay', 1, spell)
end

function Buffin:CombatFrameDisplay(spell, unit)
	local frame = self.combatFrames[spell]
	-- get current spell details
	if not unit then unit = self.group.guidUnitLookup[spell.guid] or 'player' end
	local isCast, expiresAt, count = self:IsCast(spell, unit)
	local timeLeft

	if spell.combatType == 'hostile' and not isCast and frame.timeLeft then timeLeft = frame.timeLeft - 1
	elseif expiresAt then timeLeft = expiresAt - GetTime() else
		return --didn't find a timeLeft, maybe hide the frame?
	end

	if timeLeft >= 0 then frame.ticker = self:ScheduleTimer('CombatFrameDisplay', 1, spell)
	else self:CombatFrameStop(spell, InCombatLockdown()) end
	frame.timeLeft = timeLeft

	if not count or count < 2 then frame.count:Hide() 
	else
		frame.count:SetText(count)
		frame.count:Show()
	end
	
	if frame:IsProtected() and unit then 
		if not UnitIsUnit(frame:GetAttribute('unit') or 'player', unit) then frame.icon:SetDesaturated(true)
		else frame.icon:SetDesaturated(false) end
	end

	if self.db.char.combatOptions.showDuration == 0 or frame.timeLeft <= self.db.char.combatOptions.showDuration then 
		if frame.timeLeft > 60 then frame.duration:SetText(math.floor((frame.timeLeft + 60)/60) .. 'm') --TODO: +59/60?
		else frame.duration:SetText(math.floor(frame.timeLeft+0.5)) end
		if frame.active then frame.duration:Show() end

		--Alpha timer.
		if frame.timeLeft <= 10 and frame:GetAlpha() ~= 0 and not frame.alphaTimer then
			frame.alphaDelta = -0.1 --kek
			frame.alphaTimer = self:ScheduleRepeatingTimer(function()
				local currentAlpha = frame:GetAlpha()
				if currentAlpha ~= 0 then
					local alpha = currentAlpha + frame.alphaDelta
					if alpha < 0.2 or alpha > self.db.char.combatOptions.alpha then frame.alphaDelta = -frame.alphaDelta end
					frame:SetAlpha(alpha)
				end
			end, 0.05)
		elseif frame.timeLeft > 10 and frame.alphaTimer then
			self:CancelTimer(frame.alphaTimer, true)
			frame.alphaTimer = nil
		end
	else frame.duration:Hide() end
end

function Buffin:CombatEventStop(spell, destGUID) -- Called when the event expires during combat. --TODO: Doesn't seem to be any different from CombatFrameStop now that durations are refreshed in the ticker.

	if spell.combatType == 'single' and spell.guid ~= destGUID then return end -- somehow EventStop started to be called via CombatEvent after EventStart in cases where buffs were switched between different units.
	self:CancelTimer(self.combatFrames[spell].alphaTimer, true)
	self:CancelTimer(self.combatFrames[spell].ticker, true)
	self:CombatFrameHide(spell, nil, true)
end

function Buffin:CombatFrameHide(spell, frame, forceSecure) -- Hide the frame but keep the duration (at least) timer running.
	if frame == nil then frame = self.combatFrames[spell] end
	if not frame then return end

	if not spell.secure or not forceSecure then 
		frame:SetAlpha(0) 
		frame:Hide()
	elseif forceSecure then 
		AnimatedShine_Start(frame, 1,1,1)
		frame:SetAlpha(0.5)
		frame.duration:Hide()
		frame.count:Hide()
	end

	frame.active = false
end

function Buffin:CombatFrameStop(spell, forceSecure) -- Called when a timer reaches zero, stop everything --TODO: Doesn't seem to be any different from CombatEventStop now that durations are refreshed in the ticker.
	local frame = self.combatFrames[spell]
	if not frame then return end
	self:CancelTimer(frame.ticker, true)
	self:CancelTimer(frame.alphaTimer, true)
	frame.timeLeft = 0

	self:CombatFrameHide(spell, frame, forceSecure)	
end



