/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.smali.SmaliCodeVisitor;
import com.googlecode.d2j.smali.Utils;
import com.googlecode.d2j.smali.antlr4.SmaliBaseVisitor;
import com.googlecode.d2j.smali.antlr4.SmaliParser;
import com.googlecode.d2j.visitors.DexAnnotationAble;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import com.googlecode.d2j.visitors.DexFieldVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AntlrSmaliUtil {
    public static void acceptFile(SmaliParser.SFileContext ctx, DexFileVisitor dexFileVisitor) {
        String className = Utils.unEscapeId(ctx.className.getText());
        int access = AntlrSmaliUtil.collectAccess(ctx.sAccList());
        List<SmaliParser.SSuperContext> superContexts = ctx.sSuper();
        String superClass = null;
        if (superContexts.size() > 0) {
            superClass = Utils.unEscapeId(superContexts.get((int)(superContexts.size() - 1)).name.getText());
        }
        List<SmaliParser.SInterfaceContext> itfs = ctx.sInterface();
        String[] interfaceNames = null;
        if (itfs.size() > 0) {
            interfaceNames = new String[itfs.size()];
            for (int i = 0; i < itfs.size(); ++i) {
                interfaceNames[i] = Utils.unEscapeId(itfs.get((int)i).name.getText());
            }
        }
        DexClassVisitor dexClassVisitor = dexFileVisitor.visit(access, className, superClass, interfaceNames);
        List<SmaliParser.SSourceContext> sources = ctx.sSource();
        if (sources.size() > 0) {
            dexClassVisitor.visitSource(Utils.unescapeStr(sources.get((int)(sources.size() - 1)).src.getText()));
        }
        AntlrSmaliUtil.acceptAnnotations(ctx.sAnnotation(), (DexAnnotationAble)dexClassVisitor);
        AntlrSmaliUtil.acceptField(ctx.sField(), className, dexClassVisitor);
        AntlrSmaliUtil.acceptMethod(ctx.sMethod(), className, dexClassVisitor);
        dexClassVisitor.visitEnd();
    }

    private static void acceptMethod(List<SmaliParser.SMethodContext> sMethodContexts, String className, DexClassVisitor dexClassVisitor) {
        if (dexClassVisitor == null || sMethodContexts == null || sMethodContexts.size() == 0) {
            return;
        }
        for (SmaliParser.SMethodContext ctx : sMethodContexts) {
            AntlrSmaliUtil.acceptMethod(ctx, className, dexClassVisitor);
        }
    }

    public static void acceptMethod(SmaliParser.SMethodContext ctx, String className, DexClassVisitor dexClassVisitor) {
        Token methodObj = ctx.methodObj;
        Method method = methodObj.getType() == 242 ? Utils.parseMethodAndUnescape(methodObj.getText()) : Utils.parseMethodAndUnescape(className, methodObj.getText());
        int access = AntlrSmaliUtil.collectAccess(ctx.sAccList());
        boolean isStatic = 0 != (access & 8);
        DexMethodVisitor dexMethodVisitor = dexClassVisitor.visitMethod(access, method);
        if (dexMethodVisitor != null) {
            AntlrSmaliUtil.acceptAnnotations(ctx.sAnnotation(), (DexAnnotationAble)dexMethodVisitor);
            int ins = Utils.methodIns(method, isStatic);
            int totalRegisters = AntlrSmaliUtil.findTotalRegisters(ctx, ins);
            if (totalRegisters < 0) {
                totalRegisters = ins;
            }
            M m = new M(method, totalRegisters, ins, isStatic);
            AntlrSmaliUtil.acceptParameter(ctx.sParameter(), m, dexMethodVisitor);
            AntlrSmaliUtil.acceptCode(ctx, m, dexMethodVisitor);
            dexMethodVisitor.visitEnd();
        }
    }

    private static void acceptCode(SmaliParser.SMethodContext ctx, final M m, DexMethodVisitor dexMethodVisitor) {
        if (ctx == null || dexMethodVisitor == null) {
            return;
        }
        DexCodeVisitor dexCodeVisitor = dexMethodVisitor.visitCode();
        if (dexCodeVisitor == null) {
            return;
        }
        final SmaliCodeVisitor scv = new SmaliCodeVisitor(dexCodeVisitor);
        final DexDebugVisitor dexDebugVisitor = scv.visitDebug();
        List<SmaliParser.SInstructionContext> instructionContexts = ctx.sInstruction();
        SmaliBaseVisitor v = new SmaliBaseVisitor(){
            Map<String, DexLabel> labelMap = new HashMap<String, DexLabel>();

            @Override
            public Object visitFregisters(SmaliParser.FregistersContext ctx) {
                return null;
            }

            @Override
            public Object visitFlocals(SmaliParser.FlocalsContext ctx) {
                return null;
            }

            @Override
            public Object visitFline(SmaliParser.FlineContext ctx) {
                if (dexDebugVisitor != null) {
                    DexLabel dexLabel = new DexLabel();
                    scv.visitLabel(dexLabel);
                    dexDebugVisitor.visitLineNumber(Utils.parseInt(ctx.line.getText()), dexLabel);
                }
                return null;
            }

            @Override
            public Object visitFend(SmaliParser.FendContext ctx) {
                if (dexDebugVisitor != null) {
                    DexLabel dexLabel = new DexLabel();
                    scv.visitLabel(dexLabel);
                    int reg = m.pareReg(ctx.r.getText());
                    dexDebugVisitor.visitEndLocal(reg, dexLabel);
                }
                return null;
            }

            @Override
            public Object visitFlocal(SmaliParser.FlocalContext ctx) {
                if (dexDebugVisitor != null) {
                    String type;
                    String name;
                    DexLabel dexLabel = new DexLabel();
                    scv.visitLabel(dexLabel);
                    int reg = m.pareReg(ctx.r.getText());
                    if (ctx.v1 != null) {
                        Field fld = Utils.parseFieldAndUnescape("Lt;", ctx.v1.getText());
                        name = fld.getName();
                        type = fld.getType();
                    } else if (ctx.v2 != null) {
                        String txt = ctx.v2.getText();
                        int i = Utils.findString(txt, 1, txt.length(), '\"');
                        name = Utils.unescapeStr(txt.substring(0, i + 1));
                        type = Utils.unEscapeId(txt.substring(i + 2));
                    } else {
                        name = ctx.name2 != null ? Utils.unescapeStr(ctx.name2.getText()) : Utils.unEscapeId(ctx.name1.getText());
                        type = Utils.unEscapeId(ctx.type.getText());
                    }
                    String sig = ctx.sig == null ? null : Utils.unescapeStr(ctx.sig.getText());
                    dexDebugVisitor.visitStartLocal(reg, dexLabel, name, type, sig);
                }
                return null;
            }

            @Override
            public Object visitFrestart(SmaliParser.FrestartContext ctx) {
                if (dexDebugVisitor != null) {
                    DexLabel dexLabel = new DexLabel();
                    scv.visitLabel(dexLabel);
                    int reg = m.pareReg(ctx.r.getText());
                    dexDebugVisitor.visitRestartLocal(reg, dexLabel);
                }
                return null;
            }

            @Override
            public Object visitFprologue(SmaliParser.FprologueContext ctx) {
                if (dexDebugVisitor != null) {
                    DexLabel dexLabel = new DexLabel();
                    scv.visitLabel(dexLabel);
                    dexDebugVisitor.visitPrologue(dexLabel);
                }
                return null;
            }

            @Override
            public Object visitSLabel(SmaliParser.SLabelContext ctx) {
                scv.visitLabel(this.getLabel(ctx.label.getText()));
                return null;
            }

            @Override
            public Object visitFspareswitch(SmaliParser.FspareswitchContext ctx) {
                List<TerminalNode> ints = ctx.INT();
                List<TerminalNode> ts = ctx.LABEL();
                int[] cases = new int[ts.size()];
                DexLabel[] labels = new DexLabel[ts.size()];
                for (int i = 0; i < ts.size(); ++i) {
                    cases[i] = Utils.parseInt(ints.get(i).getSymbol().getText());
                    labels[i] = this.getLabel(ts.get(i).getSymbol().getText());
                }
                scv.dSparseSwitch(cases, labels);
                return null;
            }

            @Override
            public Object visitFarraydata(SmaliParser.FarraydataContext ctx) {
                int size = Utils.parseInt(ctx.size.getText());
                List<SmaliParser.SBaseValueContext> ts = ctx.sBaseValue();
                byte[] ps = new byte[ts.size()];
                for (int i = 0; i < ts.size(); ++i) {
                    ps[i] = ((Number)AntlrSmaliUtil.parseBaseValue(ts.get(i))).byteValue();
                }
                scv.dArrayData(size, ps);
                return null;
            }

            Op getOp(Token t) {
                return Utils.getOp(t.getText());
            }

            @Override
            public Object visitF0x(SmaliParser.F0xContext ctx) {
                scv.visitStmt0R(this.getOp(ctx.op));
                return null;
            }

            @Override
            public Object visitF0t(SmaliParser.F0tContext ctx) {
                scv.visitJumpStmt(this.getOp(ctx.op), 0, 0, this.getLabel(ctx.target.getText()));
                return null;
            }

            @Override
            public Object visitF1x(SmaliParser.F1xContext ctx) {
                scv.visitStmt1R(this.getOp(ctx.op), m.pareReg(ctx.r1.getText()));
                return null;
            }

            @Override
            public Object visitFconst(SmaliParser.FconstContext ctx) {
                Op op = this.getOp(ctx.op);
                int r = m.pareReg(ctx.r1.getText());
                Token cst = ctx.cst;
                switch (op) {
                    case CONST_STRING: 
                    case CONST_STRING_JUMBO: {
                        scv.visitConstStmt(op, r, Utils.unescapeStr(cst.getText()));
                        break;
                    }
                    case CONST_CLASS: {
                        scv.visitConstStmt(op, r, new DexType(Utils.unEscapeId(cst.getText())));
                        break;
                    }
                    case CHECK_CAST: 
                    case NEW_INSTANCE: {
                        scv.visitTypeStmt(op, r, 0, Utils.unEscapeId(cst.getText()));
                        break;
                    }
                    case CONST_WIDE: {
                        scv.visitConstStmt(op, r, cst.getType() == 259 ? (long)Utils.parseInt(cst.getText()) : Utils.parseLong(cst.getText()));
                        break;
                    }
                    case CONST_WIDE_16: {
                        long v = cst.getType() == 256 ? Utils.parseLong(cst.getText()) : (long)((short)Utils.parseInt(cst.getText()));
                        scv.visitConstStmt(op, r, v);
                        break;
                    }
                    case CONST_WIDE_32: {
                        long v = cst.getType() == 256 ? Utils.parseLong(cst.getText()) : (long)Utils.parseInt(cst.getText());
                        scv.visitConstStmt(op, r, v);
                        break;
                    }
                    case CONST_WIDE_HIGH16: {
                        long v;
                        if (cst.getType() == 256) {
                            v = Utils.parseLong(cst.getText());
                        } else {
                            v = (short)Utils.parseInt(cst.getText());
                            v <<= 48;
                        }
                        scv.visitConstStmt(op, r, v);
                        break;
                    }
                    case CONST: 
                    case CONST_4: 
                    case CONST_16: {
                        int v = Utils.parseInt(cst.getText());
                        scv.visitConstStmt(op, r, v);
                        break;
                    }
                    case CONST_HIGH16: {
                        int v = Utils.parseInt(cst.getText());
                        scv.visitConstStmt(op, r, v <<= 16);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                return null;
            }

            @Override
            public Object visitFf1c(SmaliParser.Ff1cContext ctx) {
                int r = m.pareReg(ctx.r1.getText());
                Field field = Utils.parseFieldAndUnescape(ctx.fld.getText());
                scv.visitFieldStmt(this.getOp(ctx.op), r, 0, field);
                return null;
            }

            @Override
            public Object visitFt2c(SmaliParser.Ft2cContext ctx) {
                int r1 = m.pareReg(ctx.r1.getText());
                int r2 = m.pareReg(ctx.r2.getText());
                scv.visitTypeStmt(this.getOp(ctx.op), r1, r2, Utils.unEscapeId(ctx.type.getText()));
                return null;
            }

            @Override
            public Object visitFf2c(SmaliParser.Ff2cContext ctx) {
                int r1 = m.pareReg(ctx.r1.getText());
                int r2 = m.pareReg(ctx.r2.getText());
                scv.visitFieldStmt(this.getOp(ctx.op), r1, r2, Utils.parseFieldAndUnescape(ctx.fld.getText()));
                return null;
            }

            @Override
            public Object visitF2x(SmaliParser.F2xContext ctx) {
                int r1 = m.pareReg(ctx.r1.getText());
                int r2 = m.pareReg(ctx.r2.getText());
                scv.visitStmt2R(this.getOp(ctx.op), r1, r2);
                return null;
            }

            @Override
            public Object visitF3x(SmaliParser.F3xContext ctx) {
                int r1 = m.pareReg(ctx.r1.getText());
                int r2 = m.pareReg(ctx.r2.getText());
                int r3 = m.pareReg(ctx.r3.getText());
                scv.visitStmt3R(this.getOp(ctx.op), r1, r2, r3);
                return null;
            }

            @Override
            public Object visitFt5c(SmaliParser.Ft5cContext ctx) {
                Op op = this.getOp(ctx.op);
                List<TerminalNode> ts = ctx.REGISTER();
                int[] rs = new int[ts.size()];
                for (int i = 0; i < ts.size(); ++i) {
                    rs[i] = m.pareReg(ts.get(i).getSymbol().getText());
                }
                scv.visitFilledNewArrayStmt(op, rs, Utils.unEscapeId(ctx.type.getText()));
                return null;
            }

            @Override
            public Object visitFm5c(SmaliParser.Fm5cContext ctx) {
                Op op = this.getOp(ctx.op);
                List<TerminalNode> ts = ctx.REGISTER();
                int[] rs = new int[ts.size()];
                for (int i = 0; i < ts.size(); ++i) {
                    rs[i] = m.pareReg(ts.get(i).getSymbol().getText());
                }
                scv.visitMethodStmt(op, rs, Utils.parseMethodAndUnescape(ctx.method.getText()));
                return null;
            }

            @Override
            public Object visitFmrc(SmaliParser.FmrcContext ctx) {
                if (ctx.rstart != null) {
                    int start = m.pareReg(ctx.rstart.getText());
                    int end = m.pareReg(ctx.rend.getText());
                    int size = end - start + 1;
                    int[] rs = new int[size];
                    for (int i = 0; i < size; ++i) {
                        rs[i] = start + i;
                    }
                    scv.visitMethodStmt(this.getOp(ctx.op), rs, Utils.parseMethodAndUnescape(ctx.method.getText()));
                } else {
                    scv.visitMethodStmt(this.getOp(ctx.op), new int[0], Utils.parseMethodAndUnescape(ctx.method.getText()));
                }
                return null;
            }

            @Override
            public Object visitFtrc(SmaliParser.FtrcContext ctx) {
                if (ctx.rstart != null) {
                    int start = m.pareReg(ctx.rstart.getText());
                    int end = m.pareReg(ctx.rend.getText());
                    int size = end - start + 1;
                    int[] rs = new int[size];
                    for (int i = 0; i < size; ++i) {
                        rs[i] = start + i;
                    }
                    scv.visitFilledNewArrayStmt(this.getOp(ctx.op), rs, Utils.unEscapeId(ctx.type.getText()));
                } else {
                    scv.visitFilledNewArrayStmt(this.getOp(ctx.op), new int[0], Utils.unEscapeId(ctx.type.getText()));
                }
                return null;
            }

            @Override
            public Object visitF31t(SmaliParser.F31tContext ctx) {
                scv.visitF31tStmt(this.getOp(ctx.op), m.pareReg(ctx.r1.getText()), this.getLabel(ctx.label.getText()));
                return null;
            }

            @Override
            public Object visitF1t(SmaliParser.F1tContext ctx) {
                scv.visitJumpStmt(this.getOp(ctx.op), m.pareReg(ctx.r1.getText()), 0, this.getLabel(ctx.label.getText()));
                return null;
            }

            @Override
            public Object visitF2t(SmaliParser.F2tContext ctx) {
                scv.visitJumpStmt(this.getOp(ctx.op), m.pareReg(ctx.r1.getText()), m.pareReg(ctx.r2.getText()), this.getLabel(ctx.label.getText()));
                return null;
            }

            @Override
            public Object visitF2sb(SmaliParser.F2sbContext ctx) {
                scv.visitStmt2R1N(this.getOp(ctx.op), m.pareReg(ctx.r1.getText()), m.pareReg(ctx.r2.getText()), Utils.parseInt(ctx.lit.getText()));
                return null;
            }

            @Override
            public Object visitFpackageswitch(SmaliParser.FpackageswitchContext ctx) {
                int start = Utils.parseInt(ctx.start.getText());
                List<TerminalNode> ts = ctx.LABEL();
                DexLabel[] labels = new DexLabel[ts.size()];
                for (int i = 0; i < ts.size(); ++i) {
                    labels[i] = this.getLabel(ts.get(i).getSymbol().getText());
                }
                scv.dPackedSwitch(start, labels);
                return null;
            }

            @Override
            public Object visitFcache(SmaliParser.FcacheContext ctx) {
                scv.visitTryCatch(this.getLabel(ctx.start.getText()), this.getLabel(ctx.end.getText()), new DexLabel[]{this.getLabel(ctx.handle.getText())}, new String[]{Utils.unEscapeId(ctx.type.getText())});
                return null;
            }

            @Override
            public Object visitFcacheall(SmaliParser.FcacheallContext ctx) {
                scv.visitTryCatch(this.getLabel(ctx.start.getText()), this.getLabel(ctx.end.getText()), new DexLabel[]{this.getLabel(ctx.handle.getText())}, new String[]{null});
                return null;
            }

            DexLabel getLabel(String name) {
                DexLabel dexLabel = this.labelMap.get(name);
                if (dexLabel == null) {
                    dexLabel = new DexLabel();
                    this.labelMap.put(name, dexLabel);
                }
                return dexLabel;
            }

            @Override
            public Object visitFepiogue(SmaliParser.FepiogueContext ctx) {
                if (dexDebugVisitor != null) {
                    DexLabel dexLabel = new DexLabel();
                    scv.visitLabel(dexLabel);
                    dexDebugVisitor.visitEpiogue(dexLabel);
                }
                return null;
            }
        };
        scv.visitRegister(m.total);
        if (dexDebugVisitor != null) {
            for (int i = 0; i < m.paramNames.length; ++i) {
                String name = m.paramNames[i];
                if (name == null) continue;
                dexDebugVisitor.visitParameterName(i, name);
            }
        }
        for (SmaliParser.SInstructionContext instructionContext : instructionContexts) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)instructionContext.getChild(0);
            parserRuleContext.accept((ParseTreeVisitor)v);
        }
        scv.visitEnd();
    }

    private static int findTotalRegisters(SmaliParser.SMethodContext ctx, int ins) {
        int totalRegisters = -1;
        List<SmaliParser.SInstructionContext> instructionContexts = ctx.sInstruction();
        for (SmaliParser.SInstructionContext instructionContext : instructionContexts) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)instructionContext.getChild(0);
            if (parserRuleContext == null) continue;
            int ruleIndex = parserRuleContext.getRuleIndex();
            if (ruleIndex == 21) {
                totalRegisters = Utils.parseInt(((SmaliParser.FregistersContext)parserRuleContext).xregisters.getText());
                break;
            }
            if (ruleIndex != 22) continue;
            totalRegisters = ins + Utils.parseInt(((SmaliParser.FlocalsContext)parserRuleContext).xlocals.getText());
            break;
        }
        return totalRegisters;
    }

    private static void acceptParameter(List<SmaliParser.SParameterContext> sParameterContexts, M m, DexMethodVisitor dexMethodVisitor) {
        if (sParameterContexts == null || sParameterContexts.size() == 0 || dexMethodVisitor == null) {
            return;
        }
        boolean hasParam = false;
        boolean hasParamter = false;
        for (SmaliParser.SParameterContext ctx : sParameterContexts) {
            if (ctx.param != null) {
                hasParam = true;
            }
            if (ctx.parameter == null) continue;
            hasParamter = true;
        }
        if (hasParam && hasParamter) {
            throw new RuntimeException("cant mix use .param and .parameter on method");
        }
        for (int i = 0; i < sParameterContexts.size(); ++i) {
            List<SmaliParser.SAnnotationContext> annotationContexts;
            SmaliParser.SParameterContext ctx;
            ctx = sParameterContexts.get(i);
            int index = ctx.param != null ? m.regToParamIdx(m.pareReg(ctx.r.getText())) : i;
            if (ctx.name != null) {
                m.setNameByIdx(index, Utils.unescapeStr(ctx.name.getText()));
            }
            if ((annotationContexts = ctx.sAnnotation()).size() <= 0) continue;
            AntlrSmaliUtil.acceptAnnotations(annotationContexts, dexMethodVisitor.visitParameterAnnotation(index));
        }
    }

    private static void acceptField(List<SmaliParser.SFieldContext> sFieldContexts, String className, DexClassVisitor dexClassVisitor) {
        if (sFieldContexts == null || sFieldContexts.size() == 0 || dexClassVisitor == null) {
            return;
        }
        for (SmaliParser.SFieldContext ctx : sFieldContexts) {
            AntlrSmaliUtil.acceptField(ctx, className, dexClassVisitor);
        }
    }

    public static void acceptField(SmaliParser.SFieldContext ctx, String className, DexClassVisitor dexClassVisitor) {
        DexFieldVisitor dexFieldVisitor;
        Token fieldObj = ctx.fieldObj;
        Field field = fieldObj.getType() == 244 ? Utils.parseFieldAndUnescape(fieldObj.getText()) : Utils.parseFieldAndUnescape(className, fieldObj.getText());
        int access = AntlrSmaliUtil.collectAccess(ctx.sAccList());
        Object value = null;
        SmaliParser.SBaseValueContext vctx = ctx.sBaseValue();
        if (vctx != null) {
            value = AntlrSmaliUtil.parseBaseValue(vctx);
        }
        if ((dexFieldVisitor = dexClassVisitor.visitField(access, field, value)) != null) {
            AntlrSmaliUtil.acceptAnnotations(ctx.sAnnotation(), (DexAnnotationAble)dexFieldVisitor);
            dexFieldVisitor.visitEnd();
        }
    }

    private static Object parseBaseValue(SmaliParser.SBaseValueContext ctx) {
        Token value;
        if (ctx.getChildCount() == 1) {
            TerminalNode tn = (TerminalNode)ctx.getChild(0);
            value = tn.getSymbol();
        } else {
            TerminalNode tn = (TerminalNode)ctx.getChild(1);
            value = tn.getSymbol();
        }
        switch (value.getType()) {
            case 261: {
                return Utils.unescapeStr(value.getText());
            }
            case 260: {
                return "true".equals(value.getText());
            }
            case 258: {
                return Utils.parseByte(value.getText());
            }
            case 257: {
                return Utils.parseShort(value.getText());
            }
            case 255: {
                return Utils.unescapeChar(value.getText());
            }
            case 259: {
                return Utils.parseInt(value.getText());
            }
            case 256: {
                return Utils.parseLong(value.getText());
            }
            case 249: 
            case 251: 
            case 253: {
                return Float.valueOf(Utils.parseFloat(value.getText()));
            }
            case 250: 
            case 252: 
            case 254: {
                return Utils.parseDouble(value.getText());
            }
            case 242: {
                return Utils.parseMethodAndUnescape(value.getText());
            }
            case 262: {
                return new DexType(Utils.unEscapeId(value.getText()));
            }
            case 280: {
                return null;
            }
            case 244: {
                return Utils.parseFieldAndUnescape(value.getText());
            }
        }
        return null;
    }

    private static void acceptAnnotations(List<SmaliParser.SAnnotationContext> sAnnotationContexts, DexAnnotationAble dexAnnotationAble) {
        if (dexAnnotationAble == null) {
            return;
        }
        if (sAnnotationContexts.size() > 0) {
            for (SmaliParser.SAnnotationContext ctx : sAnnotationContexts) {
                Visibility visibility = Utils.getAnnVisibility(ctx.visibility.getText());
                String type = Utils.unEscapeId(ctx.type.getText());
                DexAnnotationVisitor dexAnnotationVisitor = dexAnnotationAble.visitAnnotation(type, visibility);
                if (dexAnnotationVisitor == null) continue;
                List<SmaliParser.SAnnotationKeyNameContext> keys = ctx.sAnnotationKeyName();
                if (keys.size() > 0) {
                    List<SmaliParser.SAnnotationValueContext> values = ctx.sAnnotationValue();
                    for (int i = 0; i < keys.size(); ++i) {
                        AntlrSmaliUtil.acceptAnnotation(dexAnnotationVisitor, Utils.unEscapeId(keys.get(i).getText()), values.get(i));
                    }
                }
                dexAnnotationVisitor.visitEnd();
            }
        }
    }

    private static void acceptAnnotation(DexAnnotationVisitor dexAnnotationVisitor, String name, SmaliParser.SAnnotationValueContext ctx) {
        ParserRuleContext t = (ParserRuleContext)ctx.getChild(0);
        switch (t.getRuleIndex()) {
            case 8: {
                SmaliParser.SSubannotationContext subannotationContext = (SmaliParser.SSubannotationContext)t;
                DexAnnotationVisitor annotationVisitor = dexAnnotationVisitor.visitAnnotation(name, Utils.unEscapeId(subannotationContext.type.getText()));
                if (annotationVisitor == null) break;
                List<SmaliParser.SAnnotationKeyNameContext> keys = subannotationContext.sAnnotationKeyName();
                if (keys.size() > 0) {
                    List<SmaliParser.SAnnotationValueContext> values = subannotationContext.sAnnotationValue();
                    for (int i = 0; i < keys.size(); ++i) {
                        AntlrSmaliUtil.acceptAnnotation(annotationVisitor, Utils.unEscapeId(keys.get(i).getText()), values.get(i));
                    }
                }
                annotationVisitor.visitEnd();
                break;
            }
            case 13: {
                SmaliParser.SArrayValueContext arrayValueContext = (SmaliParser.SArrayValueContext)t;
                DexAnnotationVisitor annotationVisitor = dexAnnotationVisitor.visitArray(name);
                if (annotationVisitor == null) break;
                for (SmaliParser.SAnnotationValueContext annotationValueContext : arrayValueContext.sAnnotationValue()) {
                    AntlrSmaliUtil.acceptAnnotation(annotationVisitor, null, annotationValueContext);
                }
                annotationVisitor.visitEnd();
                break;
            }
            case 12: {
                SmaliParser.SBaseValueContext baseValueContext = (SmaliParser.SBaseValueContext)t;
                Object value = AntlrSmaliUtil.parseBaseValue(baseValueContext);
                dexAnnotationVisitor.visit(name, value);
            }
        }
    }

    private static int collectAccess(SmaliParser.SAccListContext ctx) {
        int access = 0;
        for (TerminalNode acc : ctx.ACC()) {
            access |= Utils.getAcc(acc.getSymbol().getText());
        }
        return access;
    }

    private static class M {
        int locals;
        String[] paramNames;
        int[] map;
        public int total;

        void setNameByIdx(int index, String name) {
            if (index >= 0 && index < this.paramNames.length) {
                this.paramNames[index] = name;
            }
        }

        int regToParamIdx(int reg) {
            int x = reg - this.locals;
            if (x >= 0 && x < this.map.length) {
                return this.map[x];
            }
            return 0;
        }

        int pareReg(String str) {
            char f = Character.toLowerCase(str.charAt(0));
            if (f == 'p') {
                return Utils.parseInt(str.substring(1)) + this.locals;
            }
            return Utils.parseInt(str.substring(1));
        }

        M(Method method, int totals, int ins, boolean isStatic) {
            this.locals = totals - ins;
            this.total = totals;
            String[] paramTypes = method.getParameterTypes();
            this.paramNames = new String[paramTypes.length];
            this.map = new int[ins];
            int start = 0;
            if (!isStatic) {
                this.map[start] = -1;
                ++start;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                char t = paramTypes[i].charAt(0);
                this.map[start++] = i;
                if (t != 'J' && t != 'D') continue;
                this.map[start++] = i;
            }
        }
    }
}

