/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfXNullFactory
extends InstructionFactory {
    public int cmp;

    public IfXNullFactory(int cmp) {
        this.cmp = cmp;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        short branch = (short)((code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF);
        list.add(new IfInstruction(262, offset, lineNumber, this.cmp, stack.pop(), branch));
        if (!stack.isEmpty()) {
            int nextOffset;
            Instruction instruction = (Instruction)stack.lastElement();
            if (instruction.opcode == 263 && (nextOffset = offset + ByteCodeConstants.NO_OF_OPERANDS[opcode] + 1) < code.length) {
                switch (code[nextOffset] & 0xFF) {
                    case 87: 
                    case 176: {
                        DupLoad dp = (DupLoad)instruction;
                        stack.push(new DupLoad(dp.opcode, dp.offset, dp.lineNumber, dp.dupStore));
                    }
                }
            }
        }
        return ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }
}

