/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.converter.IR2JConverter;
import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.DexExceptionHandler;
import com.googlecode.d2j.dex.ExDex2Asm;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.BaseDexFileReader;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class Dex2jar {
    private DexExceptionHandler exceptionHandler;
    private final BaseDexFileReader reader;
    private int readerConfig;
    private int v3Config;

    public static Dex2jar from(byte[] in) throws IOException {
        return Dex2jar.from((BaseDexFileReader)new DexFileReader(ZipUtil.readDex((byte[])in)));
    }

    public static Dex2jar from(ByteBuffer in) throws IOException {
        return Dex2jar.from((BaseDexFileReader)new DexFileReader(in));
    }

    public static Dex2jar from(BaseDexFileReader reader) {
        return new Dex2jar(reader);
    }

    public static Dex2jar from(File in) throws IOException {
        return Dex2jar.from(Files.readAllBytes(in.toPath()));
    }

    public static Dex2jar from(InputStream in) throws IOException {
        return Dex2jar.from((BaseDexFileReader)new DexFileReader(in));
    }

    public static Dex2jar from(String in) throws IOException {
        return Dex2jar.from(new File(in));
    }

    private Dex2jar(BaseDexFileReader reader) {
        this.reader = reader;
        this.readerConfig |= 1;
    }

    private void doTranslate(final Path dist) throws IOException {
        DexFileNode fileNode = new DexFileNode();
        try {
            this.reader.accept((DexFileVisitor)fileNode, this.readerConfig | 0x20);
        }
        catch (Exception ex) {
            this.exceptionHandler.handleFileException(ex);
        }
        ClassVisitorFactory cvf = new ClassVisitorFactory(){

            @Override
            public ClassVisitor create(final String name) {
                return new ClassVisitor(262144, (ClassVisitor)new ClassWriter(1)){

                    public void visitEnd() {
                        byte[] data;
                        super.visitEnd();
                        ClassWriter cw = (ClassWriter)this.cv;
                        try {
                            data = cw.toByteArray();
                        }
                        catch (Exception ex) {
                            System.err.println(String.format("ASM fail to generate .class file: %s", name));
                            Dex2jar.this.exceptionHandler.handleFileException(ex);
                            return;
                        }
                        try {
                            Path dist1 = dist.resolve(name + ".class");
                            Path parent = dist1.getParent();
                            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                                Files.createDirectories(parent, new FileAttribute[0]);
                            }
                            Files.write(dist1, data, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                };
            }
        };
        new ExDex2Asm(this.exceptionHandler){

            @Override
            public void convertCode(DexMethodNode methodNode, MethodVisitor mv) {
                if ((Dex2jar.this.readerConfig & 4) != 0 && methodNode.method.getName().equals("<clinit>")) {
                    return;
                }
                super.convertCode(methodNode, mv);
            }

            @Override
            public void optimize(IrMethod irMethod) {
                T_cleanLabel.transform(irMethod);
                if (0 != (Dex2jar.this.v3Config & 2)) {
                    // empty if block
                }
                T_deadCode.transform(irMethod);
                T_removeLocal.transform(irMethod);
                T_removeConst.transform(irMethod);
                T_zero.transform(irMethod);
                if (T_npe.transformReportChanged(irMethod)) {
                    T_deadCode.transform(irMethod);
                    T_removeLocal.transform(irMethod);
                    T_removeConst.transform(irMethod);
                }
                T_new.transform(irMethod);
                T_fillArray.transform(irMethod);
                T_agg.transform(irMethod);
                T_voidInvoke.transform(irMethod);
                if (0 != (Dex2jar.this.v3Config & 4)) {
                    int i = 0;
                    for (Stmt p : irMethod.stmts) {
                        if (p.st != Stmt.ST.LABEL) continue;
                        LabelStmt labelStmt = (LabelStmt)p;
                        labelStmt.displayName = "L" + i++;
                    }
                    System.out.println(irMethod);
                }
                T_type.transform(irMethod);
                T_unssa.transform(irMethod);
                T_ir2jRegAssign.transform(irMethod);
                T_trimEx.transform(irMethod);
            }

            @Override
            public void ir2j(IrMethod irMethod, MethodVisitor mv) {
                new IR2JConverter(0 != (8 & Dex2jar.this.v3Config)).convert(irMethod, mv);
            }
        }.convertDex(fileNode, cvf);
    }

    public DexExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public BaseDexFileReader getReader() {
        return this.reader;
    }

    public Dex2jar reUseReg(boolean b) {
        this.v3Config = b ? (this.v3Config |= 1) : (this.v3Config &= 0xFFFFFFFE);
        return this;
    }

    public Dex2jar topoLogicalSort(boolean b) {
        this.v3Config = b ? (this.v3Config |= 2) : (this.v3Config &= 0xFFFFFFFD);
        return this;
    }

    public Dex2jar noCode(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 0x84) : (this.readerConfig &= 0xFFFFFF7B);
        return this;
    }

    public Dex2jar optimizeSynchronized(boolean b) {
        this.v3Config = b ? (this.v3Config |= 8) : (this.v3Config &= 0xFFFFFFF7);
        return this;
    }

    public Dex2jar printIR(boolean b) {
        this.v3Config = b ? (this.v3Config |= 4) : (this.v3Config &= 0xFFFFFFFB);
        return this;
    }

    public Dex2jar reUseReg() {
        this.v3Config |= 1;
        return this;
    }

    public Dex2jar optimizeSynchronized() {
        this.v3Config |= 8;
        return this;
    }

    public Dex2jar printIR() {
        this.v3Config |= 4;
        return this;
    }

    public Dex2jar topoLogicalSort() {
        this.v3Config |= 2;
        return this;
    }

    public void setExceptionHandler(DexExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Dex2jar skipDebug(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 1) : (this.readerConfig &= 0xFFFFFFFE);
        return this;
    }

    public Dex2jar skipDebug() {
        this.readerConfig |= 1;
        return this;
    }

    public void to(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
            this.doTranslate(file);
        } else {
            try (FileSystem fs = Dex2jar.createZip(file);){
                this.doTranslate(fs.getPath("/", new String[0]));
            }
        }
    }

    private static FileSystem createZip(Path output) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        Files.deleteIfExists(output);
        Path parent = output.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
            String s = p.getScheme();
            if (!"jar".equals(s) && !"zip".equalsIgnoreCase(s)) continue;
            return p.newFileSystem(output, env);
        }
        throw new IOException("cant find zipfs support");
    }

    public Dex2jar withExceptionHandler(DexExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }
}

