/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util.zip;

import com.googlecode.d2j.util.zip.ZipConstants;
import com.googlecode.d2j.util.zip.ZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ZipFile
implements AutoCloseable,
ZipConstants {
    static final int GPBF_ENCRYPTED_FLAG = 1;
    static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    static final int GPBF_UTF8_FLAG = 2048;
    static final int GPBF_UNSUPPORTED_MASK = 1;
    private List<ZipEntry> entries;
    private String comment;
    final ByteBuffer raf;

    public ZipFile(ByteBuffer in) throws IOException {
        this.raf = in.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        this.readCentralDir();
    }

    public ZipFile(byte[] data) throws IOException {
        this(ByteBuffer.wrap(data));
    }

    public List<? extends ZipEntry> entries() {
        return this.entries;
    }

    public String getComment() {
        return this.comment;
    }

    public ZipEntry findFirstEntry(String entryName) {
        if (entryName == null) {
            throw new NullPointerException("entryName == null");
        }
        ZipEntry ze = this.findFirstEntry0(entryName);
        if (ze == null) {
            ze = this.findFirstEntry0(entryName + "/");
        }
        return ze;
    }

    private ZipEntry findFirstEntry0(String entryName) {
        for (ZipEntry e : this.entries) {
            if (!e.getName().equals(entryName)) continue;
            return e;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        ByteBuffer is = (ByteBuffer)this.raf.duplicate().order(ByteOrder.LITTLE_ENDIAN).position((int)entry.localHeaderRelOffset);
        ZipFile.skip(is, 6);
        int gpbf = is.getShort() & 0xFFFF;
        ZipFile.skip(is, 18);
        int fileNameLength = is.getShort() & 0xFFFF;
        int extraFieldLength = is.getShort() & 0xFFFF;
        ZipFile.skip(is, fileNameLength + extraFieldLength);
        if (entry.compressionMethod == 0) {
            ByteBuffer buf = (ByteBuffer)is.slice().order(ByteOrder.LITTLE_ENDIAN).limit((int)entry.size);
            return new ByteBufferBackedInputStream(buf);
        }
        ByteBuffer buf = (ByteBuffer)is.slice().order(ByteOrder.LITTLE_ENDIAN).limit((int)entry.compressedSize);
        int bufSize = Math.max(1024, (int)Math.min(entry.getSize(), 65535L));
        return new ZipInflaterInputStream(new ByteBufferBackedInputStream(buf), new Inflater(true), bufSize, entry);
    }

    static void skip(ByteBuffer is, int i) {
        is.position(is.position() + i);
    }

    public int size() {
        return this.entries.size();
    }

    private void readCentralDir() throws IOException {
        ByteBuffer raf;
        block8: {
            raf = this.raf;
            long scanOffset = raf.limit() - 22;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + raf.limit());
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            do {
                raf.position((int)scanOffset);
                if ((long)raf.getInt() == 101010256L) break block8;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }
        int diskNumber = raf.getShort() & 0xFFFF;
        int diskWithCentralDir = raf.getShort() & 0xFFFF;
        int numEntries = raf.getShort() & 0xFFFF;
        int totalNumEntries = raf.getShort() & 0xFFFF;
        ZipFile.skip(raf, 4);
        long centralDirOffset = (long)raf.getInt() & 0xFFFFFFFFL;
        int commentLength = raf.getShort() & 0xFFFF;
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("Spanned archives not supported");
        }
        boolean skipCommentsAndExtra = true;
        if (commentLength > 0) {
            if (skipCommentsAndExtra) {
                ZipFile.skip(raf, commentLength);
            } else {
                byte[] commentBytes = new byte[commentLength];
                raf.get(commentBytes);
                this.comment = new String(commentBytes, 0, commentBytes.length, StandardCharsets.UTF_8);
            }
        }
        ByteBuffer buf = (ByteBuffer)raf.duplicate().order(ByteOrder.LITTLE_ENDIAN).position((int)centralDirOffset);
        this.entries = new ArrayList<ZipEntry>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            ZipEntry newEntry = new ZipEntry(buf, skipCommentsAndExtra);
            if (newEntry.localHeaderRelOffset >= centralDirOffset) continue;
            this.entries.add(newEntry);
        }
    }

    static void throwZipException(String msg, int magic) throws ZipException {
        String hexString = String.format("0x%08x", magic);
        throw new ZipException(msg + " signature not found; was " + hexString);
    }

    @Override
    public void close() throws IOException {
    }

    private static class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(b, off, len);
            return len;
        }
    }

    static class ZipInflaterInputStream
    extends InflaterInputStream {
        private final ZipEntry entry;
        private long bytesRead = 0L;

        public ZipInflaterInputStream(InputStream is, Inflater inf, int bsize, ZipEntry entry) {
            super(is, inf, bsize);
            this.entry = entry;
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int i;
            try {
                i = super.read(buffer, byteOffset, byteCount);
            }
            catch (IOException e) {
                throw new IOException("Error reading data for " + this.entry.getName() + " near offset " + this.bytesRead, e);
            }
            if (i == -1) {
                if (this.entry.size != this.bytesRead) {
                    throw new IOException("Size mismatch on inflated file: " + this.bytesRead + " vs " + this.entry.size);
                }
            } else {
                this.bytesRead += (long)i;
            }
            return i;
        }

        @Override
        public int available() throws IOException {
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }
    }
}

