/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import com.googlecode.d2j.DexConstants;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.util.Utf8Utils;

public class Escape
implements DexConstants {
    static boolean contain(int a, int b) {
        return (a & b) != 0;
    }

    public static String classAcc(int acc) {
        if (acc == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (Escape.contain(acc, 1)) {
            sb.append("ACC_PUBLIC|");
        }
        if (Escape.contain(acc, 2)) {
            sb.append("ACC_PRIVATE|");
        }
        if (Escape.contain(acc, 4)) {
            sb.append("ACC_PROTECTED|");
        }
        if (Escape.contain(acc, 8)) {
            sb.append("ACC_STATIC|");
        }
        if (Escape.contain(acc, 16)) {
            sb.append("ACC_FINAL|");
        }
        if (Escape.contain(acc, 512)) {
            sb.append("ACC_INTERFACE|");
        }
        if (Escape.contain(acc, 1024)) {
            sb.append("ACC_ABSTRACT|");
        }
        if (Escape.contain(acc, 4096)) {
            sb.append("ACC_SYNTHETIC|");
        }
        if (Escape.contain(acc, 8192)) {
            sb.append("ACC_ANNOTATION|");
        }
        if (Escape.contain(acc, 16384)) {
            sb.append("ACC_ENUM|");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String methodAcc(int acc) {
        if (acc == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (Escape.contain(acc, 1)) {
            sb.append("ACC_PUBLIC|");
        }
        if (Escape.contain(acc, 2)) {
            sb.append("ACC_PRIVATE|");
        }
        if (Escape.contain(acc, 4)) {
            sb.append("ACC_PROTECTED|");
        }
        if (Escape.contain(acc, 8)) {
            sb.append("ACC_STATIC|");
        }
        if (Escape.contain(acc, 16)) {
            sb.append("ACC_FINAL|");
        }
        if (Escape.contain(acc, 64)) {
            sb.append("ACC_BRIDGE|");
        }
        if (Escape.contain(acc, 128)) {
            sb.append("ACC_VARARGS|");
        }
        if (Escape.contain(acc, 256)) {
            sb.append("ACC_NATIVE|");
        }
        if (Escape.contain(acc, 1024)) {
            sb.append("ACC_ABSTRACT|");
        }
        if (Escape.contain(acc, 2048)) {
            sb.append("ACC_STRICT|");
        }
        if (Escape.contain(acc, 4096)) {
            sb.append("ACC_SYNTHETIC|");
        }
        if (Escape.contain(acc, 65536)) {
            sb.append("ACC_CONSTRUCTOR|");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String fieldAcc(int acc) {
        if (acc == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (Escape.contain(acc, 1)) {
            sb.append("ACC_PUBLIC|");
        }
        if (Escape.contain(acc, 2)) {
            sb.append("ACC_PRIVATE|");
        }
        if (Escape.contain(acc, 4)) {
            sb.append("ACC_PROTECTED|");
        }
        if (Escape.contain(acc, 8)) {
            sb.append("ACC_STATIC|");
        }
        if (Escape.contain(acc, 16)) {
            sb.append("ACC_FINAL|");
        }
        if (Escape.contain(acc, 64)) {
            sb.append("ACC_VOLATILE|");
        }
        if (Escape.contain(acc, 128)) {
            sb.append("ACC_TRANSIENT|");
        }
        if (Escape.contain(acc, 4096)) {
            sb.append("ACC_SYNTHETIC|");
        }
        if (Escape.contain(acc, 16384)) {
            sb.append("ACC_ENUM|");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String v(Field f) {
        return String.format("new Field(%s,%s,%s)", Escape.v(f.getOwner()), Escape.v(f.getName()), Escape.v(f.getType()));
    }

    public static String v(Method m) {
        return String.format("new Method(%s,%s,%s,%s)", Escape.v(m.getOwner()), Escape.v(m.getName()), Escape.v(m.getParameterTypes()), Escape.v(m.getReturnType()));
    }

    public static String v(String s) {
        if (s == null) {
            return "null";
        }
        return "\"" + Utf8Utils.escapeString(s) + "\"";
    }

    public static String v(DexType t) {
        return "new DexType(" + Escape.v(t.desc) + ")";
    }

    public static String v(int[] vs) {
        StringBuilder sb = new StringBuilder("new int[]{ ");
        boolean first = true;
        for (int obj : vs) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(obj);
        }
        return sb.append("}").toString();
    }

    public static String v(byte[] vs) {
        StringBuilder sb = new StringBuilder("new byte[]{ ");
        boolean first = true;
        for (byte obj : vs) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("(byte)").append(obj);
        }
        return sb.append("}").toString();
    }

    public static String v(String[] vs) {
        if (vs == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("new String[]{ ");
        boolean first = true;
        for (String obj : vs) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(Escape.v(obj));
        }
        return sb.append("}").toString();
    }

    public static String v(Object[] vs) {
        StringBuilder sb = new StringBuilder("new Object[]{ ");
        boolean first = true;
        for (Object obj : vs) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(Escape.v(obj));
        }
        return sb.append("}").toString();
    }

    public static String v(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return Escape.v((String)obj);
        }
        if (obj instanceof DexType) {
            return Escape.v((DexType)obj);
        }
        if (obj instanceof Method) {
            return Escape.v((Method)obj);
        }
        if (obj instanceof Field) {
            return Escape.v((Field)obj);
        }
        if (obj instanceof Integer) {
            return " Integer.valueOf(" + obj + ")";
        }
        if (obj instanceof Long) {
            return "Long.valueOf(" + obj + "L)";
        }
        if (obj instanceof Float) {
            return "Float.valueOf(" + obj + "F)";
        }
        if (obj instanceof Double) {
            return "Double.valueOf(" + obj + "D)";
        }
        if (obj instanceof Short) {
            return "Short.valueOf((short)" + obj + ")";
        }
        if (obj instanceof Byte) {
            return "Byte.valueOf((byte)" + obj + ")";
        }
        if (obj instanceof Character) {
            return "Character.valueOf('" + obj + "')";
        }
        if (obj instanceof Boolean) {
            return "Boolean.valueOf(" + obj + ")";
        }
        if (obj instanceof int[]) {
            StringBuilder sb = new StringBuilder("new int[]{ ");
            boolean first = true;
            for (int i : (int[])obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i);
            }
            return sb.append("}").toString();
        }
        if (obj instanceof short[]) {
            StringBuilder sb = new StringBuilder("new short[]{ ");
            boolean first = true;
            for (short i : (short[])obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("(short)").append(i);
            }
            return sb.append("}").toString();
        }
        if (obj instanceof long[]) {
            StringBuilder sb = new StringBuilder("new long[]{ ");
            boolean first = true;
            for (long i : (long[])obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i).append("L");
            }
            return sb.append("}").toString();
        }
        if (obj instanceof float[]) {
            StringBuilder sb = new StringBuilder("new float[]{ ");
            boolean first = true;
            for (float i : (float[])obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i).append("F");
            }
            return sb.append("}").toString();
        }
        return null;
    }
}

