/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.insn;

import com.googlecode.d2j.dex.writer.CodeWriter;
import com.googlecode.d2j.dex.writer.insn.Label;
import com.googlecode.d2j.dex.writer.insn.OpInsn;
import com.googlecode.d2j.reader.Op;
import java.nio.ByteBuffer;

public class JumpOp
extends OpInsn {
    final int a;
    final int b;
    final Label label;

    public JumpOp(Op op, int a, int b, Label label) {
        super(op);
        switch (op.format) {
            case kFmt31t: 
            case kFmt21t: {
                CodeWriter.checkRegAA(op, "vAA", a);
                break;
            }
            case kFmt22t: {
                CodeWriter.checkRegA(op, "vA", a);
                CodeWriter.checkRegA(op, "vB", b);
                break;
            }
        }
        this.label = label;
        this.a = a;
        this.b = b;
    }

    @Override
    public void write(ByteBuffer out) {
        out.put((byte)this.op.opcode);
        int offset = this.label.offset - this.offset;
        switch (this.op.format) {
            case kFmt10t: {
                CodeWriter.checkContentByte(this.op, "+AA", offset);
                out.put((byte)offset);
                break;
            }
            case kFmt20t: {
                CodeWriter.checkContentShort(this.op, "+AAAA", offset);
                out.put((byte)0).putShort((short)offset);
                break;
            }
            case kFmt30t: {
                out.put((byte)0).putInt(offset);
                break;
            }
            case kFmt31t: {
                out.put((byte)this.a).putInt(offset);
                break;
            }
            case kFmt22t: {
                CodeWriter.checkContentShort(this.op, "+CCCC", offset);
                out.put((byte)(this.a & 0xF | this.b << 4)).putShort((short)offset);
                break;
            }
            case kFmt21t: {
                CodeWriter.checkContentShort(this.op, "+BBBB", offset);
                out.put((byte)this.a).putShort((short)offset);
                break;
            }
            default: {
                throw new RuntimeException("not support");
            }
        }
    }
}

