/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22s
extends Instruction
implements LiteralInstruction,
TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private short litC;

    public Instruction22s(Opcode opcode, byte regA, byte regB, short litC) {
        super(opcode);
        if (regA >= 16 || regB >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        this.regA = regA;
        this.regB = regB;
        this.litC = litC;
    }

    private Instruction22s(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
        this.litC = NumberUtils.decodeShort(buffer, bufferIndex + 2);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regB << 4 | this.regA);
        out.writeShort(this.litC);
    }

    public Format getFormat() {
        return Format.Format22s;
    }

    public int getRegisterA() {
        return this.regA;
    }

    public int getRegisterB() {
        return this.regB;
    }

    public long getLiteral() {
        return this.litC;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22s(opcode, buffer, bufferIndex);
        }
    }
}

