/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction21s
extends Instruction
implements LiteralInstruction,
SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private short litB;

    public Instruction21s(Opcode opcode, short regA, short litB) {
        super(opcode);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
        this.litB = litB;
    }

    private Instruction21s(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = buffer[bufferIndex + 1];
        this.litB = NumberUtils.decodeShort(buffer, bufferIndex + 2);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeShort(this.litB);
    }

    public Format getFormat() {
        return Format.Format21s;
    }

    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    public long getLiteral() {
        return this.litB;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction21s(opcode, buffer, bufferIndex);
        }
    }
}

