/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.DeodexUtil;
import org.jf.dexlib.Code.Format.Instruction35ms;
import org.jf.dexlib.Code.Format.Instruction3rms;
import org.jf.dexlib.Code.OdexedInvokeVirtual;

abstract class InlineMethodResolver {
    public static InlineMethodResolver createInlineMethodResolver(DeodexUtil deodexUtil, int odexVersion) {
        if (odexVersion == 35) {
            return new InlineMethodResolver_version35(deodexUtil);
        }
        if (odexVersion == 36) {
            return new InlineMethodResolver_version36(deodexUtil);
        }
        throw new RuntimeException(String.format("odex version %d is not supported yet", odexVersion));
    }

    private InlineMethodResolver() {
    }

    public abstract DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction var1);

    private static class InlineMethodResolver_version36
    extends InlineMethodResolver {
        private final DeodexUtil.InlineMethod[] inlineMethods;
        private final DeodexUtil.InlineMethod indexOfIMethod;
        private final DeodexUtil.InlineMethod indexOfIIMethod;
        private final DeodexUtil.InlineMethod fastIndexOfMethod;
        private final DeodexUtil.InlineMethod isEmptyMethod;

        public InlineMethodResolver_version36(DeodexUtil deodexUtil) {
            DeodexUtil deodexUtil2 = deodexUtil;
            deodexUtil2.getClass();
            this.indexOfIMethod = new DeodexUtil.InlineMethod(deodexUtil2, 0, "Ljava/lang/String;", "indexOf", "I", "I");
            DeodexUtil deodexUtil3 = deodexUtil;
            deodexUtil3.getClass();
            this.indexOfIIMethod = new DeodexUtil.InlineMethod(deodexUtil3, 0, "Ljava/lang/String;", "indexOf", "II", "I");
            DeodexUtil deodexUtil4 = deodexUtil;
            deodexUtil4.getClass();
            this.fastIndexOfMethod = new DeodexUtil.InlineMethod(deodexUtil4, 1, "Ljava/lang/String;", "fastIndexOf", "II", "I");
            DeodexUtil deodexUtil5 = deodexUtil;
            deodexUtil5.getClass();
            this.isEmptyMethod = new DeodexUtil.InlineMethod(deodexUtil5, 0, "Ljava/lang/String;", "isEmpty", "", "Z");
            DeodexUtil.InlineMethod[] inlineMethodArray = new DeodexUtil.InlineMethod[22];
            DeodexUtil deodexUtil6 = deodexUtil;
            deodexUtil6.getClass();
            inlineMethodArray[0] = new DeodexUtil.InlineMethod(deodexUtil6, 2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V");
            DeodexUtil deodexUtil7 = deodexUtil;
            deodexUtil7.getClass();
            inlineMethodArray[1] = new DeodexUtil.InlineMethod(deodexUtil7, 0, "Ljava/lang/String;", "charAt", "I", "C");
            DeodexUtil deodexUtil8 = deodexUtil;
            deodexUtil8.getClass();
            inlineMethodArray[2] = new DeodexUtil.InlineMethod(deodexUtil8, 0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I");
            DeodexUtil deodexUtil9 = deodexUtil;
            deodexUtil9.getClass();
            inlineMethodArray[3] = new DeodexUtil.InlineMethod(deodexUtil9, 0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z");
            inlineMethodArray[4] = null;
            inlineMethodArray[5] = null;
            DeodexUtil deodexUtil10 = deodexUtil;
            deodexUtil10.getClass();
            inlineMethodArray[6] = new DeodexUtil.InlineMethod(deodexUtil10, 0, "Ljava/lang/String;", "length", "", "I");
            DeodexUtil deodexUtil11 = deodexUtil;
            deodexUtil11.getClass();
            inlineMethodArray[7] = new DeodexUtil.InlineMethod(deodexUtil11, 2, "Ljava/lang/Math;", "abs", "I", "I");
            DeodexUtil deodexUtil12 = deodexUtil;
            deodexUtil12.getClass();
            inlineMethodArray[8] = new DeodexUtil.InlineMethod(deodexUtil12, 2, "Ljava/lang/Math;", "abs", "J", "J");
            DeodexUtil deodexUtil13 = deodexUtil;
            deodexUtil13.getClass();
            inlineMethodArray[9] = new DeodexUtil.InlineMethod(deodexUtil13, 2, "Ljava/lang/Math;", "abs", "F", "F");
            DeodexUtil deodexUtil14 = deodexUtil;
            deodexUtil14.getClass();
            inlineMethodArray[10] = new DeodexUtil.InlineMethod(deodexUtil14, 2, "Ljava/lang/Math;", "abs", "D", "D");
            DeodexUtil deodexUtil15 = deodexUtil;
            deodexUtil15.getClass();
            inlineMethodArray[11] = new DeodexUtil.InlineMethod(deodexUtil15, 2, "Ljava/lang/Math;", "min", "II", "I");
            DeodexUtil deodexUtil16 = deodexUtil;
            deodexUtil16.getClass();
            inlineMethodArray[12] = new DeodexUtil.InlineMethod(deodexUtil16, 2, "Ljava/lang/Math;", "max", "II", "I");
            DeodexUtil deodexUtil17 = deodexUtil;
            deodexUtil17.getClass();
            inlineMethodArray[13] = new DeodexUtil.InlineMethod(deodexUtil17, 2, "Ljava/lang/Math;", "sqrt", "D", "D");
            DeodexUtil deodexUtil18 = deodexUtil;
            deodexUtil18.getClass();
            inlineMethodArray[14] = new DeodexUtil.InlineMethod(deodexUtil18, 2, "Ljava/lang/Math;", "cos", "D", "D");
            DeodexUtil deodexUtil19 = deodexUtil;
            deodexUtil19.getClass();
            inlineMethodArray[15] = new DeodexUtil.InlineMethod(deodexUtil19, 2, "Ljava/lang/Math;", "sin", "D", "D");
            DeodexUtil deodexUtil20 = deodexUtil;
            deodexUtil20.getClass();
            inlineMethodArray[16] = new DeodexUtil.InlineMethod(deodexUtil20, 2, "Ljava/lang/Float;", "floatToIntBits", "F", "I");
            DeodexUtil deodexUtil21 = deodexUtil;
            deodexUtil21.getClass();
            inlineMethodArray[17] = new DeodexUtil.InlineMethod(deodexUtil21, 2, "Ljava/lang/Float;", "floatToRawIntBits", "F", "I");
            DeodexUtil deodexUtil22 = deodexUtil;
            deodexUtil22.getClass();
            inlineMethodArray[18] = new DeodexUtil.InlineMethod(deodexUtil22, 2, "Ljava/lang/Float;", "intBitsToFloat", "I", "F");
            DeodexUtil deodexUtil23 = deodexUtil;
            deodexUtil23.getClass();
            inlineMethodArray[19] = new DeodexUtil.InlineMethod(deodexUtil23, 2, "Ljava/lang/Double;", "doubleToLongBits", "D", "J");
            DeodexUtil deodexUtil24 = deodexUtil;
            deodexUtil24.getClass();
            inlineMethodArray[20] = new DeodexUtil.InlineMethod(deodexUtil24, 2, "Ljava/lang/Double;", "doubleToRawLongBits", "D", "J");
            DeodexUtil deodexUtil25 = deodexUtil;
            deodexUtil25.getClass();
            inlineMethodArray[21] = new DeodexUtil.InlineMethod(deodexUtil25, 2, "Ljava/lang/Double;", "longBitsToDouble", "J", "D");
            this.inlineMethods = inlineMethodArray;
        }

        public DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
            assert (analyzedInstruction.instruction instanceof OdexedInvokeVirtual);
            OdexedInvokeVirtual instruction = (OdexedInvokeVirtual)((Object)analyzedInstruction.instruction);
            int methodIndex = instruction.getMethodIndex();
            if (methodIndex < 0 || methodIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + methodIndex);
            }
            if (methodIndex == 4) {
                int parameterCount = this.getParameterCount(instruction);
                if (parameterCount == 2) {
                    return this.indexOfIMethod;
                }
                if (parameterCount == 3) {
                    return this.fastIndexOfMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            if (methodIndex == 5) {
                int parameterCount = this.getParameterCount(instruction);
                if (parameterCount == 3) {
                    return this.indexOfIIMethod;
                }
                if (parameterCount == 1) {
                    return this.isEmptyMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            return this.inlineMethods[methodIndex];
        }

        private int getParameterCount(OdexedInvokeVirtual instruction) {
            if (instruction instanceof Instruction35ms) {
                return ((Instruction35ms)instruction).getRegCount();
            }
            return ((Instruction3rms)instruction).getRegCount();
        }
    }

    private static class InlineMethodResolver_version35
    extends InlineMethodResolver {
        private final DeodexUtil.InlineMethod[] inlineMethods;

        public InlineMethodResolver_version35(DeodexUtil deodexUtil) {
            DeodexUtil.InlineMethod[] inlineMethodArray = new DeodexUtil.InlineMethod[14];
            DeodexUtil deodexUtil2 = deodexUtil;
            deodexUtil2.getClass();
            inlineMethodArray[0] = new DeodexUtil.InlineMethod(deodexUtil2, 2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V");
            DeodexUtil deodexUtil3 = deodexUtil;
            deodexUtil3.getClass();
            inlineMethodArray[1] = new DeodexUtil.InlineMethod(deodexUtil3, 0, "Ljava/lang/String;", "charAt", "I", "C");
            DeodexUtil deodexUtil4 = deodexUtil;
            deodexUtil4.getClass();
            inlineMethodArray[2] = new DeodexUtil.InlineMethod(deodexUtil4, 0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I");
            DeodexUtil deodexUtil5 = deodexUtil;
            deodexUtil5.getClass();
            inlineMethodArray[3] = new DeodexUtil.InlineMethod(deodexUtil5, 0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z");
            DeodexUtil deodexUtil6 = deodexUtil;
            deodexUtil6.getClass();
            inlineMethodArray[4] = new DeodexUtil.InlineMethod(deodexUtil6, 0, "Ljava/lang/String;", "length", "", "I");
            DeodexUtil deodexUtil7 = deodexUtil;
            deodexUtil7.getClass();
            inlineMethodArray[5] = new DeodexUtil.InlineMethod(deodexUtil7, 2, "Ljava/lang/Math;", "abs", "I", "I");
            DeodexUtil deodexUtil8 = deodexUtil;
            deodexUtil8.getClass();
            inlineMethodArray[6] = new DeodexUtil.InlineMethod(deodexUtil8, 2, "Ljava/lang/Math;", "abs", "J", "J");
            DeodexUtil deodexUtil9 = deodexUtil;
            deodexUtil9.getClass();
            inlineMethodArray[7] = new DeodexUtil.InlineMethod(deodexUtil9, 2, "Ljava/lang/Math;", "abs", "F", "F");
            DeodexUtil deodexUtil10 = deodexUtil;
            deodexUtil10.getClass();
            inlineMethodArray[8] = new DeodexUtil.InlineMethod(deodexUtil10, 2, "Ljava/lang/Math;", "abs", "D", "D");
            DeodexUtil deodexUtil11 = deodexUtil;
            deodexUtil11.getClass();
            inlineMethodArray[9] = new DeodexUtil.InlineMethod(deodexUtil11, 2, "Ljava/lang/Math;", "min", "II", "I");
            DeodexUtil deodexUtil12 = deodexUtil;
            deodexUtil12.getClass();
            inlineMethodArray[10] = new DeodexUtil.InlineMethod(deodexUtil12, 2, "Ljava/lang/Math;", "max", "II", "I");
            DeodexUtil deodexUtil13 = deodexUtil;
            deodexUtil13.getClass();
            inlineMethodArray[11] = new DeodexUtil.InlineMethod(deodexUtil13, 2, "Ljava/lang/Math;", "sqrt", "D", "D");
            DeodexUtil deodexUtil14 = deodexUtil;
            deodexUtil14.getClass();
            inlineMethodArray[12] = new DeodexUtil.InlineMethod(deodexUtil14, 2, "Ljava/lang/Math;", "cos", "D", "D");
            DeodexUtil deodexUtil15 = deodexUtil;
            deodexUtil15.getClass();
            inlineMethodArray[13] = new DeodexUtil.InlineMethod(deodexUtil15, 2, "Ljava/lang/Math;", "sin", "D", "D");
            this.inlineMethods = inlineMethodArray;
        }

        public DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
            assert (analyzedInstruction.instruction instanceof OdexedInvokeVirtual);
            OdexedInvokeVirtual instruction = (OdexedInvokeVirtual)((Object)analyzedInstruction);
            int methodIndex = instruction.getMethodIndex();
            if (methodIndex < 0 || methodIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + methodIndex);
            }
            return this.inlineMethods[methodIndex];
        }
    }
}

