/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Renderers;

import java.io.IOException;
import org.jf.util.IndentingWriter;

public class LongRenderer {
    public static void writeTo(IndentingWriter writer, long val) throws IOException {
        if (val < 0L) {
            writer.write("-0x");
            writer.printLongAsHex(-val);
            writer.write(76);
        } else {
            writer.write("0x");
            writer.printLongAsHex(val);
            writer.write(76);
        }
    }

    public static void writeSignedIntOrLongTo(IndentingWriter writer, long val) throws IOException {
        if (val < 0L) {
            writer.write("-0x");
            writer.printLongAsHex(-val);
            if (val < Integer.MIN_VALUE) {
                writer.write(76);
            }
        } else {
            writer.write("0x");
            writer.printLongAsHex(val);
            if (val > Integer.MAX_VALUE) {
                writer.write(76);
            }
        }
    }
}

