/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.mod.SmaliMod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.antlr.runtime.RecognitionException;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;

public class DexFileBuilder {
    private final DexFile mDexFile = new DexFile();

    public void addSmaliFile(File smaliFile) throws AndrolibException {
        try {
            this.addSmaliFile(new FileInputStream(smaliFile), smaliFile.getAbsolutePath());
        }
        catch (FileNotFoundException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void addSmaliFile(InputStream smaliStream, String name) throws AndrolibException {
        try {
            if (!SmaliMod.assembleSmaliFile(smaliStream, name, this.mDexFile, false, false, false)) {
                throw new AndrolibException("Could not smali file: " + smaliStream);
            }
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (RecognitionException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void writeTo(File dexFile) throws AndrolibException {
        try {
            FileOutputStream out = new FileOutputStream(dexFile);
            ((OutputStream)out).write(this.getAsByteArray());
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not write dex to file: " + dexFile, ex);
        }
    }

    public byte[] getAsByteArray() {
        this.mDexFile.place();
        for (CodeItem codeItem : this.mDexFile.CodeItemsSection.getItems()) {
            codeItem.fixInstructions(true, true);
        }
        this.mDexFile.place();
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
        this.mDexFile.writeTo(out);
        byte[] bytes = out.toByteArray();
        DexFile.calcSignature(bytes);
        DexFile.calcChecksum(bytes);
        return bytes;
    }
}

