/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import java.util.LinkedHashSet;
import java.util.Set;

public class ResValuesFile {
    private final ResPackage mPackage;
    private final ResType mType;
    private final ResConfig mConfig;
    private final Set<ResResource> mResources = new LinkedHashSet<ResResource>();

    public ResValuesFile(ResPackage pkg, ResType type, ResConfig config) {
        this.mPackage = pkg;
        this.mType = type;
        this.mConfig = config;
    }

    public String getPath() {
        return "values" + this.mConfig.getFlags().getQualifiers() + "/" + this.mType.getName() + (this.mType.getName().endsWith("s") ? "" : "s") + ".xml";
    }

    public Set<ResResource> listResources() {
        return this.mResources;
    }

    public boolean isSynthesized(ResResource res) {
        return this.mPackage.isSynthesized(res.getResSpec().getId());
    }

    public void addResource(ResResource res) {
        this.mResources.add(res);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResValuesFile other = (ResValuesFile)obj;
        if (!(this.mType == other.mType || this.mType != null && this.mType.equals(other.mType))) {
            return false;
        }
        return this.mConfig == other.mConfig || this.mConfig != null && this.mConfig.equals(other.mConfig);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.mType != null ? this.mType.hashCode() : 0);
        hash = 37 * hash + (this.mConfig != null ? this.mConfig.hashCode() : 0);
        return hash;
    }
}

