<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */
 

class Db{
    protected $mysqli;

    //数据库类初始化
    public function __construct(){
        $this->mysqli = new mysqli(DB_HOST, DB_USER, DB_PWD, DB_NAME);

        if(mysqli_connect_errno()){
            echo "连接失败， 原因:".mysqli_connect_error();
            exit();
        }

        $this->mysqli->set_charset("utf8");
    }

    /*
    * $query 查询的语句，所有语句都经过绑定，防止SQL注入
    * $method 是方法名,不同方法名将返回不同结果
    * $data 是需要查询的数据
    */
    protected function query($query, $method, $data=array()){
        $this->setnull();
        $value = $this->excape_string_array($data);
        if($this->mysqli)
            $stmt = $this->mysqli->prepare($query);
        else
            return;

        if(count($value) > 0){ 
            $s = str_repeat('s', count($value));
            array_unshift($value, $s);
            call_user_func_array(array($stmt, 'bind_param'), $this->revalues($value));
        }

        if($stmt){
            $reslut = $stmt->execute();
        }

        $return = null;
        switch ($method) {
            case 'all':
                $stmt->store_result();
                $data = $this->getall($stmt);
                $return=$data;
                break;
            case 'one':
                $stmt->store_result();
                if($stmt->num_rows > 0){
                    $data = $this->getone($stmt); 
                    $return=$data;
                }else{
                    $return=false;
                }
                break;
            case 'total':
                $stmt->store_result();
                $row = $this->getone($stmt);
                $return=$row["count"];
                break;
            case 'add':
                if($this->mysqli->insert_id)
                    $return = $this->mysqli->insert_id;
                else
                    $return = false;
                break;
            case 'mod':
            case 'del':
                $return = $stmt->affected_rows;
                break;
            default:
                $return = $result;
                break;
        }

        return $return;

    }

    /*
    * $array 是用户输入需要经过处理再返回
    */
    protected function excape_string_array($array){
        if(empty($array))
            return array();

        $value = array();
        foreach($array as $val){
            $value[]=str_replace(array('"', "'"), '', $val);
        }
        return $value;
    }

    /*
    * $stmt 是mysqli绑定查询将返回所有数据
    */
    protected function getall($stmt){
        $result = array();
        $filed = $stmt->result_metadata()->fetch_fields();
        $out = array();
        $fileds = array();
        foreach($filed as $val){
            $fileds[] = &$out[$val->name];
        }
        call_user_func_array(array($stmt, 'bind_result'), $fileds);
        while($stmt->fetch()){
            $t = array();
            foreach($out as $key => $val){
                $t[$key] = $val;
            }
            $result[] = $t;
        }

        return $result;
    }

    /*
    * $stmt 是mysqli绑定查询将返回一条数据
    */
    protected function getone($stmt){
        $result = array();
        $filed = $stmt->result_metadata()->fetch_fields();
        $out = array();
        $fileds = array();
        foreach($filed as $val){
            $fileds[] = &$out[$val->name];
        }

        call_user_func_array(array($stmt, 'bind_result'), $fileds);
        $stmt->fetch();

        foreach ($out as $key => $val) {
            $result[$key] = $val;
        }
        return $result;
    }

    /*
    * 检测PHP版本
    */
    private function revalues($arr){
        if(version_compare(PHP_VERSION, '5.3.0') >= 0){
            $refs = array();
            foreach($arr as $key => $val)
                $refs[$key] = &$arr[$key];
                return $refs;
            }
                return $arr;
        }
   
    //统计数据库大小
    public function dbsize(){
        $query="SHOW TABLE STATUS FROM ".DB_NAME;
        if(@$tabfix !=null){
            $query .="LIKE '".TAB_FIX."%'";
        }
        $result=$this->mysqli->query($query);
        $size=0;
        while($row=$result->fetch_assoc())
            $size +=$row["Data_length"] + $row["Index_length"];
        return val::countsize($size);
    }
    //关闭数据库
    public function close(){
        if($this->mysqli){
            $this->mysqli->close();
            $this->mysqli=false;
        }
    
    }
    //销毁资源
    public function __destruct(){
        $this->close();
    }


}

?>
