DROP TABLE IF EXISTS zh_flink;
CREATE TABLE zh_flink (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  webname varchar(30) NOT NULL DEFAULT '' COMMENT '网站名称',
  user varchar(30) NOT NULL DEFAULT '' COMMENT '站长名字',
  phone varchar(35) NOT NULL DEFAULT '' COMMENT '联系方式',
  weburl varchar(100) NOT NULL DEFAULT '' COMMENT '网站地址',
  commt tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  info varchar(100) NOT NULL DEFAULT '' COMMENT '网站描述',
  ord smallint(3) NOT NULL DEFAULT '0' COMMENT '排序',
  addtime int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_adver;
CREATE TABLE zh_adver (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  name varchar(30) NOT NULL DEFAULT '' COMMENT '英文名称',
  tit varchar(30) NOT NULL DEFAULT '' COMMENT '中文名称',
  position char(40) NOT NULL DEFAULT '' COMMENT '广告位置',
  code varchar(300) NOT NULL DEFAULT '' COMMENT '代码',
  state tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  posttime int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_article;
CREATE TABLE zh_article (
  id int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  title varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  pid mediumint(8) unsigned NOT NULL COMMENT '所属栏目',
  thumb varchar(200) NOT NULL DEFAULT '' COMMENT '缩略图',
  keyword varchar(150) NOT NULL DEFAULT '' COMMENT '关键词',
  source varchar(30) NOT NULL DEFAULT '' COMMENT '文章来源',
  author varchar(20) NOT NULL DEFAULT '' COMMENT '作者',
  paly varchar(200) NOT NULL DEFAULT '' COMMENT '大图轮播',
  info varchar(250) NOT NULL DEFAULT '' COMMENT '内容摘要',
  content text NOT NULL COMMENT '文章内容',
  attr varchar(30) NOT NULL DEFAULT '' COMMENT '属性',
  commend tinyint(1) NOT NULL DEFAULT '1' COMMENT '评论',
  count smallint(6) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  views smallint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  nums smallint(5) NOT NULL DEFAULT '0' COMMENT '留言数量',
  posttime int(10) NOT NULL DEFAULT '0' COMMENT '发布时间',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_user;
CREATE TABLE zh_user (
  id int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  gid smallint(4) unsigned NOT NULL COMMENT '所属分组',
  user varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  passwd char(40) NOT NULL DEFAULT '' COMMENT '密码',
  email varchar(60) NOT NULL DEFAULT '' COMMENT '邮箱',
  regtime int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  disable smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '显示或隐藏',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_group;
CREATE TABLE zh_group (
  id smallint(4) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  groname varchar(20) NOT NULL DEFAULT '' COMMENT '用户组名',
  info varchar(200) NOT NULL DEFAULT '' COMMENT '组描述',
  login tinyint(1) NOT NULL DEFAULT '0' COMMENT '后台登陆',
  gro tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户管理',
  main tinyint(1) NOT NULL DEFAULT '0' COMMENT '基本设置',
  nav tinyint(1) NOT NULL DEFAULT '0' COMMENT '栏目管理',
  article tinyint(1) NOT NULL DEFAULT '0' COMMENT '文章管理',
  cent tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户投稿',
  adver tinyint(1) NOT NULL DEFAULT '0' COMMENT '广告管理',
  link tinyint(1) NOT NULL DEFAULT '0' COMMENT '友情链接',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_nav;
CREATE TABLE zh_nav (
  id smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  pid smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '父栏目',
  path varchar(100) NOT NULL DEFAULT '' COMMENT '父栏目路径',
  title varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  description varchar(100) NOT NULL DEFAULT '' COMMENT '描述',
  ord smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '栏目排序',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_set;
CREATE TABLE zh_set (
  id smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  webname varchar(100) NOT NULL DEFAULT '' COMMENT '网站名称',
  width smallint(5) NOT NULL DEFAULT '0' COMMENT '缩略图高度',
  height smallint(5) NOT NULL DEFAULT '0' COMMENT '缩略图宽度',
  notice varchar(100) NOT NULL DEFAULT '' COMMENT '首页公告',
  qq char(20) NOT NULL DEFAULT '' COMMENT '站长QQ',
  email varchar(100) NOT NULL DEFAULT '' COMMENT '邮箱',
  word varchar(300) NOT NULL DEFAULT '' COMMENT '字符过滤',
  commt smallint(3) NOT NULL DEFAULT '0' COMMENT '评论设置',
  size smallint(3) NOT NULL DEFAULT '0' COMMENT '每页显示数量',
  keyword varchar(300) NOT NULL DEFAULT '' COMMENT '网站关键词',
  description varchar(500) NOT NULL DEFAULT '' COMMENT '网站描述',
  statcode varchar(200) NOT NULL DEFAULT '' COMMENT '流量统计',
  copyright varchar(200) NOT NULL DEFAULT '' COMMENT '版权信息',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS zh_book;
CREATE TABLE zh_book (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  aid mediumint(8) unsigned NOT NULL COMMENT '文章ID',
  name varchar(30) NOT NULL DEFAULT '' COMMENT '留言名称',
  email varchar(100) NOT NULL DEFAULT '' COMMENT '留言邮箱',
  cont varchar(300) NOT NULL DEFAULT '' COMMENT '留言内容',
  state tinyint(1) NOT NULL DEFAULT '0' COMMENT '留言状态',
  cmt smallint(5) NOT NULL DEFAULT '0' COMMENT '赞成',
  ip varchar(30) NOT NULL DEFAULT '' COMMENT 'IP',
  ptime int(10) NOT NULL DEFAULT '0' COMMENT '留言时间',
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;











INSERT INTO zh_set (id, webname, width, height, notice, qq, email, word, commt, size, keyword, description, statcode, copyright) VALUES
(null, '中环工作室CMS', 650, 400, '中环CMS2.0发布啦，欢迎大家到 www.ps173.com 下载，或你在使用过程中遇到问题也可以给我留言。', '9118847', 'ghmax@qq.com', '法轮功|骂', 1, 10, '中环工作室', 'PHP,CMS,中环工作室', ' ', '中环工作室');

INSERT INTO zh_group (id, groname, info, login, gro, main, nav, article, cent, adver, link) VALUES
(null, '超级管理员', '该组用户拥有全部权限，并且不能删除。否则Admin将不能登陆后台！', 1, 1, 1, 1, 1, 1, 1, 1),
(null, '注册用户', '该用户默认只有投稿功能！', 0, 0, 0, 0, 0, 1, 0, 0);

INSERT INTO zh_adver (id, name, tit, position, code, state, posttime) VALUES
(null, 'top_text', '顶部文字', 'top_text', '500 X 22 的文字广告', 0, 1433564138),
(null, 'top_img', '顶部图片', 'head_img', '690 X 70 的图片广告', 0, 1433564159),
(null, 'right_menu', '右侧菜单', 'right_menu', '270 X 190 的图片广告', 0, 1433564182),
(null, 'cent_bott', '文章底部', 'cent_bott', '730 X 90 的广告位置', 0, 1433564196);
