<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */
 
//用户注册和登陆类

class LoginAction extends CommonAction{

	public function index(){
		$this->caching=0; 
		if(isset($_SESSION['user'])){
			$this->msg('尊敬的会员 '.$_SESSION['user'].' 您已经登陆了');
		}

		$this->assign("flink", $this->viewflink());
		$this->assign("adver", $this->viewadver());
		$this->assign("list", $this->nav->menu());
		$this->assign("info", $this->info());
		$this->display();
	}

	public function check($post){
		$rs = true;

		if(!val::check($post['password1'])){
			$this->msg('确认密码不能为空');
			$rs = false;
		}

		if($post['password'] != $post['password1']){
			$this->msg('输入的两次密码不一致');
			$rs = false;
		}
			
		if(val::length($post['username'], 10, 'max')){
			$this->msg('用户名长度不能超过10位');
			$rs =false;
		}else{
			if(val::length($post['username'], 3, 'min')){
				$this->msg('用户名不能少于3位');
				$rs = false;
			}
		}

		if(val::length($post['password'], 16, 'max')){
			$this->msg('密码不能超过16位');
			$rs = false;
		}else{
			if(val::length($post['password'], 6, 'min')){
				$this->msg('密码不能少于6位');
				$rs = false;
			}
		}

		if(!val::checkemail($post['email'])){
			$this->msg('电子邮箱不正确');
			$rs = false;
		}

		return $rs;
	}

	public function logout(){
		$this->caching=0; 
		$this->user->logout();
		$this->msg('退出成功');
	}

	public function password(){
		$this->caching=0; 
		if(isset($_SESSION['user'])){
			if(isset($_POST['sub'])){
				if($this->checkpwd($_POST)){
					$data['user'] = $_SESSION['user'];
					$data['passwd'] = $_POST['passwd'];
					$result = $this->user->checkpwd($data);
					unset($data);
					if(!$result){
						$this->msg('旧密码不正确');
					}else{
						$post['id'] = $result['id'];
						$post['passwd'] = $_POST['newpasswd'];
						$res = $this->user->changuser($post);
						if(!empty($res)){
							$this->msg('密码修改成功');
						}else{
							$this->msg('密码修改失败');
						}
					}

				}
			}
		}else{
			$this->msg('非法操作，请先登陆再操作');
		}	

		$this->assign("flink", $this->viewflink());
		$this->assign("adver", $this->viewadver());
		$this->assign("list", $this->nav->menu());
		$this->assign("info", $this->info());
		$this->display();
	}

		//检测数据是否合法
	public function checklogin($post){
		$this->caching=0; 
		$rs = true;
		if(!preg_match('/^\S+$/i', $post['user'])){
			$this->msg("用户名不能为空!");
			$rs = false;
		}

		if(!preg_match('/^\S+$/i', $post['passwd'])){
			$this->msg("密码不能为空!");
			$rs = false;
		}

		return $rs;
	}

	public function login(){
		$this->caching=0; 
		if(isset($_POST['sub'])){
			if($this->checklogin($_POST)){
				$result = $this->user->userlogin($_POST['user'], $_POST['passwd']);
				if(!$result){
					$this->msg('用户名或密码错误，请重新输入');
				}else if($result == 2){
					$this->msg('尊敬的会员 '.$_POST['user'].' 欢迎您回来');
				}else{
					$this->msg('抱歉，该账号已被禁止使用！');
				}
			}

		}
	}

		//检测用户是否存在
	public function checkname($name){
		$this->caching=0; 
		if($this->user->checkuser($name)){
			$this->msg('该用户名已存在，请重新输入');
			return false;
		}
		return $name;
	}

	public function reguser(){
		$this->caching=0; 
		if(isset($_POST['sub'])){
			if(strtoupper($_POST['code']) == $_SESSION['code']){
				if($this->check($_POST)){
					if($this->checkname($_POST['username'])){
						if($this->user->adduser($_POST)){
							$this->msg('恭喜您，注册成功！');
						}else{
							$this->msg('很愦憾，注册失败！');
						}
					}
				}
			}else{
				$this->msg('验证码不正确');
			}	
		}
	}

	public function checkuser(){
		$this->caching=0; 
		if($this->user->check_total(array("user"=>$_GET['username'])) > 0){
			echo "false";
		}else{
			echo "true";
		}

	}

	public function code(){
		$this->caching=0; 
		echo new Vcode();
	}
}

?>