<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//文章输出
class ArticleAction extends CommonAction{

		//检测数据是否合法
	public function check($post){
		$rs = true;
		
		if($post['pid'] == 0 ){
			$this->msg('栏目不能为空');
			$rs = false;
		}

		if(!val::check($post['title'])){
			$this->msg('标题不能为空');
			$rs = false;
		}

		if(val::length($post['title'], 30, 'max')){
			$this->msg('标题不能超过30个字');
			$rs = false;
		}

		if(val::length($post['info'], 300, 'max')){
			$this->msg('内容摘要不能超过300个字');
			$rs = false;
		}

		if(!val::check($post['content'])){
			$this->msg('文章内容不能为空');
			$rs = false;
		}

		return $rs;
	}

	//显示文章内容
	public function index(){
		if(!$this->isCached(null, $_SERVER["REQUEST_URI"])){
			if(isset($_GET['id'])){
				$id = intval($_GET['id']);
				unset($_GET['id']);
			}
		
			$content= $this->getcontent($id);
			$content['content'] = val::unhtml($content['content']);
			$this->assign('location', $this->nav->colsmenu($content['pid']));
			$this->assign("hostpid", $this->article->hostpid($content['pid']));
			$this->assign("books", $this->article->art_list("id, title, posttime", 16, array('pid'=>$content['pid'], "views"=>0), "nums desc"));
			$this->assign("reclist", $this->article->art_list("id, title, posttime", 16, array('pid'=>$content['pid'], 'attr'=>"%推荐%", "views"=>0)));
			$this->assign('content', $content);
			$this->assign("info", $this->info());
			$this->assign("list", $this->nav->menu());
			$this->assign("flink", $this->viewflink());
		}

		$this->assign("adver", $this->viewadver());
		$this->article->setcount($id);
		$this->assign('cmt', $this->book->getcmt($id));
		$this->assign("ip", val::clientip());

		$this->display(null, $_SERVER["REQUEST_URI"]);
	}

	//获取文章
	private function getcontent($id){
		if(isset($id)){
			$data = array();
			$data = $this->article->viewcent($id);
			if(!$data)
				$this->msg('该文章不存在，或者未通过审核！', 'close');
		}else{
			$this->msg('非法操作！');
		}

		return $data;
	}

	//发布投搞
	public function insert(){
		$this->caching=0; 
		if(isset($_POST['sub'])){
			if(strtoupper($_POST['code']) == $_SESSION['code']){
				if($this->check($_POST)){
						$_POST['commend'] = 1;
						$_POST['views'] = 1;
					if($this->article->insert($_POST)){
						$this->msg('文章发布成功，请等待管理员审核');
					}else{
						$this->msg('文章发布失败');
					}
				}
			}else{
				$this->msg('验证码不正确');
			}
		}
	}

	//上传图片
	public function upload(){
		$this->caching=0; 
		if(isset($_FILES['imgFile'])){
			return $this->article->upload($_FILES['imgFile']);
		}else{
			$this->msg('上传失败！');
		}
	}

	//添加文章
	public function add(){
		$this->caching=0; 
		if(!$_SESSION['user']){
			$this->msg('非法操作，请先登陆再进行此操作！');
		}

		$this->assign("select", $this->nav->select($root= "请选择栏目"));
	    $this->assign("editor", val::editor("content", "", 2));
		$this->assign("list", $this->nav->menu());
		$this->assign("flink", $this->viewflink());
		$this->assign("adver", $this->viewadver());
		$this->assign("info", $this->info());
		$this->display();
	}

	//输出验证码
	public function code(){
		$this->caching=0; 
		echo new Vcode();
	}


}

?>