<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

class CommonAction extends Action{

	public function init(){
		if(!file_exists(ZH_PATH."Public/install_lock")){
			header("Location:../install/index.php");
		}
		
		if(!(isset($_SESSION['is_login']) && $_SESSION['is_login'] === 1)){
			$this->jump("login/index");
		}

		if($this->manage($_GET['m'], array("Index", "index"), $_SESSION['login'])){
			$this->msg('权限不足，你的账号无法登陆后台');
		}

		if($this->manage($_GET['m'], array("set"), $_SESSION['main'])){
			$this->msg('权限不足，你不能对基本设置进行操作');
		}

		if($this->manage($_GET['m'], array("group", "user"), $_SESSION['gro'])){
			$this->msg('权限不足，你不能对用户管理进行操作');
		}

		if($this->manage($_GET['m'], array("nav"), $_SESSION['nav'])){
			$this->msg('权限不足，你不能对栏目进行操作');
		}

		if($this->manage($_GET['m'], array("article"), $_SESSION['article'])){
			$this->msg('权限不足，你不能对文章进行操作');
		}

		if($this->manage($_GET['m'], array("adver"), $_SESSION['adver'])){
			$this->msg('权限不足，你不能对广告进行操作');
		}

		if($this->manage($_GET['m'], array("flink"), $_SESSION['link'])){
			$this->msg('权限不足，你不能对友情链接进行操作');
		}

	}
		//检测用户是否合法
	public function check($post){
		$rs = true;
		if(!preg_match('/^\S+$/i', $post['user'])){
			$this->msg("用户名不能为空!");
			$rs = false;
		}

		if(!preg_match('/^\S+$/i', $post['passwd'])){
			$this->msg("密码不能为空!");
			$rs = false;
		}

		return $rs;

	}
		//检测密码是否合法
	public function checkpwd($post){
		$rs = true;

		if(!val::check($post['passwd'])){
			$this->msg('旧密码不能为空');
			$rs = false;
		}

		if(!val::check($post['newpasswd'])){
			$this->msg('确认密码不能为空');
			$rs = false;
		}

		if($post['newpasswd'] != $post['new2passwd']){
			$this->msg('输入的两次密码不一致');
			$rs = false;
		}

		if(val::length($post['newpasswd'], 16, 'max')){
			$this->msg('新密码不能超过16位');
			$rs = false;
		}else{
			if(val::length($post['newpasswd'], 6, 'min')){
				$this->msg('新密码不能少于6位');
				$rs = false;
			}
		}

		return $rs;
	}
		//检测修改用户密码是否合法
	public function checkuser($post){
		$rs = true;

		if($this->check($post)){
			if(!val::check($post['newpasswd'])){
				$this->msg('确认密码不能为空');
				$rs = false;
			}

			if($post['passwd'] != $post['newpasswd']){
				$this->msg('输入的两次密码不一致');
				$rs = false;
			}
			
		}

		if(val::length($post['user'], 8, 'max')){
			$this->msg('用户名长度不能超过8位');
			$rs =false;
		}else{
			if(val::length($post['user'], 3, 'min')){
				$this->msg('用户名不能少于3位');
				$rs = false;
			}
		}

		if(val::length($post['passwd'], 16, 'max')){
			$this->msg('密码不能超过16位');
			$rs = false;
		}else{
			if(val::length($post['passwd'], 6, 'min')){
				$this->msg('密码不能少于6位');
				$rs = false;
			}
		}

		if(!val::checkemail($post['email'])){
			$this->msg('电子邮箱不正确');
			$rs = false;
		}

		return $rs;
	}
		//检测修改分组是否合法
	public function checkmod($post){
		if(empty($post['gid'])){
			$this->msg('用户所属分组不能为空！');
		}

		if(!val::check($post['email'])){
			$this->msg('电子邮箱不能为空');
		}

		if(!val::checkemail($post['email'])){
			$this->msg('电子邮箱不正确');
		}

		return $post;
	}



}

?>