;=== DEFiNE
!define REG    `${SET}\${APP}.reg`
!define DEFREG `${DEFDATA}\settings\${APP}.reg`
;===
!define EXE    `${APPDIR}\${APP}.exe`
!define SENDTO `$SENDTO\${APP}.lnk`
;===
!define YDS    `${SET}\scripts0.yds`
!define DEFYDS `${DEFDATA}\settings\scripts0.yds`
;===
!define BRANCH `Software\GreenTree Applications\YTD`
!define LANG   `HKEY_CURRENT_USER\${BRANCH}`
!define KEY    Language
!define MRU    MruDir1
!define DWN    DownloadDirectory
!define CON    ConvertDirectory
;===
!define YTD    `$0\YTD Video Downloader`
!define VID    `${DATA}\My Downloaded Videos`
;===
!define FP     `$APPDATA\Adobe\Flash Player`
!define ASS    `${FP}\AssetCache`
!define OBJ    `$APPDATA\Macromedia\Flash Player\#SharedObjects`
!define SOL1   `$APPDATA\Macromedia\Flash Player\macromedia.com\support\flashplayer\sys\settings.sol`
!define SOL2   `$APPDATA\Macromedia\Flash Player\macromedia.com\support\flashplayer\sys\#s.ytimg.com\settings.sol`
!define SOL3   `$APPDATA\Macromedia\Flash Player\macromedia.com\support\flashplayer\sys\s.ytimg.com\settings.sol`
!define AIR    `$APPDATA\Macromedia\Flash Player\#Security\FlashPlayerTrust\air.1.0.trust.cfg`
;===
!define PFM    `$0\PortableApps.com\PortableAppsPlatform.exe`
;===
!define DEFSAVE "!insertmacro _DEFSAVE"
!macro _DEFSAVE _FILE _ROOT _KEY _ENTRY _PATH
	Push $0
	ClearErrors
	${ConfigReads} `${_FILE}` '"${_ENTRY}"=' $0
	IfErrors +2
	StrCmp $0 `""` 0 +2
	WriteRegStr ${_ROOT} `${_KEY}` `${_ENTRY}` `${_PATH}`
	Pop $0
!macroend
!define BackupAiR "!insertmacro _BackupAiR"
!macro _BackupAiR _SEC _DLL
	IfFileExists `${_DLL}` 0 +3
	${WriteRuntimeData} ${PAL} ${_SEC} 1
!macroend
!define RestoreAiR "!insertmacro _RestoreAiR"
!macro _RestoreAiR _SEC _DLL
	ClearErrors
	${ReadRuntimeData} $0 ${PAL} ${_SEC}
	IfErrors 0 +2
	Delete `${_DLL}`
!macroend
!define DEFVAR "!insertmacro _DEFVAR"
!macro _DEFVAR _ENTRY _VAR
	Push $0
	ClearErrors
	${ReadSettings} $0 ${_ENTRY}
	IfErrors +2
	StrCmp $0 "" 0 +2
	StrCpy $0 ${_VAR}
	${SetEnvironmentVariablesPath} ${_ENTRY} `$0`
	Pop $0
!macroend
Function GetLCID
	!macro _GetLCID _LNG _LCID
		Push ${_LNG}
		Call GetLCID
		Pop ${_LCID}
	!macroend
	!define GetLCID `!insertmacro _GetLCID`
	Exch $0
	StrCmp $0 1052 EndLCID
	StrCmp $0 1025 EndLCID
	StrCmp $0 1059 EndLCID
	StrCmp $0 1026 EndLCID
	StrCmp $0 1050 EndLCID
	StrCmp $0 1029 EndLCID
	StrCmp $0 1030 EndLCID
	StrCmp $0 1043 EndLCID
	StrCmp $0 1033 EndLCID
	StrCmp $0 1061 EndLCID
	StrCmp $0 1035 EndLCID
	StrCmp $0 1036 EndLCID
	StrCmp $0 1031 EndLCID
	StrCmp $0 1032 EndLCID
	StrCmp $0 1038 EndLCID
	StrCmp $0 1040 EndLCID
	StrCmp $0 9999 EndLCID
	StrCmp $0 1044 EndLCID
	StrCmp $0 1045 EndLCID
	StrCmp $0 2070 EndLCID
	StrCmp $0 1048 EndLCID
	StrCmp $0 1049 EndLCID
	StrCmp $0 3098 EndLCID
	StrCmp $0 2052 EndLCID
	StrCmp $0 1051 EndLCID
	StrCmp $0 1060 EndLCID
	StrCmp $0 1034 EndLCID
	StrCmp $0 1053 EndLCID
	StrCmp $0 1055 EndLCID
	StrCpy $0 1033
	EndLCID:
	Exch $0
FunctionEnd
Function validateLCID
	!macro _validateLCID _LCID _RETURN
		Push ${_LCID}
		Call validateLCID
		Pop ${_RETURN}
	!macroend
	!define validateLCID `!insertmacro _validateLCID`
	Exch $0
	StrCmp $0 1052 END
	StrCmp $0 1025 END
	StrCmp $0 1059 END
	StrCmp $0 1026 END
	StrCmp $0 1050 END
	StrCmp $0 1029 END
	StrCmp $0 1030 END
	StrCmp $0 1043 END
	StrCmp $0 1033 END
	StrCmp $0 1061 END
	StrCmp $0 1035 END
	StrCmp $0 1036 END
	StrCmp $0 1031 END
	StrCmp $0 1032 END
	StrCmp $0 1038 END
	StrCmp $0 1040 END
	StrCmp $0 9999 END
	StrCmp $0 1044 END
	StrCmp $0 1045 END
	StrCmp $0 2070 END
	StrCmp $0 1048 END
	StrCmp $0 1049 END
	StrCmp $0 3098 END
	StrCmp $0 2052 END
	StrCmp $0 1051 END
	StrCmp $0 1060 END
	StrCmp $0 1034 END
	StrCmp $0 1053 END
	StrCmp $0 1055 END
	StrCpy $0 error
	END:
	Exch $0
FunctionEnd
;=== CUSTOM
${SegmentFile}
${Segment.OnInit}
	Push $0
	${IsWOW64} $0
	StrCmp $0 0 0 +3
	${WriteSettings} 32 Architecture
		Goto +2
	${WriteSettings} 64 Architecture
	Pop $0
!macroend
;===
!macro ProExecInit
	StrCpy $ProgramExecutable ${APP}\${APP}.exe
!macroend
;===
!define MsgBox "!insertmacro MsgBox"
!macro MsgBox
	StrCpy $0 `Windows XP +`
	MessageBox MB_ICONSTOP|MB_TOPMOST `$(MINREQ)`
	Call Unload
	Quit
!macroend
!macro OS
	Push $0
	${If} ${IsNT}
		${IfNot} ${AtLeastWinXP}
			${MsgBox}
		${EndIf}
	${Else}
		${MsgBox}
	${EndIf}
	Pop $0
!macroend
;===
!define PortableApps.comLocaleID `!insertmacro PortableApps.comLocaleID`
!macro PortableApps.comLocaleID
	IfFileExists `${REG}` 0 +3
	ReadINIStr $0 `${REG}` `${LANG}` `"${KEY}"`
		Goto +2
	ReadINIStr $0 `${DEFREG}` `${LANG}` `"${KEY}"`
	${GetLCID} $0 $0
	${SetEnvironmentVariable} PortableApps.comLocaleID $0
!macroend
!macro Lang
	Push $0
	${GetParent} `$EXEDIR` $0
	${If} ${FileExists} `${PFM}`
		ReadEnvStr $0 PortableApps.comLocaleID
		${validateLCID} $0 $0
		${If} $0 == error
			${PortableApps.comLocaleID}
		${EndIf}
	${Else}
		${PortableApps.comLocaleID}
	${EndIf}
	Pop $0
!macroend
;===
!macro Init
	IfFileExists `${VID}` +2
	CreateDirectory `${VID}`
	IfFileExists `${REG}` +2
	CopyFiles /SILENT `${DEFREG}` `${REG}`
	IfFileExists `${YDS}` +2
	CopyFiles /SILENT `${DEFYDS}` `${YDS}`
!macroend
;===
!macro DirCleanup
	Push $0
	Push $1
	FindFirst $0 $1 `${ASS}\*.*`
	StrCmp $0 "" +8
	StrCmp $1 "" +7
	StrCmp $1 "." +4
	StrCmp $1 ".." +3
	IfFileExists `${ASS}\$1\*.txt` 0 +2
	Delete `${ASS}\$1\*.*`
	FindNext $0 $1
	Goto -6
	FindClose $0
	${RestoreAiR} AIR `${AIR}`
	${RestoreAiR} SOL1 `${SOL1}`
	${RestoreAiR} SOL2 `${SOL2}`
	${RestoreAiR} SOL3 `${SOL3}`
	${RMEmptyDir} `${ASS}` ""
	${RMEmptyDir} `${OBJ}` s.ytimg.com
	${RMEmptyDir} `${OBJ}` `#s.ytimg.com`
	Pop $1
	Pop $0
!macroend
;===
${SegmentInit}
	Push $0
	ClearErrors
	${ReadSettings} $0 LastUserName
	IfErrors +2
	StrCmp $0 "" 0 +2
	ReadEnvStr $0 UserName
	${SetEnvironmentVariable} LastUserName $0
	${DEFVAR} LastVideos $VIDEOS
	${DEFVAR} LastPictures $PICTURES
	${DEFVAR} LastDocuments $DOCUMENTS
	${DEFVAR} LastMusic $MUSIC
	${DEFVAR} LastDesktop $DESKTOP
	Pop $0
!macroend
;===
!macro PreRegWrite
	${DEFSAVE} `${REG}` HKCU `${BRANCH}` ${MRU} `${VID}`
	${DEFSAVE} `${REG}` HKCU `${BRANCH}` ${DWN} `${VID}`
	${DEFSAVE} `${REG}` HKCU `${BRANCH}` ${CON} `${VID}`
!macroend
;===
${SegmentPrePrimary}
	Push $0
	ReadEnvStr $0 UserName
	${WriteSettings} `$0` LastUserName
	${WriteSettings} `$DOCUMENTS` LastDocuments
	${WriteSettings} `$VIDEOS` LastVideos
	${WriteSettings} `$PICTURES` LastPictures
	${WriteSettings} `$MUSIC` LastMusic
	${WriteSettings} `$DESKTOP` LastDesktop
	${SetEnvironmentVariablesPath} VIDEOS $VIDEOS
	${SetEnvironmentVariablesPath} PICTURES $PICTURES
	${SetEnvironmentVariablesPath} MUSIC $MUSIC
	${SetEnvironmentVariablesPath} DESKTOP $DESKTOP
	${File::BackupLocal} `${SENDTO}`
	CreateShortCut `${SENDTO}` `${EXE}` "" `${EXE}` 0
	Pop $0
!macroend
;===
${SegmentPostPrimary}
	${File::RestoreLocal} `${SENDTO}`
!macroend
;===
!macro PreDirMove
	${BackupAiR} AIR `${AIR}`
	${BackupAiR} SOL1 `${SOL1}`
	${BackupAiR} SOL2 `${SOL2}`
	${BackupAiR} SOL3 `${SOL3}`
!macroend
;===
!macro PostDirMove
	Push $0
	Push $1
	Push $2
	ReadEnvStr $0 ALLUSERSAPPDATA
	${If} ${FileExists} `${YTD}\*.exe`
		FindFirst $2 $1 `${YTD}\*.exe`
		ClearErrors
		Delete `${YTD}\$1`
		${If} ${Errors}
			${TerminateProcess} $1 $2
			Sleep 1000
			ClearErrors
			Delete `${YTD}\$1`
			IfErrors 0 +5
			GetTempFileName $2
			Rename `${YTD}\$1` `$TEMP\$2`
			Delete /REBOOTOK `$TEMP\$2`
			RMDir `${YTD}`
		${EndIf}
	${EndIf}
	Pop $2
	Pop $1
	Pop $0
!macroend