/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LayoutComparator;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingDefaultFocusTraversalPolicy;

public class LayoutFocusTraversalPolicy
extends SortingFocusTraversalPolicy
implements Serializable {
    private static final SwingDefaultFocusTraversalPolicy fitnessTestPolicy = new SwingDefaultFocusTraversalPolicy();

    public LayoutFocusTraversalPolicy() {
        super(new LayoutComparator());
    }

    LayoutFocusTraversalPolicy(Comparator comparator) {
        super(comparator);
    }

    public Component getComponentAfter(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getComponentAfter(container, component);
    }

    public Component getComponentBefore(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getComponentBefore(container, component);
    }

    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getFirstComponent(container);
    }

    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getLastComponent(container);
    }

    protected boolean accept(Component component) {
        if (!super.accept(component)) {
            return false;
        }
        if (component instanceof JTable) {
            return true;
        }
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            return jComboBox.getUI().isFocusTraversable(jComboBox);
        }
        if (component instanceof JComponent) {
            InputMap inputMap;
            JComponent jComponent = (JComponent)component;
            for (inputMap = jComponent.getInputMap(0, false); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
            }
            if (inputMap != null) {
                return true;
            }
        }
        return fitnessTestPolicy.accept(component);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getComparator());
        objectOutputStream.writeBoolean(this.getImplicitDownCycleTraversal());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setComparator((Comparator)objectInputStream.readObject());
        this.setImplicitDownCycleTraversal(objectInputStream.readBoolean());
    }
}

