﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace ChargeGamePlug
{
    /// <summary>
    /// 插件请实现下面所有接口
    /// </summary>
    public class PlugInterface
    {
        /// <summary>
        /// 框架提供验证码识别功能.CommonDefine.ITLValidateCode由CommonDefine.dll提取,首先引入该库
        /// </summary>
        /// <param name="tlvc"></param>
        static public void InitPlug(CommonDefine.ITLValidateCode tlvc,CommonDefine.ITLGameChargeMgr gcmgr)
        {
            g_validateCode = tlvc;
            g_tlGameChargeMgr = gcmgr;
        }

        /// <summary>
        /// 获取插件名.
        /// </summary>
        /// <returns></returns>
        static public string GetPlugName()
        {
            return "网易";
        }

        /// <summary>
        /// 获取该插件对应的WEB站点
        /// </summary>
        /// <returns></returns>
        static public string GetPlugUrl()
        {
            return "www.163.com";
        }

        /// <summary>
        /// 获取插件作者
        /// </summary>
        /// <returns></returns>
        static public string GetPlugAuthor()
        {
            return "酷酷(kevin)";
        }

        /// <summary>
        /// 获取插件版本
        /// </summary>
        /// <returns></returns>
        static public string GetPlugVersion()
        {
            return "1.0.0.0";
        }

        /// <summary>
        /// 获取插件类型
        /// </summary>
        /// <returns></returns>
        static public int GetPlugType()
        {
            return (int)CommonDefine.PLUG_APP_TYPE.Game_Chare_Type;
        }

        /// <summary>
        /// 获取插件GUID,每个插件唯一
        /// </summary>
        /// <returns></returns>
        static public string GetPlugGUID()
        {
            return "{ebdf3bdf-de40-4b72-bf6d-f4a4d694479f}";
        }

        /// <summary>
        /// 获取插件支持的卡类型列表,多个使用"\r\n"分开(每行一个)
        /// 注:该方法返回的ID值,通过名字在系统中找如果没有增加,如果有直接获取到ID,一般一个插件只对应一种卡类型进行充值
        /// </summary>
        /// <returns></returns>
        static public string GetPlugSupportCardTypes()
        {
            long cardTypeId = g_tlGameChargeMgr.GetCardTypeIdByCardName("俊网一卡通");
            if (cardTypeId == -1)
                cardTypeId = g_tlGameChargeMgr.AddCardType("俊网一卡通");
            return cardTypeId.ToString();
        }
        /// <summary>
        /// 获取插件支持充值游戏列表,多个使用"\r\n"分开(每行一个)
        /// </summary>
        /// <returns></returns>
        static public string GetPlugSupportGames()
        {
            string supprotGames = "动作类\\新飞飞\r\n大话西游系列\r\n百变金刚\r\n梦幻西游";
            return supprotGames;
        }

        //===========================================================================================================
        /// <summary>
        /// 获取插件的界面对话框
        /// </summary>
        /// <param name="paramInfo">被序列代后进行BASIC64编码的文本信息,描述用户在插件窗口中输入的信息</param>
        /// <remarks>插件内的信息的序列化和返序列化都是由插件内存完成,框架只是作为中间对其进行传输,不进行任何修改处理</remarks>
        /// <returns></returns>s
        static public IntPtr CreatePlugUI(string gameName,string paramInfo)
        {
            if (g_WYChargeForm == null)
                g_WYChargeForm = new WYChargePlug.WYChargeForm();
            g_WYChargeForm.SetDefaultValue(paramInfo);
            return g_WYChargeForm.Handle;
        }

        /// <summary>
        /// 序列化接口,用户在插件中输入信息后,由框架调用该接口获取用户输入的所有参数
        /// </summary>
        /// <returns></returns>
        static public string SerialCurUserEnterInfo(string gameName)
        {
            if (g_WYChargeForm != null)
            {
                return g_WYChargeForm.SerialUserEnterInfo();
            }
            else
            {
                return string.Empty;
            }
        }

        /// <summary>
        /// 从用户对该插件的参数中获取游戏ID信息
        /// </summary>
        /// <param name="paramInfo">用户参数</param>
        /// <returns></returns>
        static public string GetChargeGameName(string paramInfo)
        {
            return "大话西游系列";
        }

        /// <summary>
        /// 从用户对该插件的参数中获取充值游戏相关信息,如充值的是什么游戏,是那个区的,如果没有反回空
        /// </summary>
        /// <param name="paramInfo">用户参数</param>
        /// <returns></returns>
        static public string GetChargeOtherDesc(string paramInfo)
        {
            //解析paramInfo参数,提出充值游戏的相关信息,如果没有就返回空,如有一些站点有多个游戏或有区的选择
            return string.Empty;
        }

        /// <summary>
        /// 验证用户输入信息的正确性.返回信息同ChargeGame相同,成功返回T,失败F后面跟失败信息
        /// </summary>
        /// <returns></returns>
        static public string UserEnterParamValid(string gameName)
        {
            string account = GetChargeGameName(SerialCurUserEnterInfo(gameName));
            if (account.Trim().Length <= 0)
            {
                return "F帐号不能为空!";
            }
            if (account == "信息传输错误")
            {
                return "F信息传输错误";
            }
            return "T";

        }

        /// <summary>
        /// 充值接口
        /// </summary>
        /// <param name="cardId">充值卡ID</param>
        /// <param name="cardPass">充值密码</param>
        /// <param name="cardType">充值卡类型</param>
        /// <param name="userName">用户名</param>
        /// <param name="otherInfo">其它信息</param>
        /// <param name="paramInfo">参数信息</param>
        /// <param name="paramInfo">SerialCurUserEnterInfo接口返回的序列后的信息</param>
        /// <returns>返回时第个字母表示充值成功还是失败,后面为信息.第一个字母T表求成功F表示失败</returns>
        static public string ChargeGame(string cardId, string cardPass, long cardType, string userName, string otherInfo, string paramInfo)
        {
            string account = userName;
            if (account == "信息传输错误")
            {
                return BuildResult(false, account);
            }

            HttpConfig config = new HttpConfig();

            config.Url = "https://pay.163.com/servlet/controller?operation=dofastfillvalue&from=pcard";
            config.Referer = "http://pay.163.com/index.jsp";
            config.Method = "POST";
            config.PostData.Add(new HttpPostData("ursName", account));
            config.PostData.Add(new HttpPostData("userName2", account));
            config.PostData.Add(new HttpPostData("cardNo", cardId));
            config.PostData.Add(new HttpPostData("cardPass", cardPass));

            HttpProcessor processor = new HttpProcessor(config);
            string input = processor.Processor();

            if (Regex.IsMatch(input, "<head><META HTTP\\-EQUIV\\=REFRESH CONTENT=\"0;URL=http\\:\\/\\/pay\\.163\\.com\\/jsp\\/chargeFail\\.jsp\\?errorID\\=\\-\\d+\"><\\/head>"))
            {
                string str3 = Regex.Match(input, "<head><META HTTP\\-EQUIV\\=REFRESH CONTENT=\"0;URL=(?<ErrorUrl>http\\:\\/\\/pay\\.163\\.com\\/jsp\\/chargeFail\\.jsp\\?errorID\\=\\-\\d+)\"><\\/head>").Groups["ErrorUrl"].Value;
                config.Referer = config.Url;
                config.Url = str3;
                config.Method = "GET";
                config.PostData.Clear();
                string str4 = processor.Processor();
                return ("F" + Regex.Match(str4, "\\<h3\\>(?<ErrorMessage>.+)\\&nbsp\\;\\&nbsp\\;\\<a href\\=\"\\/servlet\\/controller\\?operation\\=fillvalue\\\">\\[返回继续充值\\]\\<\\/a\\>\\<\\/h3\\>").Groups["ErrorMessage"].Value);
            }
            return "T未经测试的成功";
        }

        private static string BuildResult(bool right, string result)
        {
            return string.Format("{0}{1}", right ? "T" : "F", result);
        }


        public static CommonDefine.ITLValidateCode g_validateCode = null;               //验证码识别接口
        public static CommonDefine.ITLGameChargeMgr g_tlGameChargeMgr = null;           //游戏充值管理接口
        public static WYChargePlug.WYChargeForm g_WYChargeForm = null;
    }
}
