﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;

namespace ChargeGamePlug
{
    internal class HttpProcessor
    {
        #region 字段
        private HttpConfig _Config;
        private bool _Success = false;
        private string _ErrorCode = "";
        private string _StatusCode = "";
        #endregion

        #region 属性
        /// <summary>
        /// 错误代码
        /// </summary>
        public string ErrorCode { get { return _ErrorCode; } }
        /// <summary>
        /// 状态代码
        /// </summary>
        public string StatusCode { get { return _StatusCode; } }
        /// <summary>
        /// 请求是否成功
        /// </summary>
        public bool Success { get { return _Success; } }
        #endregion

        #region 构造方法
        /// <summary>
        /// 构造方法,默认配置
        /// </summary>
        public HttpProcessor()
        {
            _Config = new HttpConfig();
        }

        /// <summary>
        /// 构造方法
        /// </summary>
        /// <param name="config">配置信息</param>
        public HttpProcessor(HttpConfig config)
        {
            _Config = config;
        }
        #endregion

        #region 私有方法
        /// <summary>
        /// 创建请求对象
        /// </summary>
        /// <returns></returns>
        private HttpWebRequest CreateRequest()
        {
            HttpWebRequest request = null;

            request = (HttpWebRequest)HttpWebRequest.Create(_Config.Url);//创建请求
            request.Accept = _Config.Accept; //接受任意文件
            request.UserAgent = _Config.UserAgent;
            request.Method = _Config.Method;

            request.CookieContainer = new CookieContainer();//cookie容器，
            request.Referer = _Config.Referer;
            request.ContentType = _Config.ContentType;
            request.KeepAlive = _Config.KeepAlive;

            if (_Config.IsMultipart)
            {
                request.ContentType += "boundary=" + _Config.Boundary;
            }

            //使用代理
            if (_Config.ProxyServer.Length > 0)
            {
                WebProxy myProxy = new WebProxy();
                myProxy.Address = new Uri(String.Format("http://{0}:{1}", _Config.ProxyServer, _Config.ProxyPort));

                if (_Config.ProxyUsername.Length > 0 & _Config.ProxyPassword.Length > 0)
                {
                    myProxy.Credentials = new NetworkCredential(_Config.ProxyUsername, _Config.ProxyPassword);
                }

                request.Proxy = myProxy;
            }

            //如果附带cookie 就发送
            if (_Config.CookiePost != null)
            {
                System.Uri u = new Uri(_Config.Url);
                //doenet处理cookie的bug：请求的服务器和cookie的Host必须一直，否则不发送或获取！

                //这里修改成一致！
                foreach (System.Net.Cookie c in _Config.CookiePost)
                {
                    c.Domain = u.Host;
                }

                request.CookieContainer.Add(_Config.CookiePost);
            }

            //如果需要发送数据，就以Post方式发送
            if (_Config.PostData != null && _Config.PostData.Count > 0)
            {
                //发送http数据：朝请求流中写post的数据
                byte[] b = _Config.Encoding.GetBytes(_Config.PostDataString);
                request.ContentLength = b.Length;
                System.IO.Stream sw = null;
                try
                {
                    sw = request.GetRequestStream();
                    sw.Write(b, 0, b.Length);
                }
                catch (System.Exception ex)
                {
                    _ErrorCode = ex.Message;
                }
                finally
                {
                    if (sw != null) { sw.Close(); }
                }

            }
            return request; //返回创建的请求对象
        }
        #endregion

        #region 公共方法
        /// <summary>
        /// 获取信息
        /// </summary>
        /// <returns></returns>
        public string Processor()
        {
            HttpWebRequest request = CreateRequest();
            HttpWebResponse response = null; ;
            
            System.IO.StreamReader sr = null;
            string html = string.Empty;

            try
            {
                //这里得到响应
                response = (HttpWebResponse)request.GetResponse();
                sr = new System.IO.StreamReader(response.GetResponseStream(), _Config.Encoding);

                html = sr.ReadToEnd(); // 这里假定响应的都是html文本
                _Success = true;
            }
            catch (System.Exception ex)
            {
                _ErrorCode = ex.Message;//发生错误就返回空文本
                return "";
            }
            finally
            {
                if (sr != null) { sr.Close(); }
            }
            //状态码
            _StatusCode = response.StatusCode.ToString();

            if (_StatusCode == "302") //如果是302重定向的话就返回新的地址。
            {
                html = response.Headers["location"];
            }

            //得到cookie
            if (response.Cookies.Count > 0)
            {
                _Config.CookieGet = response.Cookies; //得到新的cookie：注意这里没考虑cookie合并的情况
            }
            return html.Replace("\r", "").Replace("\n", "");
        }
        #endregion
    }
}
