﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChargeGamePlug
{
    /// <summary>
    /// 要发送的数据
    /// </summary>
    public class HttpPostData
    {
        string _Key = "";
        string _Value = "";

        /// <summary>
        /// 字段名
        /// </summary>
        public string Key { set { _Key = Value;} get { return _Key; } }

        /// <summary>
        /// 字段值
        /// </summary>
        public string Value { set { _Value = value; } get { return _Value; } }

        /// <summary>
        /// 默认构造
        /// </summary>
        public HttpPostData(){}

        /// <summary>
        /// 构造方法
        /// </summary>
        /// <param name="key">字段名</param>
        /// <param name="value">字段值</param>
        public HttpPostData(string key, string value)
        {
            this.Key = key;
            this.Value = value;
        }
    }

    public class HttpConfig
    {
        private string _Accept = "*/*";
        private string _UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; .NET CLR 1.1.4322)";
        private string _ContentType = "application/x-www-form-urlencoded";
        private string _Method = "GET";
        private string _Url = "";
        private string _Referer = "";
        private string _ProxyServer = "";
        private string _ProxyPort = "";
        private string _ProxyUsername = "";
        private string _ProxyPassword = "";
        private System.Net.CookieCollection _CookiePost;
        private System.Net.CookieCollection _CookieGet;
        private System.Text.Encoding _Encoding = System.Text.Encoding.Default;
        private List<HttpPostData> _PostData = new List<HttpPostData>();
        private bool _IsMultipart;
        private string _Boundary = "";
        private bool _KeepAlive;

        /// <summary>
        /// 接受文件类型
        /// </summary>
        public string Accept { set { _Accept = value; } get { return _Accept; } }

        /// <summary>
        /// 模拟使用IE在浏览
        /// </summary>
        public string UserAgent { set { _UserAgent = value; } get { return _UserAgent; } }

        /// <summary>
        /// 请求方法"POST"或"GET"
        /// </summary>
        public string Method { set { _Method = value; } get { return _Method; } }

        /// <summary>
        /// 内容类型
        /// </summary>
        public string ContentType { set { _ContentType = value; } get { return _ContentType; } }

        /// <summary>
        /// 访问的网站地址
        /// </summary>
        public string Url { set { _Url = value; } get { return _Url; } }

        /// <summary>
        /// 来源网址
        /// </summary>
        public string Referer { set { _Referer = value; } get { return _Referer; } }

        /// <summary>
        /// 代理服务器地址
        /// </summary>
        public string ProxyServer { set { _ProxyServer = value; } get { return _ProxyServer; } }

        /// <summary>
        /// 代理服务器端口
        /// </summary>
        public string ProxyPort { set { _ProxyPort = value; } get { return _ProxyPort; } }

        /// <summary>
        /// 代理用户名
        /// </summary>
        public string ProxyUsername { set { _ProxyUsername = value; } get { return _ProxyUsername; } }

        /// <summary>
        /// 代理密码
        /// </summary>
        public string ProxyPassword { set { _ProxyPassword = value; } get { return _ProxyPassword; } }

        /// <summary>
        /// 要发送的Cookie
        /// </summary>
        public System.Net.CookieCollection CookiePost { set { _CookiePost = value; } get { return _CookiePost; } }

        /// <summary>
        /// 获取得到的Cookie
        /// </summary>
        public System.Net.CookieCollection CookieGet { set { _CookieGet = value; } get { return _CookieGet; } }

        /// <summary>
        /// 编码
        /// </summary>
        public System.Text.Encoding Encoding { set { _Encoding = value; } get { return _Encoding; } }

        /// <summary>
        /// 插入发送数据
        /// </summary>
        public List<HttpPostData> PostData { set { _PostData = value; } get { return _PostData; } }

        /// <summary>
        /// 是否是"multipart/form-data"方式发送数据
        /// </summary>
        public bool IsMultipart { set { _IsMultipart = value; } get { return _IsMultipart; } }

        /// <summary>
        /// 分隔符
        /// </summary>
        public string Boundary { set { _Boundary = value; } get { return _Boundary; } }

        /// <summary>
        /// KeepAlive
        /// </summary>
        public bool KeepAlive { set { _KeepAlive = value; } get { return _KeepAlive; } }

        /// <summary>
        /// 返回发送数据列表
        /// </summary>
        public string PostDataString
        {
            get
            {
                if (_PostData.Count <= 0)
                    return string.Empty;
                System.Text.StringBuilder sb = new StringBuilder();
                if (!IsMultipart)
                {
                    for (int i = 0; i < _PostData.Count; i++)
                    {
                        if (i == 0)
                            sb.AppendFormat("{0}={1}", _PostData[i].Key, _PostData[i].Value);// System.Web.HttpUtility.UrlEncode(_PostData[i].Value));
                        else
                            sb.AppendFormat("&{0}={1}", _PostData[i].Key, _PostData[i].Value);// System.Web.HttpUtility.UrlEncode(_PostData[i].Value));
                    }
                }
                else
                {
                    for (int i = 0; i < _PostData.Count; i++)
                    {
                        sb.AppendFormat("--{0}\r\nContent-Disposition: form-data; name=\"{1}\"\r\n\r\n{2}\r\n", this.Boundary, _PostData[i].Key, _PostData[i].Value);
                    }
                    sb.AppendFormat("--{0}--", this.Boundary);
                }
                return sb.ToString();
            }
        }
    }
}
