var totalLevel=0;
var planelist;
var json;
var dossier;
var planeStats;
var summary;

function getTypeName(type){
	if(type=="Fighter"){
		return "战斗机";
	}
	if(type=="Heavy fighter"){
		return "重型战斗机";
	}
	if(type=="Assault"){
		return "攻击机";
	}
	return "未知";
}
function getCountryName(country){
	if(country=="ussr"){
		return "苏联";
	}
	if(country=="germany"){
		return "德国";
	}
	if(country=="japan"){
		return "日本";
	}
	if(country=="china"){
		return "中国";
	}
	if(country=="usa"){
		return "美国";
	}
	if(country=="gb"){
		return "英国";
	}
	return "未知";
}
function getModify(battles,level){
	var levelModify=0;
	var battleModify=0;
	//基于最大等级
	if(level==1){
		levelModify=0.1;
	}
	else if(level==2){
		levelModify=0.2;
	}
	else if(level==3){
		levelModify=0.3;
	}
	else if(level==4){
		levelModify=0.5;
	}
	else if(level==5){
		levelModify=0.8;
	}
	else if(level==6){
		levelModify=0.94;
	}
	else if(level==7){
		levelModify=0.98;
	}
	else levelModify=1;
	//基于场次
	if(battles>=1000)
		battleModify=1;
	else if(battles>=900)
		battleModify=0.98;
	else if(battles>=800)
		battleModify=0.96;
	else if(battles>=700)
		battleModify=0.94;
	else if(battles>=600)
		battleModify=0.92;
	else if(battles>=500)
		battleModify=0.9;
	else if(battles>=400)
		battleModify=0.8;
	else if(battles>=300)
		battleModify=0.7;
	else if(battles>=200)
		battleModify=0.6;
	else if(battles>=100)
		battleModify=0.4;
	else
		battleModify=0.2;

	if (levelModify<battleModify){
		return levelModify;
	}else{
		return battleModify;
	}
}

function getPlaneTr(id,planeData,planeSummary){
//	<th>战机名称</th>
//	<th>系别</th>
//	<th>类型</th>
//	<th>等级</th>
//	<th>总场次</th>
//	<th>总胜率</th>
//	<th>幸存率</th>
//	<th>效率</th>
//	<th>对空击杀</th>
//	<th>对空助攻</th>
//	<th>对空伤害</th>
//	<th>对地击毁</th>
//	<th>对地助攻</th>
//	<th>对地伤害</th>
//	<th>经验</th>
	var tdam=0;
	var tkill=0;
	var tdest=0;
	var tgdam=0;
	var damstd=planeSummary.level*50;
	for(var i in planeData.totalDamageDealt){
		tdam+=planeData.totalDamageDealt[i];
	}
	for(var i in planeData.totalKilled){
		tkill+=planeData.totalKilled[i];
	}
	for(var i in planeData.totalTurretsDestroyed){
		tdest+=planeData.totalTurretsDestroyed[i];
	}
	for(var i in planeData.totalGroundObjectsDestroyed){
		tdest+=planeData.totalGroundObjectsDestroyed[i];
	}
	for(var i in planeData.totalStructureDamage){
		tgdam+=planeData.totalStructureDamage[i];
	}
	var dameff=1.0*tdam/planeData.gamesPlayed/damstd*500;
	var killeff=1.0*tkill/planeData.gamesPlayed*500;
	var destoryeff=1.0*tdest/planeData.gamesPlayed*500/4;
	totalLevel+=planeSummary.level*planeData.gamesPlayed;
	var tr="<tr>";
	tr+="<td class='"+(planeSummary.isgift>0?"primary":"")+"'>"+decodeURI(planeSummary.alias)+"</td>";
	tr+="<td>"+getCountryName(planeSummary.country)+"</td>";
	tr+="<td>"+getTypeName(planeSummary.type)+"</td>";
	tr+="<td>"+planeSummary.level+"</td>";
	tr+="<td>"+planeData.gamesPlayed+"</td>";
	tr+="<td>"+Number(100*planeData.wins/planeData.gamesPlayed).toFixed(0)+"%</td>";
	tr+="<td class='percent'>"+(planeData.survived/planeData.gamesPlayed)+"</td>";
	var totaleff=Number(dameff+killeff+destoryeff).toFixed(0);
	tr+="<td class='eff'>"+totaleff+"</td>";
	tr+="<td class='double'>"+(tkill/planeData.gamesPlayed)+"</td>";
	tr+="<td class='double'>"+(planeData["totalAssists"]/planeData.gamesPlayed)+"</td>";
	tr+="<td class='int'>"+(tdam/planeData.gamesPlayed)+"</td>";
	tr+="<td class='double'>"+(tdest/planeData.gamesPlayed)+"</td>";
	tr+="<td class='double'>"+(planeData["totalAssistsGround"]/planeData.gamesPlayed)+"</td>";
	tr+="<td class='int'>"+(tgdam/planeData.gamesPlayed)+"</td>";
	tr+="<td class='int'>"+(planeData["baseGainExperience"]/planeData.gamesPlayed)+"</td>";
	tr+="</tr>";
	return tr;
}

$(document).ready(function() {
	$("#planesjson").load("planes.json",function(responseTxt,statusTxt,xhr){
		if(statusTxt=="success"){
			planelist=JSON.parse(responseTxt).planes;
			$.get("action/UserAction/getUser"+location.search,function(data){
				try{
					json=JSON.parse(data.toString());
					dossier=json.user.json;
					planeStats=JSON.parse(dossier.planeStats);
					summary=JSON.parse(dossier.summaryStats);
					var maxlevel=0;
					for(var i in planeStats){
						if(planeStats[i].gamesPlayed>0){
							$("#planebody").append(getPlaneTr(i,planeStats[i],planelist[i]));
							if(planelist[i].level>maxlevel){
								maxlevel=planelist[i].level;
							}
						}
					}
	//				<th>战机名称</th>
	//				<th>系别</th>
	//				<th>类型</th>
	//				<th>等级</th>
	//				<th>总场次</th>
	//				<th>总胜率</th>
	//				<th>组队场次</th>
	//				<th>组队胜率</th>
	//				<th>幸存率</th>
	//				<th>效率</th>
	//				<th>对空击杀</th>
	//				<th>对空助攻</th>
	//				<th>对空伤害</th>
	//				<th>对地击毁</th>
	//				<th>对地助攻</th>
	//				<th>对空伤害</th>
	//				<th>经验</th>
	
					var tdam=0;
					var tkill=0;
					var tdest=0;
					var tgdam=0;
					for(var i in summary.totalDamageDealt){
						tdam+=summary.totalDamageDealt[i];
					}
					for(var i in summary.totalKilled){
						tkill+=summary.totalKilled[i];
					}
					for(var i in summary.totalTurretsDestroyed){
						tdest+=summary.totalTurretsDestroyed[i];
					}
					for(var i in summary.totalGroundObjectsDestroyed){
						tdest+=summary.totalGroundObjectsDestroyed[i];
					}
					for(var i in summary.totalStructureDamage){
						tgdam+=summary.totalStructureDamage[i];
					}
					var tr="<tr id='hl'>";
					tr+="<td>"+decodeURI(json.user.name)+"</td>";
					tr+="<td>"+""+"</td>";
					tr+="<td>"+""+"</td>";
					tr+="<td class='double'>"+(totalLevel/summary.gamesPlayed)+"</td>";
					tr+="<td>"+summary.gamesPlayed+"</td>";
					tr+="<td class='percent'>"+(summary.wins/summary.gamesPlayed)+"</td>";
	//				tr+="<td>"+json.user.squadBattles+"</td>";
	//				if(json.user.squadBattles>0){
	//				tr+="<td>"+Number(json.user.squadWins/json.user.squadBattles).toFixed(2)+"</td>";
	//				}else{
	//					tr+="<td>0</td>";
	//				}
					tr+="<td class='percent'>"+(summary.survived/summary.gamesPlayed)+"</td>";
					tr+="<td class='eff'>"+(json.user.damageEff+json.user.killEff+json.user.destoryEff)+"</td>";
					tr+="<td class='double'>"+(tkill/summary.gamesPlayed)+"</td>";
					tr+="<td class='double'>"+(summary["totalAssists"]/summary.gamesPlayed)+"</td>";
					tr+="<td class='int'>"+(tdam/summary.gamesPlayed)+"</td>";
					tr+="<td class='double'>"+(tdest/summary.gamesPlayed)+"</td>";
					tr+="<td class='double'>"+(summary["totalAssistsGround"]/summary.gamesPlayed)+"</td>";
					tr+="<td class='int'>"+(tgdam/summary.gamesPlayed)+"</td>";
					tr+="<td class='int'>"+(summary["baseGainExperience"]/summary.gamesPlayed)+"</td>";
					tr+="</tr>";
					$("#planebody").append(tr);
					var modify=getModify(summary.gamesPlayed,maxlevel);
					$(".eff").each(function(e){
						$(this).text(Number(Number($(this).text())*modify).toFixed(0).toString());
						$(this).attr("title","效率系数"+(modify*100)+"%(基于最大飞机等级和场次)");
					});
					refreshClass();
					if ($("#planebody").text().length > 0) {
						$("table#planetable").tablesorter({
							sortInitialOrder : "desc",
							sortList : [ [ 4, 1 ] ]
						});
					}
				} catch (e) {
					console.log(e.toString());
					console.log(data.toString());
				};
			});
		}
		if(statusTxt=="error")
			alert("无法获取战机数据，请");
	});
});