var tanksjson;
var mapsjson;
$(document).ready(function() {
	$("#tanks").load("..\\dossier\\tanks.json",function(data){
        try {
            tanksjson = JSON.parse(data);
            $("#maps").load("..\\dossier\\maps.json", function (data) {
                mapsjson = JSON.parse(data);
                if (location.search.length == 0) {
                    return;
                }
                var map = new Array();
                var s = location.search.substr(1).split("&");
                for (var i in s) {
                    var kv = s[i].split("=");
                    map[kv[0]] = kv[1];
                }
                if (map['arenaid'] && map['aid']) {
                    executeSql("select * from t_battleResult where arena_id=" + map['arenaid'], 'db', function (data) {
                        var team1 = [];
                        var team2 = [];
                        var playerteam = 0;
                        var battles = data.split("\n");
                        var firstbattle = battles[0].split("|");
                        var winteam = firstbattle[8];
                        $("#duration").text(Number(firstbattle[9] / 60).toFixed(0) + "分" + Number(firstbattle[9] % 60).toFixed(0) + "秒");
                        for (var i in battles) {
                            var battle = battles[i].split("|");
                            if (battle.length < 10) {
                                continue;
                            }
                            var tank = getTankByVid(battle[2]);
                            if (tank == null) {
                                continue;
                            }
                            var player = (battle[1] == map['aid']);
                            var tr = "<tr id='" + (player ? "player" : "") + "' class='" + (battle[18] > 0 ? "" : "dead") + "'>";
                            tr += "<td >" + battle[23] + "</td>";
                            tr += "<td class=" + (tank.premium == 0 ? "" : "premium") + ">" + tank.title + "</td>";
                            tr += "<td>" + battle[12] + "</td>";
                            tr += "<td>" + battle[14] + "</td>";
                            tr += "<td>" + battle[13] + "</td>";
                            tr += "<td>" + battle[15] + "</td>";
                            tr += "<td>" + battle[21] + "</td>";
                            tr += "</tr>";
                            if (player) {
                                playerteam = battle[11];
                            }
                            if (battle[11] == 1) {
                                team1.push(tr);
                            } else {
                                team2.push(tr);
                            }
                        }
                        if (playerteam == 1) {
                            pushTr(team1, "detailbody1");
                            pushTr(team2, "detailbody2");
                        } else {
                            pushTr(team2, "detailbody1");
                            pushTr(team1, "detailbody2");
                        }
                        if (winteam == playerteam) {
                            $("#summarybody1").append("<tr class='win'><td></td><td>待添加</td><td></td></tr>");
                            $("#summarybody2").append("<tr class='lose'><td></td><td>待添加</td><td></td></tr>");
                        } else if (winteam == 0) {
                            $("#summarybody1").append("<tr class='draw'><td></td><td>待添加</td><td></td></tr>");
                            $("#summarybody2").append("<tr class='draw'><td></td><td>待添加</td><td></td></tr>");
                        } else {
                            $("#summarybody1").append("<tr class='lose'><td></td><td>待添加</td><td></td></tr>");
                            $("#summarybody2").append("<tr class='win'><td></td><td>待添加</td><td></td></tr>");
                        }

                        if ($("#detailbody1").length > 0) {
                            $("table#detailtable1").tablesorter({
                                sortInitialOrder: "desc",
                                sortList: [
                                    [ 6, 1 ]
                                ]
                            });
                        }
                        if ($("#detailbody2").length > 0) {
                            $("table#detailtable2").tablesorter({
                                sortInitialOrder: "desc",
                                sortList: [
                                    [ 6, 1 ]
                                ]
                            });
                        }
                    });
                    executeSql("select * from  t_replay where arena_id=" + map['arenaid'] + " and account_db_id=" + map['aid'], 'db', function (data) {
                        var replay = data.split("|");
                        var d = new Date(replay[5] * 1000)
                        $("#battletime").text(date2str(d, "yyyy-MM-dd hh:mm:ss"));
                        $("#mapname").text(getMapByMid(replay[7]).mapname);
                        $("#gametype").text(getGameTypeById(replay[4]));
                        $("#battletype").text(getBattleTypeById(replay[3]));
                    });
                }
            });
        }catch(e){
            customAlert("加载坦克失败","warning");
        }
	});
});

function pushTr(trlist,id){
	for (var i in trlist){
		$("#"+id).append(trlist[i]);
	}
}

function getMarkByTier(mark){
	if(mark==0){
		return "无";
	}
	if(mark==1){
		return "三级";
	}
	if(mark==2){
		return "二级";
	}
	if(mark==3){
		return "一级";
	}
	if(mark==4){
		return "特级";
	}
	return "未知";
}

function getGameTypeById(id){
	if(id=="ctf"){
		return "标准";
	}
	if(id=="nations"){
		return "国战";
	}
	if(id=="domination"){
		return "夺旗";
	}
	if(id=="assault"){
		return "攻防";
	}
	return "未知类型";
}

function getBattleTypeById(id){
	if(id==1){
		return "随机战";
	}
	if(id==2){
		return "训练房";
	}
	if(id==3){
		return "联队战";
	}
	if(id==4){
		return "领土战";
	}
	if(id==5){
		return "竞技场";
	}
	if(id==7){
		return "7V7";
	}
	if(id==8){
		return "历史战";
	}
	if(id==10){
		return "特别活动";
	}
	return "未知类型";
}

function getCountryById(cid){
	if (cid==-1){
		return "未知";
	}
	if (cid==0){
		return "苏联";
	}
	if (cid==1){
		return "德国";
	}
	if (cid==2){
		return "美国";
	}
	if (cid==3){
		return "中国";
	}
	if (cid==4){
		return "法国";
	}
	if (cid==5){
		return "英国";
	}
	if (cid==6){
		return "日本";
	}
	return "";
}

function getPremium(id){
	if(id==-1){
		return "未知";
	}
	if (id==0){
		return "银币车";
	}
	if (id==1){
		return "金币车";
	}
	return "";
}