/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static Image resizeImage(Image image, double maxWidth, double maxHeight) {
        double height;
        double limitRatio = maxWidth / maxHeight;
        double width = image.getWidth(null);
        double ratio = width / (height = (double)image.getHeight(null));
        if (ratio > limitRatio) {
            width = maxWidth;
            height = maxWidth / ratio;
        } else {
            height = maxHeight;
            width = maxHeight * ratio;
        }
        return image.getScaledInstance((int)width, (int)height, 4);
    }

    public static String getFileNameFromUrl(String url) {
        try {
            return URLDecoder.decode(url.replaceFirst(".*/", ""), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("URL\u7f16\u7801\u5f02\u5e38", (Throwable)ex);
            return "unknown";
        }
    }
}

