/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import io.github.azige.moebooruviewer.SiteConfig;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class UserSetting {
    private static final int MAX_HISTORY_COUNT = 10;
    private SiteConfig siteConfig;
    private LinkedList<String> searchHistories = new LinkedList();
    private File lastSaveDir;
    private boolean safeMode = true;
    private String LookAndFeel;
    private List<SaveLocation> saveLocations;
    private int pageSize;

    public static UserSetting createDefaultSetting() {
        UserSetting setting = new UserSetting();
        setting.saveLocations = Arrays.asList(new SaveLocation("\u58c1\u7eb8", new File("wallpaper").getAbsoluteFile()), new SaveLocation("\u53ef\u516c\u5f00\u6536\u85cf", new File("collections").getAbsoluteFile()), new SaveLocation("\u975e\u516c\u5f00\u6536\u85cf", new File(".collections").getAbsoluteFile()), new SaveLocation("\u6682\u5b58", new File("recycler").getAbsoluteFile()));
        setting.siteConfig = SiteConfig.KONACHAN;
        setting.LookAndFeel = "Nimbus";
        setting.pageSize = 20;
        return setting;
    }

    public SiteConfig getSiteConfig() {
        return this.siteConfig;
    }

    public void setSiteConfig(SiteConfig siteConfig) {
        this.siteConfig = siteConfig;
    }

    @XmlElementWrapper(name="searchHistories")
    @XmlElement(name="history")
    public LinkedList<String> getSearchHistories() {
        return this.searchHistories;
    }

    public void setSearchHistories(LinkedList<String> searchHistories) {
        this.searchHistories = searchHistories;
    }

    public void addSearchHistory(String keywords) {
        this.searchHistories.offer(keywords);
        if (this.searchHistories.size() > 10) {
            this.searchHistories.poll();
        }
    }

    public File getLastSaveDir() {
        return this.lastSaveDir;
    }

    public void setLastSaveDir(File lastSaveDir) {
        this.lastSaveDir = lastSaveDir;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public String getLookAndFeel() {
        return this.LookAndFeel;
    }

    public void setLookAndFeel(String LookAndFeel2) {
        this.LookAndFeel = LookAndFeel2;
    }

    public List<SaveLocation> getSaveLocations() {
        return this.saveLocations;
    }

    public void setSaveLocations(List<SaveLocation> saveLocations) {
        this.saveLocations = saveLocations;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public static class SaveLocation {
        private String name;
        private File location;

        public SaveLocation() {
        }

        public SaveLocation(String name, File location) {
            this.name = name;
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public File getLocation() {
            return this.location;
        }

        public void setLocation(File location) {
            this.location = location;
        }
    }
}

