/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import io.github.azige.moebooruviewer.MoebooruAPI;
import io.github.azige.moebooruviewer.MoebooruViewer;
import io.github.azige.moebooruviewer.NetIO;
import io.github.azige.moebooruviewer.Post;
import io.github.azige.moebooruviewer.Tag;
import io.github.azige.moebooruviewer.UserSetting;
import io.github.azige.moebooruviewer.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ShowPostPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ShowPostPanel.class);
    @Autowired
    MoebooruViewer moebooruViewer;
    @Autowired
    private ExecutorService executor;
    @Autowired
    private MoebooruAPI mapi;
    @Autowired
    private NetIO netIO;
    @Autowired
    private UserSetting userSetting;
    private static final Map<Integer, Color> TAG_COLOR_MAP;
    private static final Color COLOR_SUCCESS;
    private static final Color COLOR_FAIL;
    private Post presentingPost;
    private Image image;
    private List<LoadingListener> loadingListeners = new ArrayList<LoadingListener>();
    private JFileChooser fileChooser = new JFileChooser();
    private boolean needResizeImage = true;
    private JLabel downloadLabel;
    private JPanel jpegPanel;
    private JPanel originPanel;
    private JLabel postLabel;
    private JPanel samplePanel;
    private JPanel tagPanel;
    private JPanel toolPanel;

    public ShowPostPanel() {
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ShowPostPanel.this.needResizeImage = true;
            }
        });
    }

    private void initToolPanel() {
        this.userSetting.getSaveLocations().forEach(sl -> {
            this.samplePanel.add(this.createDownloadLabel((UserSetting.SaveLocation)sl, this.netIO.getSampleFile(this.presentingPost), this.presentingPost.getSampleUrl()));
            this.jpegPanel.add(this.createDownloadLabel((UserSetting.SaveLocation)sl, null, this.presentingPost.getJpegUrl()));
            this.originPanel.add(this.createDownloadLabel((UserSetting.SaveLocation)sl, this.netIO.getOriginFile(this.presentingPost), this.presentingPost.getOriginUrl()));
        });
        this.samplePanel.add(this.createDownloadToLabel(this.netIO.getSampleFile(this.presentingPost), this.presentingPost.getSampleUrl()));
        this.jpegPanel.add(this.createDownloadToLabel(null, this.presentingPost.getSampleUrl()));
        this.originPanel.add(this.createDownloadToLabel(this.netIO.getOriginFile(this.presentingPost), this.presentingPost.getOriginUrl()));
    }

    private JLabel createDownloadLabel(final UserSetting.SaveLocation sl, final File localFile, final String url) {
        final JLabel label = new JLabel("\u4e0b\u8f7d\u81f3" + sl.getName());
        label.setForeground(Color.WHITE);
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ShowPostPanel.this.downloadFile(label, localFile, url, new File(sl.getLocation(), Utils.getFileNameFromUrl(url)));
                }
            }
        });
        return label;
    }

    private JLabel createDownloadToLabel(final File localFile, final String url) {
        final JLabel label = new JLabel("\u4e0b\u8f7d\u81f3...");
        label.setForeground(Color.WHITE);
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ShowPostPanel.this.downloadFileTo(label, localFile, url);
                }
            }
        });
        return label;
    }

    private void makeLabelDone(JLabel label, final File file) {
        label.setEnabled(true);
        label.setText("\u4e0b\u8f7d\u5b8c\u6210");
        label.setForeground(COLOR_SUCCESS);
        Stream.of(label.getMouseListeners()).forEach(label::removeMouseListener);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(file.getParentFile().toURI());
                }
                catch (IOException ex) {
                    logger.warn("\u6253\u5f00\u6d4f\u89c8\u5668\u51fa\u9519", (Throwable)ex);
                }
            }
        });
    }

    private void downloadFile(JLabel label, File localFile, String url, File saveFile) {
        label.setEnabled(false);
        if (localFile != null && localFile.exists()) {
            try {
                FileUtils.copyFile((File)localFile, (File)saveFile);
                this.makeLabelDone(label, saveFile);
            }
            catch (IOException ex) {
                logger.warn("\u590d\u5236\u6587\u4ef6\u5f02\u5e38", (Throwable)ex);
                label.setText("\u590d\u5236\u6587\u4ef6\u5931\u8d25");
                label.setForeground(COLOR_FAIL);
                label.setEnabled(true);
            }
        } else {
            label.setText("\u4e0b\u8f7d\u4e2d\u2026\u2026");
            label.setForeground(Color.WHITE);
            this.executor.execute(() -> {
                boolean flag = this.netIO.cacheFile(saveFile, url, true);
                SwingUtilities.invokeLater(() -> {
                    if (flag) {
                        this.makeLabelDone(label, saveFile);
                    } else {
                        label.setText("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
                        label.setForeground(COLOR_FAIL);
                        label.setEnabled(true);
                    }
                });
            });
        }
    }

    private void downloadFileTo(JLabel label, File localFile, String url) {
        if (label.isEnabled()) {
            if (this.userSetting.getLastSaveDir() != null) {
                this.fileChooser.setCurrentDirectory(this.userSetting.getLastSaveDir());
            }
            this.fileChooser.setSelectedFile(new File(Utils.getFileNameFromUrl(url)));
            if (this.fileChooser.showSaveDialog(this) == 0) {
                this.userSetting.setLastSaveDir(this.fileChooser.getCurrentDirectory());
                this.downloadFile(label, localFile, url, this.fileChooser.getSelectedFile());
            }
        }
    }

    private void initComponents() {
        this.postLabel = new JLabel();
        this.tagPanel = new JPanel();
        this.toolPanel = new JPanel();
        this.downloadLabel = new JLabel();
        this.samplePanel = new JPanel();
        this.jpegPanel = new JPanel();
        this.originPanel = new JPanel();
        this.setBackground(new Color(34, 34, 34));
        this.setLayout(new BorderLayout());
        this.postLabel.setForeground(new Color(255, 255, 255));
        this.postLabel.setHorizontalAlignment(0);
        this.postLabel.setText("\u52a0\u8f7d\u4e2d\u2026\u2026");
        this.postLabel.setPreferredSize(new Dimension(800, 600));
        this.add((java.awt.Component)this.postLabel, "Center");
        this.tagPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tagPanel.setOpaque(false);
        this.tagPanel.setLayout(new BoxLayout(this.tagPanel, 1));
        this.add((java.awt.Component)this.tagPanel, "Before");
        this.toolPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolPanel.setOpaque(false);
        this.toolPanel.setLayout(new BoxLayout(this.toolPanel, 1));
        this.downloadLabel.setForeground(new Color(255, 255, 255));
        this.downloadLabel.setText("\u52a0\u8f7d\u5927\u56fe");
        this.downloadLabel.setCursor(new Cursor(12));
        this.downloadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ShowPostPanel.this.downloadLabelMouseClicked(evt);
            }
        });
        this.toolPanel.add(this.downloadLabel);
        this.samplePanel.setBorder(BorderFactory.createTitledBorder(null, "\u9884\u89c8\u56fe", 0, 0, new Font("\u5b8b\u4f53", 0, 12), new Color(255, 255, 255)));
        this.samplePanel.setAlignmentX(0.0f);
        this.samplePanel.setOpaque(false);
        this.samplePanel.setLayout(new BoxLayout(this.samplePanel, 1));
        this.toolPanel.add(this.samplePanel);
        this.jpegPanel.setBorder(BorderFactory.createTitledBorder(null, "JPEG", 0, 0, new Font("\u5b8b\u4f53", 0, 12), new Color(255, 255, 255)));
        this.jpegPanel.setAlignmentX(0.0f);
        this.jpegPanel.setOpaque(false);
        this.jpegPanel.setLayout(new BoxLayout(this.jpegPanel, 1));
        this.toolPanel.add(this.jpegPanel);
        this.originPanel.setBorder(BorderFactory.createTitledBorder(null, "\u539f\u56fe", 0, 0, new Font("\u5b8b\u4f53", 0, 12), new Color(255, 255, 255)));
        this.originPanel.setAlignmentX(0.0f);
        this.originPanel.setOpaque(false);
        this.originPanel.setLayout(new BoxLayout(this.originPanel, 1));
        this.toolPanel.add(this.originPanel);
        this.add((java.awt.Component)this.toolPanel, "After");
    }

    private void downloadLabelMouseClicked(MouseEvent evt) {
        boolean force;
        if (SwingUtilities.isLeftMouseButton(evt)) {
            force = false;
        } else if (SwingUtilities.isRightMouseButton(evt)) {
            force = true;
        } else {
            return;
        }
        this.postLabel.setIcon(null);
        this.postLabel.setText("\u52a0\u8f7d\u4e2d\u2026\u2026");
        this.image = null;
        this.executor.execute(() -> {
            this.image = this.netIO.loadOrigin(this.presentingPost, force);
            SwingUtilities.invokeLater(() -> {
                if (this.image != null) {
                    this.showImage();
                } else {
                    this.postLabel.setText("\u52a0\u8f7d\u5931\u8d25\uff01");
                }
            });
        });
    }

    public void addLoadingListener(LoadingListener listener) {
        this.loadingListeners.add(listener);
    }

    public void removeLoadingListener(LoadingListener listener) {
        this.loadingListeners.remove(listener);
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isNeedResizeImage() {
        return this.needResizeImage;
    }

    public void showPost(Post post) {
        this.loadPost(post, false);
        this.presentingPost = post;
        this.postLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ShowPostPanel.this.loadPost(ShowPostPanel.this.presentingPost, true);
                }
            }
        });
        int lineLimit = 25;
        this.tagPanel.removeAll();
        for (final String tagName : post.getTags().split(" ")) {
            JLabel label = new JLabel();
            if (tagName.length() > 25) {
                StringBuilder sb = new StringBuilder("<html>");
                String str = tagName;
                while (str.length() > 25) {
                    sb.append(str.substring(0, 25)).append("<br/>");
                    str = str.substring(25);
                }
                sb.append(str).append("</html>");
                label.setText(sb.toString());
            } else {
                label.setText(tagName);
            }
            label.setForeground(Color.WHITE);
            label.setCursor(Cursor.getPredefinedCursor(12));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ShowPostPanel.this.moebooruViewer.listPosts(tagName);
                }
            });
            this.tagPanel.add(label);
            this.executor.execute(() -> {
                Tag tag = this.netIO.retry(() -> this.mapi.findTag(tagName));
                if (tag != null) {
                    SwingUtilities.invokeLater(() -> {
                        Color color = TAG_COLOR_MAP.get(tag.getType());
                        if (color != null) {
                            label.setForeground(color);
                        }
                    });
                }
            });
        }
        this.initToolPanel();
    }

    private void loadPost(Post post, boolean force) {
        this.postLabel.setIcon(null);
        this.postLabel.setText("\u52a0\u8f7d\u4e2d\u2026\u2026");
        this.loadingListeners.forEach(l -> l.loading(new LoadingEvent()));
        this.image = null;
        this.executor.execute(() -> {
            Image image = this.netIO.loadSample(post, force);
            SwingUtilities.invokeLater(() -> {
                this.image = image;
                if (this.presentingPost == post) {
                    if (image != null) {
                        this.showImage();
                    } else {
                        this.postLabel.setText("\u52a0\u8f7d\u5931\u8d25\uff01");
                    }
                    this.loadingListeners.forEach(l -> l.done(new LoadingEvent()));
                }
            });
        });
    }

    private void showImage() {
        this.postLabel.setText("");
        this.resizeImage();
    }

    public void updateImage() {
        if (this.image != null) {
            this.resizeImage();
        }
    }

    private void resizeImage() {
        this.postLabel.setIcon(new ImageIcon(Utils.resizeImage(this.image, this.postLabel.getWidth(), this.postLabel.getHeight())));
        this.needResizeImage = false;
    }

    static {
        COLOR_SUCCESS = Color.decode("0x339900");
        COLOR_FAIL = Color.decode("0xCC0000");
        TAG_COLOR_MAP = new HashMap<Integer, Color>();
        TAG_COLOR_MAP.put(0, Color.decode("0xEE8887"));
        TAG_COLOR_MAP.put(1, Color.decode("0xCCCC00"));
        TAG_COLOR_MAP.put(3, Color.decode("0xDD00DD"));
        TAG_COLOR_MAP.put(4, Color.decode("0x00AA00"));
    }

    public static interface LoadingListener
    extends EventListener {
        public void loading(LoadingEvent var1);

        public void done(LoadingEvent var1);
    }

    public class LoadingEvent
    extends EventObject {
        public LoadingEvent() {
            super(ShowPostPanel.this);
        }

        @Override
        public ShowPostPanel getSource() {
            return (ShowPostPanel)super.getSource();
        }
    }
}

