/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import io.github.azige.moebooruviewer.Post;
import io.github.azige.moebooruviewer.ShowPostPanel;
import io.github.azige.moebooruviewer.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@org.springframework.stereotype.Component
public class ShowPostFrame
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(ShowPostFrame.class);
    @Autowired
    private ApplicationContext context;
    private Map<Long, ShowPostPanel> postPanelMap = new HashMap<Long, ShowPostPanel>();
    private JTabbedPane tabbedPane;

    public ShowPostFrame() {
        this.initComponents();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShowPostPanel postPanel = (ShowPostPanel)ShowPostFrame.this.tabbedPane.getSelectedComponent();
                if (postPanel != null && postPanel.isNeedResizeImage()) {
                    postPanel.updateImage();
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ShowPostPanel postPanel = (ShowPostPanel)ShowPostFrame.this.tabbedPane.getSelectedComponent();
                    ShowPostFrame.this.tabbedPane.remove(postPanel);
                    ShowPostFrame.this.postPanelMap.values().remove(postPanel);
                    if (ShowPostFrame.this.postPanelMap.isEmpty()) {
                        ShowPostFrame.this.setVisible(false);
                    }
                }
            }
        });
        this.rootPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ShowPostPanel postPanel = (ShowPostPanel)ShowPostFrame.this.tabbedPane.getSelectedComponent();
                if (postPanel != null) {
                    postPanel.updateImage();
                }
            }
        });
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.tabbedPane.removeAll();
            this.postPanelMap.clear();
        }
    }

    @Override
    @PreDestroy
    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setTitle("Post");
        this.setMinimumSize(new Dimension(800, 650));
        this.setName("");
        this.setPreferredSize(new Dimension(800, 650));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    public void showPost(final Post post) {
        ShowPostPanel postPanel = this.postPanelMap.get(post.getId());
        if (postPanel == null) {
            postPanel = (ShowPostPanel)this.context.getBean(ShowPostPanel.class);
            postPanel.addLoadingListener(new ShowPostPanel.LoadingListener(){

                @Override
                public void loading(ShowPostPanel.LoadingEvent event) {
                    int index = ShowPostFrame.this.tabbedPane.indexOfComponent(event.getSource());
                    ShowPostFrame.this.tabbedPane.setTitleAt(index, post.getId() + "*");
                    ShowPostFrame.this.tabbedPane.setIconAt(index, null);
                }

                @Override
                public void done(ShowPostPanel.LoadingEvent event) {
                    int index = ShowPostFrame.this.tabbedPane.indexOfComponent(event.getSource());
                    if (ShowPostFrame.this.tabbedPane.getIconAt(index) == null && event.getSource().getImage() != null) {
                        ShowPostFrame.this.tabbedPane.setIconAt(index, new ImageIcon(Utils.resizeImage(event.getSource().getImage(), 32.0, 32.0)));
                    }
                    ShowPostFrame.this.tabbedPane.setTitleAt(index, String.valueOf(post.getId()));
                }
            });
            this.tabbedPane.addTab(null, null, postPanel);
            this.postPanelMap.put(post.getId(), postPanel);
            postPanel.showPost(post);
        }
        this.tabbedPane.setSelectedComponent(postPanel);
    }
}

