/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import io.github.azige.moebooruviewer.Post;
import io.github.azige.moebooruviewer.SiteConfig;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NetIO {
    public static final String PREVIEW_DIR_NAME = "previews";
    public static final String SAMPLE_DIR_NAME = "samples";
    public static final String ORIGIN_DIR_NAME = "origins";
    public static final String TAG_DIR_NAME = "tags";
    private static final Logger logger = LoggerFactory.getLogger(NetIO.class);
    @Autowired
    private SiteConfig siteConfig;
    private int maxRetryCount = 5;
    private File cacheDir;
    private File previewDir;
    private File sampleDir;
    private File originDir;
    private boolean forceHttps = true;
    private final Map<File, Object> fileLockerMap = new HashMap<File, Object>();

    @PostConstruct
    private void init() {
        this.cacheDir = new File(this.siteConfig.getName());
        this.previewDir = new File(this.cacheDir, PREVIEW_DIR_NAME);
        this.sampleDir = new File(this.cacheDir, SAMPLE_DIR_NAME);
        this.originDir = new File(this.cacheDir, ORIGIN_DIR_NAME);
    }

    public <S> S retry(SupplierThrowsIOException<S> supplier) {
        int count = 0;
        while (true) {
            try {
                return supplier.supply();
            }
            catch (IOException ex) {
                if (++count > this.maxRetryCount) {
                    logger.info("IO\u5f02\u5e38\uff0c\u653e\u5f03\u91cd\u8bd5", (Throwable)ex);
                    return null;
                }
                logger.info("IO\u5f02\u5e38\uff0c\u91cd\u8bd5", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    public void retry(RunnableThrowsIOException runnable) {
        this.retry(() -> {
            runnable.run();
            return null;
        });
    }

    public InputStream openStream(URL url) throws IOException {
        URL u = this.forceHttps ? new URL(url.toString().replace("http:", "https:")) : url;
        logger.info("downloading: {}", (Object)u);
        URLConnection connection = u.openConnection();
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        return connection.getInputStream();
    }

    public Image loadPreview(Post post) {
        return this.loadPreview(post, false);
    }

    public Image loadPreview(Post post, boolean force) {
        long id = post.getId();
        File previewFile = new File(this.previewDir, id + ".jpg");
        return this.loadImage(previewFile, post.getPreviewUrl(), force);
    }

    public File getSampleFile(Post post) {
        return new File(this.sampleDir, post.getId() + ".jpg");
    }

    public Image loadSample(Post post) {
        return this.loadSample(post, false);
    }

    public Image loadSample(Post post, boolean force) {
        long id = post.getId();
        File sampleFile = this.getSampleFile(post);
        return this.loadImage(sampleFile, post.getSampleUrl(), force);
    }

    public File getOriginFile(Post post) {
        try {
            return new File(this.originDir, URLDecoder.decode(post.getOriginUrl().replaceFirst(".*/", ""), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("URL\u7f16\u7801\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }

    public Image loadOrigin(Post post) {
        return this.loadOrigin(post, false);
    }

    public Image loadOrigin(Post post, boolean force) {
        File originFile = this.getOriginFile(post);
        return this.loadImage(originFile, post.getOriginUrl(), force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image loadImage(File localFile, String url, boolean force) {
        if (this.cacheFile(localFile, url, force)) {
            for (int i = 0; i < 5; ++i) {
                try {
                    Class<ImageIO> clazz = ImageIO.class;
                    synchronized (ImageIO.class) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return ImageIO.read(localFile);
                    }
                }
                catch (IOException ex) {
                    logger.warn("\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u51fa\u9519", (Throwable)ex);
                    continue;
                }
            }
        }
        return null;
    }

    public boolean cacheFile(File localFile, String url) {
        return this.cacheFile(localFile, url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheFile(File localFile, String url, boolean force) {
        Object locker;
        Object object = this.fileLockerMap;
        synchronized (object) {
            locker = this.fileLockerMap.get(localFile);
            if (locker == null) {
                locker = new Object();
                this.fileLockerMap.put(localFile, locker);
            }
        }
        object = locker;
        synchronized (object) {
            if (!localFile.exists() || force) {
                Object flag;
                File dir = localFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((flag = this.retry(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                })) != null) {
                    return true;
                }
                localFile.delete();
                return false;
            }
            return true;
        }
    }

    public boolean cleanCache() {
        try {
            FileUtils.deleteDirectory((File)this.cacheDir);
            return true;
        }
        catch (IOException ex) {
            logger.warn("\u5220\u9664\u7f13\u5b58\u76ee\u5f55\u5931\u8d25\uff01", (Throwable)ex);
            return false;
        }
    }

    @FunctionalInterface
    public static interface RunnableThrowsIOException {
        public void run() throws IOException;
    }

    @FunctionalInterface
    public static interface SupplierThrowsIOException<S> {
        public S supply() throws IOException;
    }
}

