/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.azige.moebooruviewer.ListPostFrame;
import io.github.azige.moebooruviewer.MoebooruAPI;
import io.github.azige.moebooruviewer.SiteConfig;
import io.github.azige.moebooruviewer.Tag;
import io.github.azige.moebooruviewer.UserSetting;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@ComponentScan
@Component
public class MoebooruViewer {
    private static final Logger logger = LoggerFactory.getLogger(MoebooruViewer.class);
    private static final String TAG_FILE_NAME = "tags.json";
    private static final String SETTING_FILE_NAME = "user-settings.xml";
    private static final int THREAD_POOL_SIZE = 10;
    @Autowired
    private AnnotationConfigApplicationContext context;
    @Autowired
    private SiteConfig siteConfig;
    @Autowired
    private ExecutorService executor;
    @Autowired
    private MoebooruAPI mapi;
    @Autowired
    private UserSetting userSetting;
    private Set<ListPostFrame> listPostFrames = new HashSet<ListPostFrame>();

    @PostConstruct
    private void init() {
        logger.info("init");
        File tagFile = new File(this.siteConfig.getName(), TAG_FILE_NAME);
        if (tagFile.exists()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode root = mapper.readTree(tagFile);
                ArrayList keys = new ArrayList();
                root.fieldNames().forEachRemaining(keys::add);
                Map<String, Tag> tagMap = keys.stream().collect(Collectors.toMap(Function.identity(), key -> mapper.convertValue((Object)root.get((String)key), Tag.class)));
                this.mapi.setTagMap(tagMap);
            }
            catch (IOException ex) {
                logger.warn("\u65e0\u6cd5\u8bfb\u53d6tag\u8bb0\u5f55\u6587\u4ef6", (Throwable)ex);
            }
        }
    }

    public void listPosts(String ... tags) {
        ListPostFrame listPostFrame = (ListPostFrame)this.context.getBean(ListPostFrame.class);
        if (this.userSetting.isSafeMode()) {
            tags = Arrays.copyOf(tags, tags.length + 1);
            tags[tags.length - 1] = "rating:s";
        }
        listPostFrame.setTags(tags);
        listPostFrame.setVisible(true);
        listPostFrame.loadImages();
        this.listPostFrames.add(listPostFrame);
        listPostFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MoebooruViewer.this.listPostFrames.remove((ListPostFrame)e.getWindow());
                if (MoebooruViewer.this.listPostFrames.isEmpty()) {
                    MoebooruViewer.this.context.close();
                }
            }
        });
    }

    public void switchSite(SiteConfig siteConfig) {
        this.context.close();
        this.userSetting.setSiteConfig(siteConfig);
        ApplicationContext context = MoebooruViewer.buildContext(this.userSetting);
        ((MoebooruViewer)context.getBean(MoebooruViewer.class)).listPosts(new String[0]);
    }

    public void exit() {
        this.context.close();
    }

    @PreDestroy
    private void destroy() {
        logger.info("destroy");
        this.listPostFrames.forEach(Window::dispose);
        this.executor.shutdownNow();
        ObjectMapper mapper = new ObjectMapper();
        File tagFile = new File(this.siteConfig.getName(), TAG_FILE_NAME);
        try {
            mapper.writeValue(tagFile, this.mapi.getTagMap());
        }
        catch (IOException ex) {
            logger.warn("\u65e0\u6cd5\u8bfb\u53d6tag\u8bb0\u5f55\u6587\u4ef6", (Throwable)ex);
        }
        JAXB.marshal((Object)this.userSetting, (File)new File(SETTING_FILE_NAME));
    }

    private static ApplicationContext buildContext(UserSetting userSetting) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.getBeanFactory().registerResolvableDependency(ExecutorService.class, (Object)Executors.newFixedThreadPool(10));
        context.getBeanFactory().registerResolvableDependency(SiteConfig.class, (Object)userSetting.getSiteConfig());
        context.getBeanFactory().registerResolvableDependency(UserSetting.class, (Object)userSetting);
        context.register(new Class[]{MoebooruViewer.class});
        context.registerShutdownHook();
        context.refresh();
        return context;
    }

    public static void main(String[] args) {
        UserSetting setting = null;
        File settingFile = new File(SETTING_FILE_NAME);
        if (settingFile.exists()) {
            try {
                setting = (UserSetting)JAXB.unmarshal((File)settingFile, UserSetting.class);
            }
            catch (RuntimeException ex) {
                logger.warn("\u8bfb\u53d6\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)ex);
            }
        }
        if (setting == null) {
            setting = UserSetting.createDefaultSetting();
        }
        if (setting.getLookAndFeel() != null) {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!setting.getLookAndFeel().equals(info.getName())) continue;
                try {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                    logger.warn("\u8bbe\u7f6e L&F \u65f6\u51fa\u9519", (Throwable)ex);
                }
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                LookAndFeel laf = UIManager.getLookAndFeel();
                setting.setLookAndFeel(laf.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                logger.warn("\u8bbe\u7f6e L&F \u65f6\u51fa\u9519", (Throwable)ex);
            }
        }
        ApplicationContext context = MoebooruViewer.buildContext(setting);
        SwingUtilities.invokeLater(() -> ((MoebooruViewer)context.getBean(MoebooruViewer.class)).listPosts(new String[0]));
    }
}

