/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.azige.moebooruviewer.NetIO;
import io.github.azige.moebooruviewer.Post;
import io.github.azige.moebooruviewer.SiteConfig;
import io.github.azige.moebooruviewer.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MoebooruAPI {
    private static final int LIMIT = 20;
    private static final String POSTS_PATH = "/post.json";
    private static final String TAG_PATH = "/tag.json";
    private static final Logger logger = LoggerFactory.getLogger(MoebooruAPI.class);
    @Autowired
    private SiteConfig siteConfig;
    @Autowired
    private NetIO netIO;
    private Map<String, Tag> tagMap = new ConcurrentHashMap<String, Tag>();
    private ObjectMapper mapper = new ObjectMapper();

    public List<Post> listPosts() throws IOException {
        return this.listPosts(1, 20, new String[0]);
    }

    public List<Post> listPosts(int page) throws IOException {
        return this.listPosts(page, 20, new String[0]);
    }

    public List<Post> listPosts(int page, String ... tags) throws IOException {
        return this.listPosts(page, 20, tags);
    }

    public List<Post> listPosts(int page, int limit, String ... tags) throws IOException {
        ArrayList<String> tagList = new ArrayList<String>(Arrays.asList(tags));
        String parameters = String.format("page=%d&limit=%d&tags=%s", page, limit, Stream.of(tags).reduce((s1, s2) -> s1 + "+" + s2).orElse(""));
        URL url = new URL(this.siteConfig.getRootUrl() + POSTS_PATH + "?" + parameters);
        try (InputStream input = this.netIO.openStream(url);){
            JsonNode posts = this.mapper.readTree(input);
            ArrayList<Post> postList = new ArrayList<Post>();
            posts.forEach(post -> postList.add(this.mapper.convertValue(post, Post.class)));
            ArrayList<Post> arrayList = postList;
            return arrayList;
        }
    }

    public Map<String, Tag> getTagMap() {
        return this.tagMap;
    }

    public void setTagMap(Map<String, Tag> tagMap) {
        this.tagMap = tagMap;
    }

    public Tag findTag(String name) throws IOException {
        Tag tag = this.tagMap.get(name);
        if (tag != null) {
            return tag;
        }
        String parameters = String.format("name=%s", name);
        URL url = new URL(this.siteConfig.getRootUrl() + TAG_PATH + "?" + parameters);
        try (InputStream input = this.netIO.openStream(url);){
            JsonNode tags = this.mapper.readTree(input);
            for (JsonNode tagNode : tags) {
                tag = this.mapper.convertValue((Object)tagNode, Tag.class);
                if (!tag.getName().equals(name)) continue;
                this.tagMap.put(name, tag);
                Tag tag2 = tag;
                return tag2;
            }
            Iterator<JsonNode> iterator = null;
            return iterator;
        }
    }
}

