/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import io.github.azige.moebooruviewer.ConfigDialog;
import io.github.azige.moebooruviewer.MoebooruAPI;
import io.github.azige.moebooruviewer.MoebooruViewer;
import io.github.azige.moebooruviewer.NetIO;
import io.github.azige.moebooruviewer.Post;
import io.github.azige.moebooruviewer.ShowPostFrame;
import io.github.azige.moebooruviewer.SiteConfig;
import io.github.azige.moebooruviewer.UserSetting;
import io.github.azige.moebooruviewer.Utils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ListPostFrame
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(ListPostFrame.class);
    private static final int SAMPLE_WIDTH = 150;
    private static final int SAMPLE_HEIGHT = 100;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private SiteConfig siteConfig;
    @Autowired
    private MoebooruViewer moebooruViewer;
    @Autowired
    private NetIO netIO;
    @Autowired
    private ExecutorService executor;
    @Autowired
    private MoebooruAPI mapi;
    @Autowired
    private ShowPostFrame postFrame;
    @Autowired
    private UserSetting userSetting;
    private int pageCount = 1;
    private Set<Post> posts = new HashSet<Post>();
    private final JLabel loadMoreLabel;
    private String[] tags = new String[0];
    private int pageSize;
    private JMenuItem cleanCacheMenuItem;
    private JMenuItem configMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JMenuItem jumpPageMenuItem;
    private JMenuItem openPostMenuItem;
    private JPanel postsPanel;
    private JScrollPane scrollPane;
    private JMenu searchHistoryMenu;
    private JMenuItem searchTagMenuItem;
    private JMenuItem showVersionMenuItem;
    private JMenuItem switchKonachanMenuItem;
    private JMenuItem switchYandereMenuItem;

    public ListPostFrame() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.postsPanel.setLayout(new FlowLayout(){

            @Override
            public void layoutContainer(Container target) {
                int columnCount = target.getSize().width / (150 + this.getHgap());
                int rowCount = ListPostFrame.this.posts.size() / columnCount + 1;
                target.setPreferredSize(new Dimension(1, rowCount * (100 + this.getVgap()) + this.getVgap()));
                super.layoutContainer(target);
            }
        });
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.loadMoreLabel = new JLabel("\u52a0\u8f7d\u66f4\u591a");
        this.loadMoreLabel.setForeground(Color.WHITE);
        this.loadMoreLabel.setHorizontalAlignment(0);
        this.loadMoreLabel.setPreferredSize(new Dimension(150, 100));
        this.loadMoreLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.loadMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ListPostFrame.this.loadMoreLabel.isEnabled()) {
                    ListPostFrame.this.loadImages();
                }
            }
        });
        this.postsPanel.add(this.loadMoreLabel);
    }

    @PostConstruct
    private void init() {
        this.setTitle(this.siteConfig.getName() + " Viewer");
        this.pageSize = this.userSetting.getPageSize();
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = Objects.requireNonNull(tags);
        this.refreshTitle();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201 || e.getID() == 202) {
            // empty if block
        }
    }

    private void refreshTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.siteConfig.getName()).append(" Viewer");
        sb.append(" [page: ").append(this.pageCount).append("]");
        if (this.tags.length > 0) {
            sb.append(" [").append(Stream.of(this.tags).reduce((a, b) -> a + " " + b).get()).append("]");
        }
        this.setTitle(sb.toString());
    }

    public void loadImages() {
        this.loadMoreLabel.setText("\u52a0\u8f7d\u4e2d\u2026\u2026");
        this.loadMoreLabel.setEnabled(false);
        this.refreshTitle();
        this.executor.execute(() -> {
            List postList = this.netIO.retry(() -> this.mapi.listPosts(this.pageCount, this.pageSize, this.tags));
            SwingUtilities.invokeLater(() -> {
                ++this.pageCount;
                this.postsPanel.remove(this.loadMoreLabel);
                for (final Post post : postList) {
                    if (this.posts.contains(post)) continue;
                    this.posts.add(post);
                    final JLabel label = new JLabel("\u52a0\u8f7d\u4e2d\u2026\u2026");
                    label.setForeground(Color.WHITE);
                    label.setHorizontalAlignment(0);
                    label.setPreferredSize(new Dimension(150, 100));
                    label.setCursor(Cursor.getPredefinedCursor(12));
                    label.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (SwingUtilities.isLeftMouseButton(e)) {
                                ListPostFrame.this.showPost(post);
                            } else if (SwingUtilities.isRightMouseButton(e)) {
                                label.setIcon(null);
                                label.setText("\u52a0\u8f7d\u4e2d\u2026\u2026");
                                class LoadImageTask
                                implements Runnable {
                                    boolean force = false;
                                    final /* synthetic */ Post val$post;
                                    final /* synthetic */ JLabel val$label;

                                    LoadImageTask() {
                                        this.val$post = post;
                                        this.val$label = jLabel;
                                    }

                                    @Override
                                    public void run() {
                                        Image image = ListPostFrame.this.netIO.loadPreview(this.val$post, this.force);
                                        SwingUtilities.invokeLater(() -> {
                                            if (image != null) {
                                                this.val$label.setText("");
                                                Dimension size = this.val$label.getPreferredSize();
                                                this.val$label.setIcon(new ImageIcon(Utils.resizeImage(image, size.getWidth(), size.getHeight())));
                                            } else {
                                                this.val$label.setText("\u52a0\u8f7d\u5931\u8d25\uff01");
                                            }
                                        });
                                    }
                                }
                                LoadImageTask task = new LoadImageTask(ListPostFrame.this, post, label);
                                task.force = true;
                                ListPostFrame.this.executor.execute(task);
                            }
                        }
                    });
                    this.postsPanel.add(label);
                    LoadImageTask task = new LoadImageTask();
                    this.executor.execute(task);
                }
                this.postsPanel.add(this.loadMoreLabel);
                if (!postList.isEmpty()) {
                    this.loadMoreLabel.setText("\u52a0\u8f7d\u66f4\u591a");
                    this.loadMoreLabel.setEnabled(true);
                } else {
                    this.loadMoreLabel.setText("\u6ca1\u6709\u66f4\u591a\u4e86");
                }
            });
        });
    }

    public void clear() {
        this.posts.clear();
        this.postsPanel.removeAll();
        this.postsPanel.add(this.loadMoreLabel);
        this.repaint();
    }

    private void showPost(Post post) {
        this.postFrame.setVisible(true);
        this.postFrame.showPost(post);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.postsPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.openPostMenuItem = new JMenuItem();
        this.jumpPageMenuItem = new JMenuItem();
        this.searchTagMenuItem = new JMenuItem();
        this.searchHistoryMenu = new JMenu();
        this.jMenu2 = new JMenu();
        this.switchKonachanMenuItem = new JMenuItem();
        this.switchYandereMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.configMenuItem = new JMenuItem();
        this.cleanCacheMenuItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.showVersionMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Moebooru Viewer");
        this.setMinimumSize(new Dimension(850, 650));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.postsPanel.setBackground(new Color(34, 34, 34));
        this.postsPanel.setPreferredSize(new Dimension(800, 10000));
        this.postsPanel.setLayout(new FlowLayout(0));
        this.scrollPane.setViewportView(this.postsPanel);
        this.jMenu1.setText("\u529f\u80fd");
        this.jMenu1.setMinimumSize(new Dimension(200, 0));
        this.openPostMenuItem.setText("\u6309id\u68c0\u7d22Post");
        this.openPostMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.openPostMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openPostMenuItem);
        this.jumpPageMenuItem.setText("\u8df3\u81f3\u9875\u6570");
        this.jumpPageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.jumpPageMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jumpPageMenuItem);
        this.searchTagMenuItem.setText("\u641c\u7d22tag");
        this.searchTagMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.searchTagMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.searchTagMenuItem);
        this.searchHistoryMenu.setText("\u641c\u7d22\u5386\u53f2");
        this.searchHistoryMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ListPostFrame.this.searchHistoryMenuMouseEntered(evt);
            }
        });
        this.jMenu1.add(this.searchHistoryMenu);
        this.jMenu2.setText("\u5207\u6362\u7ad9\u70b9");
        this.switchKonachanMenuItem.setText("Konachan.com");
        this.switchKonachanMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.switchKonachanMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.switchKonachanMenuItem);
        this.switchYandereMenuItem.setText("yande.re");
        this.switchYandereMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.switchYandereMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.switchYandereMenuItem);
        this.jMenu1.add(this.jMenu2);
        this.jMenu1.add(this.jSeparator1);
        this.exitMenuItem.setText("\u9000\u51fa");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu4.setText("\u8bbe\u7f6e");
        this.configMenuItem.setText("\u8bbe\u7f6e");
        this.configMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.configMenuItemActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.configMenuItem);
        this.cleanCacheMenuItem.setText("\u6e05\u7a7a\u7f13\u5b58");
        this.cleanCacheMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.cleanCacheMenuItemActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.cleanCacheMenuItem);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenu3.setText("\u5e2e\u52a9");
        this.showVersionMenuItem.setText("\u7248\u672c");
        this.showVersionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListPostFrame.this.showVersionMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.showVersionMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 850, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 629, Short.MAX_VALUE));
        this.pack();
    }

    private void searchTagMenuItemActionPerformed(ActionEvent evt) {
        String keywords = JOptionPane.showInputDialog(this, (Object)"\u8f93\u5165\u8981\u641c\u7d22\u7684tag\uff0c\u7528\u7a7a\u683c\u5206\u9694");
        if (keywords != null) {
            this.moebooruViewer.listPosts(keywords.split(" "));
            this.userSetting.addSearchHistory(keywords);
        }
    }

    private void switchKonachanMenuItemActionPerformed(ActionEvent evt) {
        this.moebooruViewer.switchSite(SiteConfig.KONACHAN);
    }

    private void switchYandereMenuItemActionPerformed(ActionEvent evt) {
        this.moebooruViewer.switchSite(SiteConfig.YANDERE);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.moebooruViewer.exit();
    }

    private void jumpPageMenuItemActionPerformed(ActionEvent evt) {
        String pageString = JOptionPane.showInputDialog(this, (Object)"\u8f93\u5165\u8981\u8df3\u8f6c\u5230\u7684\u9875\u6570");
        if (pageString != null) {
            this.pageCount = Integer.parseInt(pageString);
            this.clear();
            this.loadImages();
        }
    }

    private void searchHistoryMenuMouseEntered(MouseEvent evt) {
        this.searchHistoryMenu.removeAll();
        this.userSetting.getSearchHistories().forEach(keywords -> {
            JMenuItem menuItem = new JMenuItem((String)keywords);
            menuItem.addActionListener(event -> this.moebooruViewer.listPosts(keywords.split(" ")));
            this.searchHistoryMenu.add(menuItem);
        });
    }

    private void showVersionMenuItemActionPerformed(ActionEvent evt) {
        try {
            String version = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/io/github/azige/moebooruviewer/version"));
            JOptionPane.showMessageDialog(this, version);
        }
        catch (IOException ex) {
            logger.error("\u65e0\u6cd5\u8bfb\u53d6\u7248\u672c\u6807\u8bb0", (Throwable)ex);
        }
    }

    private void openPostMenuItemActionPerformed(ActionEvent evt) {
        String id = JOptionPane.showInputDialog(this, (Object)"\u8f93\u5165\u8981\u68c0\u7d22\u7684id");
        if (id != null) {
            JOptionPane optionPane = new JOptionPane("\u68c0\u7d22\u4e2d\uff1a" + id, 1);
            JButton button = new JButton("\u53d6\u6d88");
            optionPane.setOptions(new Object[]{button});
            JDialog dialog = optionPane.createDialog(this, "\u6b63\u5728\u68c0\u7d22\u2026\u2026");
            button.addActionListener(event -> dialog.dispose());
            dialog.setModal(false);
            dialog.setVisible(true);
            this.executor.execute(() -> {
                List searchPosts = this.netIO.retry(() -> this.mapi.listPosts(1, 1, "id:" + id));
                SwingUtilities.invokeLater(() -> {
                    if (dialog.isDisplayable()) {
                        dialog.dispose();
                        if (!searchPosts.isEmpty()) {
                            this.showPost((Post)searchPosts.get(0));
                        } else {
                            JOptionPane.showMessageDialog(this, "\u68c0\u7d22\u7684id\u4e0d\u5b58\u5728\uff01");
                        }
                    }
                });
            });
        }
    }

    private void configMenuItemActionPerformed(ActionEvent evt) {
        ConfigDialog configDialog = (ConfigDialog)this.context.getBean(ConfigDialog.class);
        configDialog.setLocationRelativeTo(this);
        configDialog.setVisible(true);
    }

    private void cleanCacheMenuItemActionPerformed(ActionEvent evt) {
        if (this.netIO.cleanCache()) {
            JOptionPane.showMessageDialog(this, "\u5220\u9664\u6210\u529f\uff01");
        } else {
            JOptionPane.showMessageDialog(this, "\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

